/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.interfaces.IMultiblockNetworkHandler;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedNetPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedstonePort;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityBeefBase;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityInventory;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityPoweredInventoryFluid;
import erogenousbeef.bigreactors.net.PacketWrapper;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class ClientPacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        int packetType = PacketWrapper.readPacketID(data);
        switch (packetType) {
            case 1: 
            case 14: 
            case 17: {
                try {
                    int x = data.readInt();
                    int y = data.readInt();
                    int z = data.readInt();
                    TileEntity te = ((EntityPlayer)player).field_70170_p.func_72796_p(x, y, z);
                    if (!(te instanceof IMultiblockNetworkHandler)) {
                        throw new IOException("Invalid TileEntity for receipt of multiblock packet");
                    }
                    ((IMultiblockNetworkHandler)te).onNetworkPacket(packetType, data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 10: {
                try {
                    int x = data.readInt();
                    int y = data.readInt();
                    int z = data.readInt();
                    TileEntity te = ((EntityPlayer)player).field_70170_p.func_72796_p(x, y, z);
                    if (!(te instanceof TileEntityReactorPart)) break;
                    MultiblockReactor.WasteEjectionSetting newSetting = MultiblockReactor.WasteEjectionSetting.values()[data.readInt()];
                    ((TileEntityReactorPart)te).getReactorController().setWasteEjection(newSetting);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                try {
                    int x = data.readInt();
                    int y = data.readInt();
                    int z = data.readInt();
                    TileEntity te = ((EntityPlayer)player).field_70170_p.func_72796_p(x, y, z);
                    if (te == null || !(te instanceof TileEntityBeefBase)) {
                        throw new IOException("Invalid TileEntity for receipt of BeefBase UI Update packet");
                    }
                    NBTTagCompound tagCompound = Packet.func_73283_d((DataInput)data);
                    ((TileEntityBeefBase)te).onReceiveUpdate(tagCompound);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 5: {
                try {
                    int x = data.readInt();
                    int y = data.readInt();
                    int z = data.readInt();
                    TileEntity te = ((EntityPlayer)player).field_70170_p.func_72796_p(x, y, z);
                    if (te == null || !(te instanceof TileEntityBeefBase)) {
                        throw new IOException("Invalid TileEntity for receipt of BeefBase Rotation Update packet");
                    }
                    ((TileEntityBeefBase)te).rotateTowards(ForgeDirection.getOrientation((int)data.readInt()));
                    ((EntityPlayer)player).field_70170_p.func_72845_h(x, y, z);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 6: {
                try {
                    int x = data.readInt();
                    int y = data.readInt();
                    int z = data.readInt();
                    TileEntity te = ((EntityPlayer)player).field_70170_p.func_72796_p(x, y, z);
                    if (te == null || !(te instanceof TileEntityInventory)) break;
                    ((TileEntityInventory)te).setExposedInventorySlotReference(data.readInt(), data.readInt());
                    ((EntityPlayer)player).field_70170_p.func_72845_h(x, y, z);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 7: {
                try {
                    int x = data.readInt();
                    int y = data.readInt();
                    int z = data.readInt();
                    TileEntity te = ((EntityPlayer)player).field_70170_p.func_72796_p(x, y, z);
                    if (te == null || !(te instanceof TileEntityPoweredInventoryFluid)) break;
                    ((TileEntityPoweredInventoryFluid)te).setExposedTank(ForgeDirection.getOrientation((int)data.readInt()), data.readInt());
                    ((EntityPlayer)player).field_70170_p.func_72845_h(x, y, z);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 8: {
                try {
                    int x = data.readInt();
                    int y = data.readInt();
                    int z = data.readInt();
                    TileEntity te = ((EntityPlayer)player).field_70170_p.func_72796_p(x, y, z);
                    if (te == null || !(te instanceof TileEntityReactorControlRod)) break;
                    short controlRodInsertion = data.readShort();
                    ((TileEntityReactorControlRod)te).onControlRodUpdate(controlRodInsertion);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 12: {
                try {
                    int x = data.readInt();
                    int y = data.readInt();
                    int z = data.readInt();
                    TileEntity te = ((EntityPlayer)player).field_70170_p.func_72796_p(x, y, z);
                    if (!(te instanceof TileEntityReactorRedNetPort)) break;
                    ((TileEntityReactorRedNetPort)te).decodeSettings(data, false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 13: {
                try {
                    int x = data.readInt();
                    int y = data.readInt();
                    int z = data.readInt();
                    TileEntity te = ((EntityPlayer)player).field_70170_p.func_72796_p(x, y, z);
                    if (!(te instanceof TileEntityReactorRedstonePort)) break;
                    int newCircuit = data.readInt();
                    int newLevel = data.readInt();
                    boolean newGt = data.readBoolean();
                    boolean pulse = data.readBoolean();
                    ((TileEntityReactorRedstonePort)te).onReceiveUpdatePacket(newCircuit, newLevel, newGt, pulse);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

