/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.gui.IBeefGuiControl;
import erogenousbeef.bigreactors.gui.IBeefListBoxEntry;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import erogenousbeef.bigreactors.gui.controls.BeefGuiListBox;
import erogenousbeef.bigreactors.gui.controls.grab.IBeefGuiGrabbable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class BeefGuiBase
extends GuiContainer {
    protected List<IBeefGuiControl> controls;
    protected List<IBeefTooltipControl> controlsWithTooltips;
    protected List<GuiTextField> textFields;
    protected IBeefGuiGrabbable grabbedItem = null;

    public BeefGuiBase(Container container) {
        super(container);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.controls = new ArrayList<IBeefGuiControl>();
        this.controlsWithTooltips = new ArrayList<IBeefTooltipControl>();
        this.textFields = new ArrayList<GuiTextField>();
    }

    public void registerControl(GuiTextField newTextField) {
        this.textFields.add(newTextField);
    }

    public void registerControl(IBeefGuiControl newControl) {
        this.controls.add(newControl);
        if (newControl instanceof IBeefTooltipControl) {
            this.controlsWithTooltips.add((IBeefTooltipControl)((Object)newControl));
        }
    }

    public void registerControl(GuiButton newButton) {
        this.field_73887_h.add(newButton);
        if (newButton instanceof IBeefTooltipControl) {
            this.controlsWithTooltips.add((IBeefTooltipControl)newButton);
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_73886_k;
    }

    protected void func_74185_a(float gameTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_110577_a(this.getGuiBackground());
        this.func_73729_b(this.field_74198_m, this.field_74197_n, 0, 0, this.field_74194_b, this.field_74195_c);
        int relativeX = mouseX - this.field_74198_m;
        int relativeY = mouseY - this.field_74197_n;
        for (IBeefGuiControl c : this.controls) {
            c.drawBackground(this.field_73882_e.field_71446_o, relativeX, relativeY);
        }
        for (GuiTextField field : this.textFields) {
            field.func_73795_f();
        }
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        int absoluteX = mouseX - this.field_74198_m;
        int absoluteY = mouseY - this.field_74197_n;
        for (IBeefGuiControl c : this.controls) {
            c.drawForeground(this.field_73882_e.field_71446_o, mouseX, mouseY);
        }
        for (IBeefTooltipControl tc : this.controlsWithTooltips) {
            String[] tooltip;
            if (!tc.isVisible() || !tc.isMouseOver(mouseX, mouseY) || (tooltip = tc.getTooltip()) == null) continue;
            GL11.glPushAttrib((int)1048575);
            this.func_102021_a(Arrays.asList(tooltip), absoluteX, absoluteY);
            GL11.glPopAttrib();
            break;
        }
        if (this.grabbedItem != null) {
            this.field_73882_e.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_94065_a(absoluteX + 1, absoluteY + 1, this.grabbedItem.getIcon(), 16, 16);
        }
    }

    protected void func_73864_a(int x, int y, int buttonIndex) {
        super.func_73864_a(x, y, buttonIndex);
        for (GuiTextField field : this.textFields) {
            field.func_73793_a(x, y, buttonIndex);
        }
        for (IBeefGuiControl c : this.controls) {
            c.onMouseClicked(x, y, buttonIndex);
        }
    }

    public abstract ResourceLocation getGuiBackground();

    public int getGuiLeft() {
        return this.field_74198_m;
    }

    public int getGuiTop() {
        return this.field_74197_n;
    }

    public void onListBoxSelectionChanged(BeefGuiListBox listBox, IBeefListBoxEntry selectedEntry) {
    }

    public void onListBoxEntryClicked(BeefGuiListBox listBox, IBeefListBoxEntry clickedEntry) {
    }

    public void setGrabbedItem(IBeefGuiGrabbable grabbedSource) {
        this.grabbedItem = grabbedSource;
    }

    public IBeefGuiGrabbable getGrabbedItem() {
        return this.grabbedItem;
    }

    public void onControlClicked(IBeefGuiControl control) {
    }
}

