/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import erogenousbeef.bigreactors.client.ClientProxy;
import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.gui.controls.BeefGuiFluidBar;
import erogenousbeef.bigreactors.gui.controls.BeefGuiFuelMixBar;
import erogenousbeef.bigreactors.gui.controls.BeefGuiHeatBar;
import erogenousbeef.bigreactors.gui.controls.BeefGuiIcon;
import erogenousbeef.bigreactors.gui.controls.BeefGuiLabel;
import erogenousbeef.bigreactors.gui.controls.BeefGuiPowerBar;
import erogenousbeef.bigreactors.gui.controls.GuiIconButton;
import erogenousbeef.bigreactors.net.PacketWrapper;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.common.CoordTriplet;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.ResourceLocation;

public class GuiReactorStatus
extends BeefGuiBase {
    private GuiIconButton btnReactorOn;
    private GuiIconButton btnReactorOff;
    private GuiIconButton btnWasteAutoEject;
    private GuiIconButton btnWasteManual;
    private GuiIconButton btnWasteEject;
    private TileEntityReactorPart part;
    private MultiblockReactor reactor;
    private BeefGuiLabel titleString;
    private BeefGuiLabel statusString;
    private BeefGuiIcon heatIcon;
    private BeefGuiLabel heatString;
    private BeefGuiIcon outputIcon;
    private BeefGuiLabel outputString;
    private BeefGuiIcon fuelConsumedIcon;
    private BeefGuiLabel fuelConsumedString;
    private BeefGuiIcon reactivityIcon;
    private BeefGuiLabel reactivityString;
    private BeefGuiPowerBar powerBar;
    private BeefGuiHeatBar coreHeatBar;
    private BeefGuiHeatBar caseHeatBar;
    private BeefGuiFuelMixBar fuelMixBar;
    private BeefGuiIcon coolantIcon;
    private BeefGuiFluidBar coolantBar;
    private BeefGuiIcon hotFluidIcon;
    private BeefGuiFluidBar hotFluidBar;
    private static final String[] passivelyCooledTooltip = new String[]{"\u00a7bEnergy Output", "", "This reactor is passively cooled", "and generates energy directly from", "the heat of its core."};
    private static final String[] activelyCooledTooltip = new String[]{"\u00a7bHot Fluid Output", "", "This reactor is actively cooled", "by a fluid, such as water, which", "is superheated by the core."};

    public GuiReactorStatus(Container container, TileEntityReactorPart tileEntityReactorPart) {
        super(container);
        this.field_74195_c = 186;
        this.part = tileEntityReactorPart;
        this.reactor = this.part.getReactorController();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xCenter = this.field_74198_m + this.field_74194_b / 2;
        int yCenter = this.field_74195_c / 2;
        this.btnReactorOn = new GuiIconButton(0, this.field_74198_m + 4, this.field_74197_n + 164, 18, 18, ClientProxy.GuiIcons.getIcon("On_off"));
        this.btnReactorOff = new GuiIconButton(1, this.field_74198_m + 22, this.field_74197_n + 164, 18, 18, ClientProxy.GuiIcons.getIcon("Off_off"));
        this.btnReactorOn.setTooltip(new String[]{"\u00a7bActivate Reactor"});
        this.btnReactorOff.setTooltip(new String[]{"\u00a7bDeactivate Reactor", "Residual heat will still", "generate power/consume coolant,", "until the reactor cools."});
        this.btnWasteAutoEject = new GuiIconButton(2, this.field_74198_m + 4, this.field_74197_n + 144, 18, 18, ClientProxy.GuiIcons.getIcon("wasteEject_off"));
        this.btnWasteManual = new GuiIconButton(4, this.field_74198_m + 22, this.field_74197_n + 144, 18, 18, ClientProxy.GuiIcons.getIcon("wasteManual_off"));
        this.btnWasteEject = new GuiIconButton(5, this.field_74198_m + 50, this.field_74197_n + 144, 18, 18, ClientProxy.GuiIcons.getIcon("wasteEject"));
        this.btnWasteEject.field_73748_h = false;
        this.btnWasteAutoEject.setTooltip(new String[]{"\u00a7bAuto-Eject Waste", "Waste in the core will be ejected", "as soon as possible"});
        this.btnWasteManual.setTooltip(new String[]{"\u00a7bDo Not Auto-Eject Waste", "\u00a7dWaste must be manually ejected.", "", "Ejection can be done from this", "screen, or via rednet,", "redstone or computer port signals."});
        this.btnWasteEject.setTooltip(new String[]{"\u00a7bEject Waste Now", "Ejects waste from the core", "into access ports.", "Each 1000mB waste = 1 ingot", "", "SHIFT: Dump excess waste, if any"});
        this.registerControl(this.btnReactorOn);
        this.registerControl(this.btnReactorOff);
        this.registerControl(this.btnWasteAutoEject);
        this.registerControl(this.btnWasteManual);
        this.registerControl(this.btnWasteEject);
        int leftX = this.field_74198_m + 4;
        int topY = this.field_74197_n + 4;
        this.titleString = new BeefGuiLabel(this, "Reactor Control", leftX, topY);
        this.heatIcon = new BeefGuiIcon(this, leftX - 2, topY += this.titleString.getHeight() + 4, 16, 16, ClientProxy.GuiIcons.getIcon("temperature"), new String[]{"\u00a7bCore Temperature", "", "Temperature inside the reactor core.", "Higher temperatures increase fuel burnup."});
        this.heatString = new BeefGuiLabel(this, "", leftX + 22, topY + 4);
        this.outputIcon = new BeefGuiIcon(this, leftX + 1, topY += this.heatIcon.getHeight() + 5);
        this.outputString = new BeefGuiLabel(this, "", leftX + 22, topY + 4);
        this.fuelConsumedIcon = new BeefGuiIcon(this, leftX + 1, topY += this.outputIcon.getHeight() + 5, 16, 16, ClientProxy.GuiIcons.getIcon("fuelUsageRate"), new String[]{"\u00a7bFuel Burnup Rate", "", "The rate at which fuel is", "fissioned into waste in the core."});
        this.fuelConsumedString = new BeefGuiLabel(this, "", leftX + 22, topY + 4);
        this.reactivityIcon = new BeefGuiIcon(this, leftX, topY += this.fuelConsumedIcon.getHeight() + 5, 16, 16, ClientProxy.GuiIcons.getIcon("reactivity"), new String[]{"\u00a7bFuel Reactivity", "", "How heavily irradiated the core is.", "Higher levels of radiation", "reduce fuel burnup."});
        this.reactivityString = new BeefGuiLabel(this, "", leftX + 22, topY + 4);
        this.statusString = new BeefGuiLabel(this, "", leftX + 1, topY += this.reactivityIcon.getHeight() + 6);
        topY += this.statusString.getHeight() + 4;
        this.powerBar = new BeefGuiPowerBar(this, this.field_74198_m + 152, this.field_74197_n + 22, this.reactor);
        this.coreHeatBar = new BeefGuiHeatBar((BeefGuiBase)this, this.field_74198_m + 130, this.field_74197_n + 22, "\u00a7bCore Heat", new String[]{"Heat of the reactor's fuel.", "High heat raises fuel usage.", "", "Core heat is transferred to", "the casing. Transfer rate", "is based on the design of", "the reactor's interior."});
        this.caseHeatBar = new BeefGuiHeatBar((BeefGuiBase)this, this.field_74198_m + 108, this.field_74197_n + 22, "\u00a7bCasing Heat", new String[]{"Heat of the reactor's casing.", "High heat raises energy output", "and coolant conversion."});
        this.fuelMixBar = new BeefGuiFuelMixBar(this, this.field_74198_m + 86, this.field_74197_n + 22, this.reactor);
        this.coolantIcon = new BeefGuiIcon(this, this.field_74198_m + 132, this.field_74197_n + 91, 16, 16, ClientProxy.GuiIcons.getIcon("coolantIn"), new String[]{"\u00a7bCoolant Fluid Tank", "", "Casing heat will superheat", "coolant in this tank."});
        this.coolantBar = new BeefGuiFluidBar((BeefGuiBase)this, this.field_74198_m + 131, this.field_74197_n + 108, this.reactor, 1);
        this.hotFluidIcon = new BeefGuiIcon(this, this.field_74198_m + 154, this.field_74197_n + 91, 16, 16, ClientProxy.GuiIcons.getIcon("hotFluidOut"), new String[]{"\u00a7bHot Fluid Tank", "", "Superheated coolant", "will pump into this tank,", "and must be piped out", "via coolant ports"});
        this.hotFluidBar = new BeefGuiFluidBar((BeefGuiBase)this, this.field_74198_m + 153, this.field_74197_n + 108, this.reactor, 0);
        this.registerControl(this.titleString);
        this.registerControl(this.statusString);
        this.registerControl(this.heatIcon);
        this.registerControl(this.heatString);
        this.registerControl(this.outputIcon);
        this.registerControl(this.outputString);
        this.registerControl(this.fuelConsumedIcon);
        this.registerControl(this.fuelConsumedString);
        this.registerControl(this.reactivityIcon);
        this.registerControl(this.reactivityString);
        this.registerControl(this.powerBar);
        this.registerControl(this.coreHeatBar);
        this.registerControl(this.caseHeatBar);
        this.registerControl(this.fuelMixBar);
        this.registerControl(this.coolantBar);
        this.registerControl(this.hotFluidBar);
        this.registerControl(this.coolantIcon);
        this.registerControl(this.hotFluidIcon);
        this.updateIcons();
    }

    @Override
    public ResourceLocation getGuiBackground() {
        return new ResourceLocation("bigreactors:textures/gui/ReactorController.png");
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateIcons();
        if (this.reactor.isActive()) {
            this.statusString.setLabelText("Status: \u00a72Online");
        } else {
            this.statusString.setLabelText("Status: \u00a74Offline");
        }
        this.outputString.setLabelText(this.getFormattedOutputString());
        if (this.reactor.isPassivelyCooled()) {
            this.outputString.setLabelTooltip(String.format("%.2f flux per tick", Float.valueOf(this.reactor.getEnergyGeneratedLastTick())));
        } else {
            this.outputString.setLabelTooltip(String.format("%.0f millibuckets per tick", Float.valueOf(this.reactor.getEnergyGeneratedLastTick())));
        }
        this.heatString.setLabelText(Integer.toString((int)this.reactor.getFuelHeat()) + " C");
        this.coreHeatBar.setHeat(this.reactor.getFuelHeat());
        this.caseHeatBar.setHeat(this.reactor.getReactorHeat());
        float fuelConsumption = this.reactor.getFuelConsumedLastTick();
        this.fuelConsumedString.setLabelText(StaticUtils.Strings.formatMillibuckets(fuelConsumption) + "/t");
        this.fuelConsumedString.setLabelTooltip(this.getFuelConsumptionTooltip(fuelConsumption));
        this.reactivityString.setLabelText(String.format("%2.0f%%", Float.valueOf(this.reactor.getFuelFertility() * 100.0f)));
    }

    protected void func_73875_a(GuiButton button) {
        CoordTriplet saveDelegate = this.reactor.getReferenceCoord();
        if (button.field_73741_f == 0 || button.field_73741_f == 1) {
            boolean newSetting;
            boolean bl = newSetting = button.field_73741_f == 0;
            if (newSetting != this.reactor.isActive()) {
                PacketDispatcher.sendPacketToServer((Packet)PacketWrapper.createPacket("BigReactors", 0, new Object[]{saveDelegate.x, saveDelegate.y, saveDelegate.z, newSetting}));
            }
        } else if (button.field_73741_f >= 2 && button.field_73741_f <= 4) {
            MultiblockReactor.WasteEjectionSetting newEjectionSetting;
            switch (button.field_73741_f) {
                case 4: {
                    newEjectionSetting = MultiblockReactor.WasteEjectionSetting.kManual;
                    break;
                }
                default: {
                    newEjectionSetting = MultiblockReactor.WasteEjectionSetting.kAutomatic;
                }
            }
            if (this.reactor.getWasteEjection() != newEjectionSetting) {
                PacketDispatcher.sendPacketToServer((Packet)PacketWrapper.createPacket("BigReactors", 10, new Object[]{saveDelegate.x, saveDelegate.y, saveDelegate.z, newEjectionSetting.ordinal()}));
            }
        } else if (button.field_73741_f == 5) {
            PacketDispatcher.sendPacketToServer((Packet)PacketWrapper.createPacket("BigReactors", 9, new Object[]{saveDelegate.x, saveDelegate.y, saveDelegate.z, false, GuiReactorStatus.func_73877_p(), false}));
        }
    }

    protected void updateIcons() {
        if (this.reactor.isActive()) {
            this.btnReactorOn.setIcon(ClientProxy.GuiIcons.getIcon(10));
            this.btnReactorOff.setIcon(ClientProxy.GuiIcons.getIcon(7));
        } else {
            this.btnReactorOn.setIcon(ClientProxy.GuiIcons.getIcon(9));
            this.btnReactorOff.setIcon(ClientProxy.GuiIcons.getIcon(8));
        }
        if (this.reactor.isPassivelyCooled()) {
            this.outputIcon.setIcon(ClientProxy.GuiIcons.getIcon("energyOutput"));
            this.outputIcon.setTooltip(passivelyCooledTooltip);
            this.coolantIcon.visible = false;
            this.coolantBar.visible = false;
            this.hotFluidIcon.visible = false;
            this.hotFluidBar.visible = false;
        } else {
            this.outputIcon.setIcon(ClientProxy.GuiIcons.getIcon("hotFluidOut"));
            this.outputIcon.setTooltip(activelyCooledTooltip);
            this.coolantIcon.visible = true;
            this.coolantBar.visible = true;
            this.hotFluidIcon.visible = true;
            this.hotFluidBar.visible = true;
        }
        switch (this.reactor.getWasteEjection()) {
            case kAutomatic: {
                this.btnWasteAutoEject.setIcon(ClientProxy.GuiIcons.getIcon(13));
                this.btnWasteManual.setIcon(ClientProxy.GuiIcons.getIcon(14));
                this.btnWasteEject.field_73748_h = false;
                break;
            }
            default: {
                this.btnWasteAutoEject.setIcon(ClientProxy.GuiIcons.getIcon(12));
                this.btnWasteManual.setIcon(ClientProxy.GuiIcons.getIcon(15));
                this.btnWasteEject.field_73748_h = true;
            }
        }
    }

    private String getFormattedOutputString() {
        float number = this.reactor.getEnergyGeneratedLastTick();
        if (this.reactor.isPassivelyCooled()) {
            return StaticUtils.Strings.formatRF(number) + "/t";
        }
        return StaticUtils.Strings.formatMillibuckets(number) + "/t";
    }

    private String getFuelConsumptionTooltip(float fuelConsumption) {
        if (fuelConsumption <= 1.0E-6f) {
            return "0 millibuckets per tick";
        }
        int exp = (int)Math.log10(fuelConsumption);
        int decimalPlaces = 0;
        if (exp < 1) {
            decimalPlaces = Math.abs(exp) + 2;
            return String.format("%." + Integer.toString(decimalPlaces) + "f millibuckets per tick", Float.valueOf(fuelConsumption));
        }
        return String.format("%.0f millibuckets per tick", Float.valueOf(fuelConsumption));
    }
}

