/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import erogenousbeef.bigreactors.common.BigReactors;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class BigReactorsTickHandler
implements IScheduledTickHandler {
    protected HashMap<Integer, Queue<ChunkCoordIntPair>> chunkRegenMap;
    protected static final long maximumDeltaTimeNanoSecs = 16000000L;

    public void addRegenChunk(int dimensionId, ChunkCoordIntPair chunkCoord) {
        if (this.chunkRegenMap == null) {
            this.chunkRegenMap = new HashMap();
        }
        if (!this.chunkRegenMap.containsKey(dimensionId)) {
            LinkedList<ChunkCoordIntPair> list = new LinkedList<ChunkCoordIntPair>();
            list.add(chunkCoord);
            this.chunkRegenMap.put(dimensionId, list);
        } else if (!this.chunkRegenMap.get(dimensionId).contains(chunkCoord)) {
            this.chunkRegenMap.get(dimensionId).add(chunkCoord);
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        if (!type.contains(TickType.WORLD)) {
            return;
        }
        if (this.chunkRegenMap == null) {
            return;
        }
        World world = (World)tickData[0];
        if (world.field_72995_K) {
            return;
        }
        int dimensionId = world.field_73011_w.field_76574_g;
        if (this.chunkRegenMap.containsKey(dimensionId)) {
            ChunkCoordIntPair nextChunk;
            Queue<ChunkCoordIntPair> chunksToGen = this.chunkRegenMap.get(dimensionId);
            long startTime = System.nanoTime();
            while (System.nanoTime() - startTime < 16000000L && !chunksToGen.isEmpty() && (nextChunk = chunksToGen.poll()) != null) {
                Random fmlRandom = new Random(world.func_72905_C());
                long xSeed = fmlRandom.nextLong() >> 3;
                long zSeed = fmlRandom.nextLong() >> 3;
                fmlRandom.setSeed(xSeed * (long)nextChunk.field_77276_a + zSeed * (long)nextChunk.field_77275_b ^ world.func_72905_C());
                BigReactors.worldGenerator.generateChunk(fmlRandom, nextChunk.field_77276_a, nextChunk.field_77275_b, world);
            }
            if (chunksToGen.isEmpty()) {
                this.chunkRegenMap.remove(dimensionId);
            }
        }
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "BigReactors:TickHandler";
    }

    public int nextTickSpacing() {
        return 1;
    }
}

