/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartStandard;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityTurbineFluidPort
extends TileEntityTurbinePartStandard
implements IFluidHandler,
INeighborUpdatableEntity,
ITickableMultiblockPart {
    FluidFlow flowSetting = FluidFlow.In;
    IFluidHandler pumpDestination = null;
    protected static final FluidTankInfo[] emptyTankInfoArray = new FluidTankInfo[0];

    public void setFluidFlowDirection(FluidFlow newDirection) {
        this.flowSetting = newDirection;
        this.field_70331_k.func_72944_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, (TileEntity)this);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase multiblockControllerBase) {
        super.onMachineAssembled(multiblockControllerBase);
        this.checkForAdjacentTank();
        if (!this.field_70331_k.field_72995_K) {
            this.func_70296_d();
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        this.pumpDestination = null;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("flowSetting", this.flowSetting.ordinal());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        if (data.func_74764_b("flowSetting")) {
            this.flowSetting = FluidFlow.values()[data.func_74762_e("flowSetting")];
        }
    }

    @Override
    public void encodeDescriptionPacket(NBTTagCompound data) {
        super.encodeDescriptionPacket(data);
        data.func_74768_a("flowSetting", this.flowSetting.ordinal());
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        super.decodeDescriptionPacket(data);
        if (data.func_74764_b("flowSetting")) {
            this.flowSetting = FluidFlow.values()[data.func_74762_e("flowSetting")];
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return 0;
        }
        return this.getTurbine().fill(this.getTankIndex(), resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.isConnected() || from != this.getOutwardsDir()) {
            return resource;
        }
        return this.getTurbine().drain(this.getTankIndex(), resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return null;
        }
        return this.getTurbine().drain(this.getTankIndex(), maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return false;
        }
        return this.getTurbine().canFill(this.getTankIndex(), fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return false;
        }
        return this.getTurbine().canDrain(this.getTankIndex(), fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.isConnected() || from != this.getOutwardsDir()) {
            return emptyTankInfoArray;
        }
        return new FluidTankInfo[]{this.getTurbine().getTankInfo(this.getTankIndex())};
    }

    private int getTankIndex() {
        if (this.flowSetting == FluidFlow.In) {
            return 0;
        }
        return 1;
    }

    public FluidFlow getFlowDirection() {
        return this.flowSetting;
    }

    @Override
    public void onMultiblockServerTick() {
        if (this.pumpDestination == null || this.flowSetting != FluidFlow.Out) {
            return;
        }
        MultiblockTurbine turbine = this.getTurbine();
        FluidStack fluidToDrain = turbine.drain(1, 4000, false);
        if (fluidToDrain != null && fluidToDrain.amount > 0) {
            fluidToDrain.amount = this.pumpDestination.fill(this.getOutwardsDir().getOpposite(), fluidToDrain, true);
            turbine.drain(1, fluidToDrain, true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int neighborBlockID) {
        if (!world.field_72995_K) {
            this.checkForAdjacentTank();
        }
    }

    protected void checkForAdjacentTank() {
        this.pumpDestination = null;
        if (this.field_70331_k.field_72995_K || this.flowSetting == FluidFlow.In) {
            return;
        }
        ForgeDirection outDir = this.getOutwardsDir();
        if (outDir == ForgeDirection.UNKNOWN) {
            return;
        }
        TileEntity neighbor = this.field_70331_k.func_72796_p(this.field_70329_l + outDir.offsetX, this.field_70330_m + outDir.offsetY, this.field_70327_n + outDir.offsetZ);
        if (neighbor instanceof IFluidHandler) {
            this.pumpDestination = (IFluidHandler)neighbor;
        }
    }

    public static enum FluidFlow {
        In,
        Out;

    }
}

