/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cofh.api.energy.IEnergyHandler;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPowerTap;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartStandard;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityTurbinePowerTap
extends TileEntityTurbinePartStandard
implements IEnergyHandler,
INeighborUpdatableEntity {
    IEnergyHandler rfNetwork = null;

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int neighborBlockID) {
        this.checkForConnections(world, x, y, z);
    }

    public boolean isAttachedToPowerNetwork() {
        return this.rfNetwork != null;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        this.checkForConnections(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (!this.field_70331_k.field_72995_K) {
            this.func_70296_d();
        }
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase multiblockControllerBase) {
        super.onMachineAssembled(multiblockControllerBase);
        this.checkForConnections(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (!this.field_70331_k.field_72995_K) {
            this.func_70296_d();
        }
    }

    protected void checkForConnections(World world, int x, int y, int z) {
        boolean isConnected;
        boolean wasConnected = this.rfNetwork != null;
        ForgeDirection out = this.getOutwardsDir();
        if (out == ForgeDirection.UNKNOWN) {
            wasConnected = false;
            this.rfNetwork = null;
        } else {
            this.rfNetwork = null;
            TileEntity te = world.func_72796_p(x + out.offsetX, y + out.offsetY, z + out.offsetZ);
            if (!(te instanceof TileEntityReactorPowerTap) && te instanceof IEnergyHandler) {
                this.rfNetwork = (IEnergyHandler)te;
            }
        }
        boolean bl = isConnected = this.rfNetwork != null;
        if (wasConnected != isConnected && this.field_70331_k.field_72995_K) {
            world.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public int onProvidePower(int units) {
        if (this.rfNetwork == null) {
            return units;
        }
        ForgeDirection approachDirection = this.getOutwardsDir().getOpposite();
        int energyConsumed = this.rfNetwork.receiveEnergy(approachDirection, units, false);
        return units -= energyConsumed;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.isConnected()) {
            return 0;
        }
        return this.getTurbine().extractEnergy(from, maxExtract, simulate);
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        if (!this.isConnected()) {
            return false;
        }
        return from == this.getOutwardsDir();
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (!this.isConnected()) {
            return 0;
        }
        return this.getTurbine().getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (!this.isConnected()) {
            return 0;
        }
        return this.getTurbine().getMaxEnergyStored(from);
    }
}

