/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.tileentity.base;

import buildcraft.api.transport.IPipeTile;
import cofh.api.transport.IItemConduit;
import cpw.mods.fml.common.network.PacketDispatcher;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityBeefBase;
import erogenousbeef.bigreactors.net.PacketWrapper;
import erogenousbeef.bigreactors.utils.InventoryHelper;
import erogenousbeef.bigreactors.utils.SidedInventoryHelper;
import erogenousbeef.bigreactors.utils.StaticUtils;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileEntityInventory
extends TileEntityBeefBase
implements IInventory,
ISidedInventory {
    protected static final int[] kEmptyIntArray = new int[0];
    protected int[][] invExposures;
    public static final int INVENTORY_UNEXPOSED = -1;
    protected ItemStack[] _inventories = new ItemStack[this.func_70302_i_()];

    public TileEntityInventory() {
        this.invExposures = new int[6][1];
        this.resetInventoryExposures();
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        int i;
        super.func_70307_a(tag);
        this._inventories = new ItemStack[this.func_70302_i_()];
        if (tag.func_74764_b("Items")) {
            NBTTagList tagList = tag.func_74761_m("Items");
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = (NBTTagCompound)tagList.func_74743_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot > this._inventories.length) continue;
                ItemStack itemStack = new ItemStack(0, 0, 0);
                itemStack.func_77963_c(itemTag);
                this._inventories[slot] = itemStack;
            }
        }
        this.resetInventoryExposures();
        if (tag.func_74764_b("invExposures")) {
            NBTTagList exposureList = tag.func_74761_m("invExposures");
            for (i = 0; i < exposureList.func_74745_c(); ++i) {
                NBTTagCompound exposureTag = (NBTTagCompound)exposureList.func_74743_b(i);
                int exposureIdx = exposureTag.func_74762_e("exposureIdx");
                this.invExposures[exposureIdx][0] = exposureTag.func_74762_e("direction");
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this._inventories.length; ++i) {
            if (this._inventories[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this._inventories[i].func_77955_b(itemTag);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        if (tagList.func_74745_c() > 0) {
            tag.func_74782_a("Items", (NBTBase)tagList);
        }
        NBTTagList exposureTagList = new NBTTagList();
        for (int i = 0; i < 6; ++i) {
            if (this.invExposures[i][0] == -1) continue;
            NBTTagCompound exposureTag = new NBTTagCompound();
            exposureTag.func_74768_a("exposureIdx", i);
            exposureTag.func_74768_a("direction", this.invExposures[i][0]);
            exposureTagList.func_74742_a((NBTBase)exposureTag);
        }
        if (exposureTagList.func_74745_c() > 0) {
            tag.func_74782_a("invExposures", (NBTBase)exposureTagList);
        }
    }

    public void setExposedInventorySlot(int side, int slot) {
        if (side < 0 || side > 5) {
            return;
        }
        if (side == this.forwardFace.ordinal()) {
            return;
        }
        int rotatedSide = this.getRotatedSide(side);
        this.setExposedInventorySlotReference(rotatedSide, slot);
    }

    public void setExposedInventorySlotReference(int referenceSide, int slot) {
        if (referenceSide < 0 || referenceSide >= this.invExposures.length) {
            return;
        }
        if (this.invExposures[referenceSide][0] == slot) {
            return;
        }
        this.invExposures[referenceSide][0] = slot;
        if (!this.field_70331_k.field_72995_K) {
            Packet250CustomPayload updatePacket = PacketWrapper.createPacket("BigReactors", 6, new Object[]{this.field_70329_l, this.field_70330_m, this.field_70327_n, referenceSide, slot});
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)updatePacket);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
    }

    public int getExposedSlotFromReferenceSide(int side) {
        if (side < 0 || side > 5) {
            return -1;
        }
        return this.invExposures[side][0];
    }

    public abstract int func_70302_i_();

    public ItemStack func_70301_a(int slot) {
        return this._inventories[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this._inventories[slot] != null) {
            if (this._inventories[slot].field_77994_a <= amount) {
                ItemStack itemstack = this._inventories[slot];
                this._inventories[slot] = null;
                return itemstack;
            }
            ItemStack newStack = this._inventories[slot].func_77979_a(amount);
            if (this._inventories[slot].field_77994_a == 0) {
                this._inventories[slot] = null;
            }
            return newStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this._inventories[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public abstract String func_70303_b();

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public abstract boolean func_94041_b(int var1, ItemStack var2);

    public int[] func_94128_d(int side) {
        int rotatedSide = this.getRotatedSide(side);
        if (this.invExposures[rotatedSide][0] == -1) {
            return kEmptyIntArray;
        }
        return this.invExposures[rotatedSide];
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean canConduitConnect(ForgeDirection from) {
        return from != ForgeDirection.UNKNOWN;
    }

    @Override
    public void onReceiveGuiButtonPress(String buttonName, DataInputStream dataStream) throws IOException {
        if (buttonName.equals("changeInvSide")) {
            int side = dataStream.readInt();
            this.iterateInventoryExposure(side);
        }
    }

    protected void iterateInventoryExposure(int side) {
        int slot = this.invExposures[side][0];
        if (++slot >= this.func_70302_i_()) {
            slot = -1;
        }
        this.setExposedInventorySlotReference(side, slot);
    }

    protected ItemStack distributeItemToPipes(int fromSlot, ItemStack itemToDistribute) {
        ForgeDirection[] dirsToCheck;
        for (ForgeDirection dir : dirsToCheck = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.UP, ForgeDirection.DOWN}) {
            InventoryHelper helper;
            if (itemToDistribute == null) {
                return null;
            }
            int rotatedSide = this.getRotatedSide(dir.ordinal());
            if (this.invExposures[rotatedSide][0] != fromSlot) continue;
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ);
            if (te instanceof IItemConduit) {
                IItemConduit conduit = (IItemConduit)te;
                itemToDistribute = conduit.sendItems(itemToDistribute, dir.getOpposite());
                continue;
            }
            if (te instanceof IPipeTile) {
                IPipeTile pipe = (IPipeTile)te;
                if (!pipe.isPipeConnected(dir.getOpposite())) continue;
                itemToDistribute.field_77994_a -= pipe.injectItem(itemToDistribute.func_77946_l(), true, dir.getOpposite());
                if (itemToDistribute.field_77994_a > 0) continue;
                return null;
            }
            if (!(te instanceof IInventory)) continue;
            if (te instanceof ISidedInventory) {
                helper = new SidedInventoryHelper((ISidedInventory)te, dir.getOpposite());
            } else {
                IInventory inv = (IInventory)te;
                if (this.field_70331_k.func_72798_a(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ) == Block.field_72077_au.field_71990_ca) {
                    inv = StaticUtils.Inventory.checkForDoubleChest(this.field_70331_k, inv, this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ);
                }
                helper = new InventoryHelper(inv);
            }
            itemToDistribute = helper.addItem(itemToDistribute);
        }
        return itemToDistribute;
    }

    private void resetInventoryExposures() {
        for (int i = 0; i < 6; ++i) {
            this.invExposures[i][0] = -1;
        }
    }
}

