/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.utils;

import buildcraft.api.tools.IToolWrench;
import erogenousbeef.core.common.CoordTriplet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class StaticUtils {
    public static final ForgeDirection[] CardinalDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    public static final ForgeDirection[][] neighborsBySide = new ForgeDirection[][]{{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.WEST}, {ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.SOUTH}, {ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.NORTH}};

    public static class Strings {
        public static String[] sizePrefixes = new String[]{"", "Ki", "Me", "Gi", "Te", "Pe", "Ex", "Ze", "Yo"};

        public static String formatRF(float number) {
            String prefix = "";
            if (number < 0.0f) {
                prefix = "-";
                number *= -1.0f;
            }
            if (number <= 1.0E-5f) {
                return "0.00 RF";
            }
            int power = (int)Math.floor(Math.log10(number));
            int decimalPoints = 2 - power % 3;
            int letterIdx = Math.max(0, Math.min(sizePrefixes.length, power / 3));
            float divisor = (float)letterIdx * 1000.0f;
            if (divisor > 0.0f) {
                return String.format("%s%." + Integer.toString(decimalPoints) + "f %sRF", prefix, Float.valueOf(number / divisor), sizePrefixes[letterIdx]);
            }
            return String.format("%s%." + Integer.toString(decimalPoints) + "f RF", prefix, Float.valueOf(number));
        }

        public static String formatMillibuckets(float number) {
            String prefix = "";
            if (number < 0.0f) {
                prefix = "-";
                number *= -1.0f;
            }
            if (number <= 1.0E-5f) {
                return "0.000 mB";
            }
            int power = (int)Math.floor(Math.log10(number));
            if (power < 1) {
                return String.format("%.3f mB", Float.valueOf(number));
            }
            if (power < 2) {
                return String.format("%.2f mB", Float.valueOf(number));
            }
            if (power < 3) {
                return String.format("%.1f mB", Float.valueOf(number));
            }
            if (power < 4) {
                return String.format("%.0f mB", Float.valueOf(number));
            }
            number /= 1000.0f;
            if (power < 5) {
                return String.format("%.2f B", Float.valueOf(number));
            }
            if (power < 6) {
                return String.format("%.1f B", Float.valueOf(number));
            }
            return String.format("%.0f B", Float.valueOf(number));
        }
    }

    public static class Energy {
        public static float RFPerCentigradePerUnitVolume = 10.0f;

        public static float getRFFromVolumeAndTemp(int volume, float temperature) {
            return temperature * (float)volume * RFPerCentigradePerUnitVolume;
        }

        public static float getTempFromVolumeAndRF(int volume, float rf) {
            return rf / ((float)volume * RFPerCentigradePerUnitVolume);
        }
    }

    public static class ExtraMath {
        public static float Lerp(float from, float to, float modifier) {
            modifier = Math.min(1.0f, Math.max(0.0f, modifier));
            return from + modifier * (to - from);
        }

        public static int Volume(CoordTriplet minimum, CoordTriplet maximum) {
            if (minimum == null || maximum == null) {
                return 0;
            }
            int xsize = Math.abs(maximum.x - minimum.x) + 1;
            int ysize = Math.abs(maximum.y - minimum.y) + 1;
            int zsize = Math.abs(maximum.z - minimum.z) + 1;
            return xsize * ysize * zsize;
        }
    }

    public static class Fluids {
        public static boolean fillTankWithContainer(World world, IFluidHandler handler, EntityPlayer player) {
            ItemStack container = player.func_71045_bC();
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
            if (fluid != null && (handler.fill(ForgeDirection.UNKNOWN, fluid, false) == fluid.amount || player.field_71075_bZ.field_75098_d)) {
                if (world.field_72995_K) {
                    return true;
                }
                handler.fill(ForgeDirection.UNKNOWN, fluid, true);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, Inventory.consumeItem(container));
                }
                return true;
            }
            return false;
        }

        public static boolean fillContainerFromTank(World world, IFluidHandler handler, EntityPlayer player, FluidStack tankFluid) {
            ItemStack container = player.func_71045_bC();
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)container)) {
                ItemStack returnStack = FluidContainerRegistry.fillFluidContainer((FluidStack)tankFluid, (ItemStack)container);
                FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)returnStack);
                if (fluid == null || returnStack == null) {
                    return false;
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    if (container.field_77994_a == 1) {
                        container = container.func_77946_l();
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, returnStack);
                    } else if (!player.field_71071_by.func_70441_a(returnStack)) {
                        return false;
                    }
                    handler.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
                    --container.field_77994_a;
                    if (container.field_77994_a <= 0) {
                        container = null;
                    }
                } else {
                    handler.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
                }
                return true;
            }
            return false;
        }
    }

    public static class Inventory {
        private static final ForgeDirection[] chestDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};

        public static ItemStack consumeItem(ItemStack stack) {
            return Inventory.consumeItem(stack, 1);
        }

        public static ItemStack consumeItem(ItemStack stack, int amount) {
            if (stack == null) {
                return null;
            }
            if (stack.field_77994_a <= amount) {
                if (stack.func_77973_b().func_77634_r()) {
                    return stack.func_77973_b().getContainerItemStack(stack);
                }
                return null;
            }
            stack.func_77979_a(amount);
            return stack;
        }

        public static boolean isPlayerHoldingWrench(EntityPlayer player) {
            if (player.field_71071_by.func_70448_g() == null) {
                return false;
            }
            Item currentItem = Item.field_77698_e[player.field_71071_by.func_70448_g().field_77993_c];
            return currentItem instanceof IToolWrench;
        }

        public static boolean areStacksEqual(ItemStack s1, ItemStack s2) {
            return Inventory.areStacksEqual(s1, s2, true);
        }

        public static boolean areStacksEqual(ItemStack s1, ItemStack s2, boolean nbtSensitive) {
            if (s1 == null || s2 == null) {
                return false;
            }
            if (!s1.func_77969_a(s2)) {
                return false;
            }
            if (nbtSensitive) {
                if (s1.func_77978_p() == null && s2.func_77978_p() == null) {
                    return true;
                }
                if (s1.func_77978_p() == null || s2.func_77978_p() == null) {
                    return false;
                }
                return s1.func_77978_p().equals((Object)s2.func_77978_p());
            }
            return true;
        }

        public static IInventory checkForDoubleChest(World worldObj, IInventory te, int x, int y, int z) {
            for (ForgeDirection dir : chestDirections) {
                TileEntity otherTe;
                if (worldObj.func_72798_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != Block.field_72077_au.field_71990_ca || !((otherTe = worldObj.func_72796_p(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) instanceof IInventory)) continue;
                return new InventoryLargeChest("Large Chest", te, (IInventory)otherTe);
            }
            return te;
        }
    }
}

