/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.core.multiblock;

import erogenousbeef.core.common.BeefCoreLog;
import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.IMultiblockPart;
import erogenousbeef.core.multiblock.MultiblockRegistry;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class MultiblockControllerBase {
    public static final short DIMENSION_UNBOUNDED = -1;
    protected World worldObj;
    protected AssemblyState assemblyState;
    protected HashSet<IMultiblockPart> connectedParts;
    private CoordTriplet referenceCoord;
    private CoordTriplet minimumCoord;
    private CoordTriplet maximumCoord;
    private boolean shouldCheckForDisconnections;
    private MultiblockValidationException lastValidationException;
    protected boolean debugMode;

    protected MultiblockControllerBase(World world) {
        this.worldObj = world;
        this.connectedParts = new HashSet();
        this.referenceCoord = null;
        this.assemblyState = AssemblyState.Disassembled;
        this.minimumCoord = null;
        this.maximumCoord = null;
        this.shouldCheckForDisconnections = true;
        this.lastValidationException = null;
        this.debugMode = false;
    }

    public void setDebugMode(boolean active) {
        this.debugMode = active;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public abstract void onAttachedPartWithMultiblockData(IMultiblockPart var1, NBTTagCompound var2);

    public boolean hasBlock(CoordTriplet blockCoord) {
        return this.connectedParts.contains(blockCoord);
    }

    public void attachBlock(IMultiblockPart part) {
        CoordTriplet coord = part.getWorldLocation();
        if (!this.connectedParts.add(part)) {
            BeefCoreLog.warning("[%s] Controller %s is double-adding part %d @ %s. This is unusual. If you encounter odd behavior, please tear down the machine and rebuild it.", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", this.hashCode(), ((Object)((Object)part)).hashCode(), coord);
        }
        part.onAttached(this);
        this.onBlockAdded(part);
        if (part.hasMultiblockSaveData()) {
            NBTTagCompound savedData = part.getMultiblockSaveData();
            this.onAttachedPartWithMultiblockData(part, savedData);
            part.onMultiblockDataAssimilated();
        }
        if (this.referenceCoord == null) {
            this.referenceCoord = coord;
            part.becomeMultiblockSaveDelegate();
        } else if (coord.compareTo(this.referenceCoord) < 0) {
            TileEntity te = this.worldObj.func_72796_p(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z);
            ((IMultiblockPart)te).forfeitMultiblockSaveDelegate();
            this.referenceCoord = coord;
            part.becomeMultiblockSaveDelegate();
        } else {
            part.forfeitMultiblockSaveDelegate();
        }
        if (this.minimumCoord != null) {
            if (part.field_70329_l < this.minimumCoord.x) {
                this.minimumCoord.x = part.field_70329_l;
            }
            if (part.field_70330_m < this.minimumCoord.y) {
                this.minimumCoord.y = part.field_70330_m;
            }
            if (part.field_70327_n < this.minimumCoord.z) {
                this.minimumCoord.z = part.field_70327_n;
            }
        }
        if (this.maximumCoord != null) {
            if (part.field_70329_l > this.maximumCoord.x) {
                this.maximumCoord.x = part.field_70329_l;
            }
            if (part.field_70330_m > this.maximumCoord.y) {
                this.maximumCoord.y = part.field_70330_m;
            }
            if (part.field_70327_n > this.maximumCoord.z) {
                this.maximumCoord.z = part.field_70327_n;
            }
        }
        MultiblockRegistry.addDirtyController(this.worldObj, this);
    }

    protected abstract void onBlockAdded(IMultiblockPart var1);

    protected abstract void onBlockRemoved(IMultiblockPart var1);

    protected abstract void onMachineAssembled();

    protected abstract void onMachineRestored();

    protected abstract void onMachinePaused();

    protected abstract void onMachineDisassembled();

    private void onDetachBlock(IMultiblockPart part) {
        part.onDetached(this);
        this.onBlockRemoved(part);
        part.forfeitMultiblockSaveDelegate();
        this.maximumCoord = null;
        this.minimumCoord = null;
        if (this.referenceCoord != null && this.referenceCoord.equals(part.field_70329_l, part.field_70330_m, part.field_70327_n)) {
            this.referenceCoord = null;
        }
        this.shouldCheckForDisconnections = true;
    }

    public void detachBlock(IMultiblockPart part, boolean chunkUnloading) {
        if (chunkUnloading && this.assemblyState == AssemblyState.Assembled) {
            this.assemblyState = AssemblyState.Paused;
            this.onMachinePaused();
        }
        this.onDetachBlock(part);
        if (!this.connectedParts.remove((Object)part)) {
            BeefCoreLog.warning("[%s] Double-removing part (%d) @ %d, %d, %d, this is unexpected and may cause problems. If you encounter anomalies, please tear down the reactor and rebuild it.", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", ((Object)((Object)part)).hashCode(), part.field_70329_l, part.field_70330_m, part.field_70327_n);
        }
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return;
        }
        MultiblockRegistry.addDirtyController(this.worldObj, this);
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
    }

    protected abstract int getMinimumNumberOfBlocksForAssembledMachine();

    protected abstract int getMaximumXSize();

    protected abstract int getMaximumZSize();

    protected abstract int getMaximumYSize();

    protected int getMinimumXSize() {
        return 1;
    }

    protected int getMinimumYSize() {
        return 1;
    }

    protected int getMinimumZSize() {
        return 1;
    }

    public MultiblockValidationException getLastValidationException() {
        return this.lastValidationException;
    }

    protected abstract void isMachineWhole() throws MultiblockValidationException;

    public void checkIfMachineIsWhole() {
        boolean isWhole;
        AssemblyState oldState = this.assemblyState;
        this.lastValidationException = null;
        try {
            this.isMachineWhole();
            isWhole = true;
        }
        catch (MultiblockValidationException e) {
            this.lastValidationException = e;
            isWhole = false;
        }
        if (isWhole) {
            this.assembleMachine(oldState);
        } else if (oldState == AssemblyState.Assembled) {
            this.disassembleMachine();
        }
    }

    private void assembleMachine(AssemblyState oldState) {
        for (IMultiblockPart part : this.connectedParts) {
            part.onMachineAssembled(this);
        }
        this.assemblyState = AssemblyState.Assembled;
        if (oldState == AssemblyState.Paused) {
            this.onMachineRestored();
        } else {
            this.onMachineAssembled();
        }
    }

    private void disassembleMachine() {
        for (IMultiblockPart part : this.connectedParts) {
            part.onMachineBroken();
        }
        this.assemblyState = AssemblyState.Disassembled;
        this.onMachineDisassembled();
    }

    public void assimilate(MultiblockControllerBase other) {
        CoordTriplet otherReferenceCoord = other.getReferenceCoord();
        if (otherReferenceCoord != null && this.getReferenceCoord().compareTo(otherReferenceCoord) >= 0) {
            throw new IllegalArgumentException("The controller with the lowest minimum-coord value must consume the one with the higher coords");
        }
        HashSet<IMultiblockPart> partsToAcquire = new HashSet<IMultiblockPart>(other.connectedParts);
        other._onAssimilated(this);
        for (IMultiblockPart acquiredPart : partsToAcquire) {
            if (acquiredPart.func_70320_p()) continue;
            this.connectedParts.add(acquiredPart);
            acquiredPart.onAssimilated(this);
            this.onBlockAdded(acquiredPart);
        }
        this.onAssimilate(other);
        other.onAssimilated(this);
    }

    private void _onAssimilated(MultiblockControllerBase otherController) {
        if (this.referenceCoord != null) {
            TileEntity te;
            if (this.worldObj.func_72863_F().func_73149_a(this.referenceCoord.getChunkX(), this.referenceCoord.getChunkZ()) && (te = this.worldObj.func_72796_p(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z)) instanceof IMultiblockPart) {
                ((IMultiblockPart)te).forfeitMultiblockSaveDelegate();
            }
            this.referenceCoord = null;
        }
        this.connectedParts.clear();
    }

    protected abstract void onAssimilate(MultiblockControllerBase var1);

    protected abstract void onAssimilated(MultiblockControllerBase var1);

    public final void updateMultiblockEntity() {
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return;
        }
        if (this.assemblyState != AssemblyState.Assembled) {
            return;
        }
        if (this.worldObj.field_72995_K) {
            this.updateClient();
        } else if (this.updateServer() && this.minimumCoord != null && this.maximumCoord != null && this.worldObj.func_72904_c(this.minimumCoord.x, this.minimumCoord.y, this.minimumCoord.z, this.maximumCoord.x, this.maximumCoord.y, this.maximumCoord.z)) {
            int minChunkX = this.minimumCoord.x >> 4;
            int minChunkZ = this.minimumCoord.z >> 4;
            int maxChunkX = this.maximumCoord.x >> 4;
            int maxChunkZ = this.maximumCoord.z >> 4;
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    Chunk chunkToSave = this.worldObj.func_72964_e(x, z);
                    chunkToSave.func_76630_e();
                }
            }
        }
    }

    protected abstract boolean updateServer();

    protected abstract void updateClient();

    protected void isBlockGoodForFrame(World world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Block is not valid for use in the machine's interior", x, y, z));
    }

    protected void isBlockGoodForTop(World world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Block is not valid for use in the machine's interior", x, y, z));
    }

    protected void isBlockGoodForBottom(World world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Block is not valid for use in the machine's interior", x, y, z));
    }

    protected void isBlockGoodForSides(World world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Block is not valid for use in the machine's interior", x, y, z));
    }

    protected void isBlockGoodForInterior(World world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Block is not valid for use in the machine's interior", x, y, z));
    }

    public CoordTriplet getReferenceCoord() {
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        return this.referenceCoord;
    }

    public int getNumConnectedBlocks() {
        return this.connectedParts.size();
    }

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public void recalculateMinMaxCoords() {
        this.minimumCoord = new CoordTriplet(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.maximumCoord = new CoordTriplet(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (IMultiblockPart part : this.connectedParts) {
            if (part.field_70329_l < this.minimumCoord.x) {
                this.minimumCoord.x = part.field_70329_l;
            }
            if (part.field_70329_l > this.maximumCoord.x) {
                this.maximumCoord.x = part.field_70329_l;
            }
            if (part.field_70330_m < this.minimumCoord.y) {
                this.minimumCoord.y = part.field_70330_m;
            }
            if (part.field_70330_m > this.maximumCoord.y) {
                this.maximumCoord.y = part.field_70330_m;
            }
            if (part.field_70327_n < this.minimumCoord.z) {
                this.minimumCoord.z = part.field_70327_n;
            }
            if (part.field_70327_n <= this.maximumCoord.z) continue;
            this.maximumCoord.z = part.field_70327_n;
        }
    }

    public CoordTriplet getMinimumCoord() {
        if (this.minimumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return this.minimumCoord.copy();
    }

    public CoordTriplet getMaximumCoord() {
        if (this.maximumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return this.maximumCoord.copy();
    }

    public abstract void formatDescriptionPacket(NBTTagCompound var1);

    public abstract void decodeDescriptionPacket(NBTTagCompound var1);

    public boolean isEmpty() {
        return this.connectedParts.isEmpty();
    }

    public boolean shouldConsume(MultiblockControllerBase otherController) {
        if (!otherController.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Attempting to merge two multiblocks with different master classes - this should never happen!");
        }
        if (otherController == this) {
            return false;
        }
        int res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        BeefCoreLog.warning("[%s] Encountered two controllers with the same reference coordinate. Auditing connected parts and retrying.", this.worldObj.field_72995_K ? "CLIENT" : "SERVER");
        this.auditParts();
        otherController.auditParts();
        res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        BeefCoreLog.severe("My Controller (%d): size (%d), parts: %s", this.hashCode(), this.connectedParts.size(), this.getPartsListString());
        BeefCoreLog.severe("Other Controller (%d): size (%d), coords: %s", otherController.hashCode(), otherController.connectedParts.size(), otherController.getPartsListString());
        throw new IllegalArgumentException("[" + (this.worldObj.field_72995_K ? "CLIENT" : "SERVER") + "] Two controllers with the same reference coord that somehow both have valid parts - this should never happen!");
    }

    private int _shouldConsume(MultiblockControllerBase otherController) {
        CoordTriplet myCoord = this.getReferenceCoord();
        CoordTriplet theirCoord = otherController.getReferenceCoord();
        if (theirCoord == null) {
            return -1;
        }
        return myCoord.compareTo(theirCoord);
    }

    private String getPartsListString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IMultiblockPart part : this.connectedParts) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(String.format("(%d: %d, %d, %d)", ((Object)((Object)part)).hashCode(), part.field_70329_l, part.field_70330_m, part.field_70327_n));
            first = false;
        }
        return sb.toString();
    }

    private void auditParts() {
        HashSet<IMultiblockPart> deadParts = new HashSet<IMultiblockPart>();
        for (IMultiblockPart part : this.connectedParts) {
            if (!part.func_70320_p() && this.worldObj.func_72796_p(part.field_70329_l, part.field_70330_m, part.field_70327_n) == part) continue;
            this.onDetachBlock(part);
            deadParts.add(part);
        }
        this.connectedParts.removeAll(deadParts);
        BeefCoreLog.warning("[%s] Controller found %d dead parts during an audit, %d parts remain attached", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", deadParts.size(), this.connectedParts.size());
    }

    public Set<IMultiblockPart> checkForDisconnections() {
        if (!this.shouldCheckForDisconnections) {
            return null;
        }
        if (this.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return null;
        }
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        this.referenceCoord = null;
        HashSet<IMultiblockPart> deadParts = new HashSet<IMultiblockPart>();
        IMultiblockPart referencePart = null;
        int originalSize = this.connectedParts.size();
        for (IMultiblockPart part : this.connectedParts) {
            if (!chunkProvider.func_73149_a(part.field_70329_l >> 4, part.field_70327_n >> 4) || part.func_70320_p()) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            if (this.worldObj.func_72796_p(part.field_70329_l, part.field_70330_m, part.field_70327_n) != part) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            part.setUnvisited();
            part.forfeitMultiblockSaveDelegate();
            CoordTriplet c = part.getWorldLocation();
            if (this.referenceCoord == null) {
                this.referenceCoord = c;
                referencePart = part;
                continue;
            }
            if (c.compareTo(this.referenceCoord) >= 0) continue;
            this.referenceCoord = c;
            referencePart = part;
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (referencePart == null || this.isEmpty()) {
            this.shouldCheckForDisconnections = false;
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return null;
        }
        referencePart.becomeMultiblockSaveDelegate();
        LinkedList<IMultiblockPart> partsToCheck = new LinkedList<IMultiblockPart>();
        IMultiblockPart[] nearbyParts = null;
        int visitedParts = 0;
        partsToCheck.add(referencePart);
        while (!partsToCheck.isEmpty()) {
            IMultiblockPart part = (IMultiblockPart)((Object)partsToCheck.removeFirst());
            part.setVisited();
            ++visitedParts;
            for (IMultiblockPart nearbyPart : nearbyParts = part.getNeighboringParts()) {
                if (nearbyPart.getMultiblockController() != this || nearbyPart.isVisited()) continue;
                nearbyPart.setVisited();
                partsToCheck.add(nearbyPart);
            }
        }
        HashSet<IMultiblockPart> removedParts = new HashSet<IMultiblockPart>();
        for (IMultiblockPart orphanCandidate : this.connectedParts) {
            if (orphanCandidate.isVisited()) continue;
            deadParts.add(orphanCandidate);
            orphanCandidate.onOrphaned(this, originalSize, visitedParts);
            this.onDetachBlock(orphanCandidate);
            removedParts.add(orphanCandidate);
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        this.shouldCheckForDisconnections = false;
        return removedParts;
    }

    public Set<IMultiblockPart> detachAllBlocks() {
        if (this.worldObj == null) {
            return new HashSet<IMultiblockPart>();
        }
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        for (IMultiblockPart part : this.connectedParts) {
            if (!chunkProvider.func_73149_a(part.field_70329_l >> 4, part.field_70327_n >> 4)) continue;
            this.onDetachBlock(part);
        }
        HashSet<IMultiblockPart> detachedParts = this.connectedParts;
        this.connectedParts = new HashSet();
        return detachedParts;
    }

    public boolean isAssembled() {
        return this.assemblyState == AssemblyState.Assembled;
    }

    private void selectNewReferenceCoord() {
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        IMultiblockPart theChosenOne = null;
        this.referenceCoord = null;
        for (IMultiblockPart part : this.connectedParts) {
            if (part.func_70320_p() || !chunkProvider.func_73149_a(part.field_70329_l >> 4, part.field_70327_n >> 4) || this.referenceCoord != null && this.referenceCoord.compareTo(part.field_70329_l, part.field_70330_m, part.field_70327_n) <= 0) continue;
            this.referenceCoord = part.getWorldLocation();
            theChosenOne = part;
        }
        if (theChosenOne != null) {
            ((IMultiblockPart)theChosenOne).becomeMultiblockSaveDelegate();
        }
    }

    protected static enum AssemblyState {
        Disassembled,
        Assembled,
        Paused;

    }
}

