/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.jetpack;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tonius.simplyjetpacks.KeyboardTracker;
import tonius.simplyjetpacks.config.MainConfig;
import tonius.simplyjetpacks.item.jetpack.ItemJetpack;
import tonius.simplyjetpacks.util.DamageSourcePotatoJetpack;
import tonius.simplyjetpacks.util.FireworksGenerator;
import tonius.simplyjetpacks.util.StackUtils;
import tonius.simplyjetpacks.util.StringUtils;

public class ItemPotatoJetpack
extends ItemJetpack {
    public ItemPotatoJetpack(int id, EnumArmorMaterial material, String name, int maxEnergy, int maxInput, int jetpackTier, int tickEnergy, double maxSpeed, double acceleration, double forwardThrust, double hoverModeIdleSpeed, double hoverModeActiveSpeed) {
        super(id, material, name, maxEnergy, maxInput, jetpackTier, tickEnergy, maxSpeed, acceleration, forwardThrust, hoverModeIdleSpeed, hoverModeActiveSpeed);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        if (StringUtils.canShowDetails()) {
            list.add(StringUtils.getChargeText(false, this.getEnergyStored(itemStack), this.getMaxEnergyStored(itemStack)));
            list.add(StringUtils.getEnergyUsageText(this.tickEnergy));
            if (!MainConfig.hideJetpackTier0Warning) {
                list.add("\u00a7a" + StringUtils.translate("tooltip.jetpackPotato.description.1"));
                list.add("\u00a7a" + StringUtils.translate("tooltip.jetpackPotato.description.2"));
                list.add("\u00a7c\u00a7o" + StringUtils.translate("tooltip.jetpackPotato.warning"));
            } else {
                list.add("\u00a7a" + StringUtils.translate("tooltip.jetpack.description.1"));
                list.add("\u00a7a" + StringUtils.translate("tooltip.jetpack.description.2"));
            }
        } else {
            list.add(StringUtils.getShiftText());
        }
    }

    @Override
    public void useJetpack(EntityLivingBase user, ItemStack jetpack, boolean force) {
        if (this.isFired(jetpack)) {
            super.useJetpack(user, jetpack, true);
            if (this.getEnergyStored(jetpack) == 0) {
                user.func_70062_b(3, null);
                if (!user.field_70170_p.field_72995_K) {
                    Random rand = new Random();
                    user.field_70170_p.func_72876_a((Entity)user, user.field_70165_t, user.field_70163_u, user.field_70161_v, 4.0f, false);
                    for (int i = 0; i <= rand.nextInt(3) + 4; ++i) {
                        ItemStack firework = FireworksGenerator.randomFirework();
                        user.field_70170_p.func_72838_d((Entity)new EntityFireworkRocket(user.field_70170_p, user.field_70165_t + rand.nextDouble() * 6.0 - 3.0, user.field_70163_u, user.field_70161_v + rand.nextDouble() * 6.0 - 3.0, firework));
                    }
                    user.func_70097_a(DamageSourcePotatoJetpack.causeJetpackPotatoDamage((Entity)user), 20.0f);
                    user.func_70025_b(Item.field_82800_bN.field_77779_bT, 1);
                }
            }
        } else {
            boolean jumpKeyDown = true;
            if (!force && user instanceof EntityPlayer && !KeyboardTracker.isJumpKeyDown((EntityPlayer)user)) {
                jumpKeyDown = false;
            }
            if (jumpKeyDown) {
                if (this.isTimerSet(jetpack)) {
                    if (user.func_70681_au().nextInt(5) == 0) {
                        this.sendParticlePacket(user, 2);
                    }
                    this.decrementTimer(jetpack, user);
                } else {
                    this.setTimer(jetpack, 50);
                }
            }
        }
    }

    @Override
    public void toggle(ItemStack itemStack, EntityPlayer player) {
    }

    @Override
    public void toggleHoverMode(ItemStack itemStack, EntityPlayer player) {
    }

    @Override
    public boolean isOn(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isHoverModeActive(ItemStack itemStack) {
        return false;
    }

    public boolean isFired(ItemStack itemStack) {
        return StackUtils.getNBT(itemStack).func_74767_n("Fired");
    }

    public void setFired(ItemStack itemStack) {
        StackUtils.getNBT(itemStack).func_74757_a("Fired", true);
    }

    public void setTimer(ItemStack itemStack, int timer) {
        StackUtils.getNBT(itemStack);
        itemStack.field_77990_d.func_74768_a("RocketTimer", timer);
        itemStack.field_77990_d.func_74757_a("TimerSet", true);
    }

    public boolean isTimerSet(ItemStack itemStack) {
        return StackUtils.getNBT(itemStack).func_74767_n("TimerSet");
    }

    public void decrementTimer(ItemStack itemStack, EntityLivingBase user) {
        StackUtils.getNBT(itemStack);
        int timer = itemStack.field_77990_d.func_74762_e("RocketTimer");
        timer = timer > 0 ? timer - 1 : 0;
        itemStack.field_77990_d.func_74768_a("RocketTimer", timer);
        if (timer == 0) {
            this.setFired(itemStack);
            user.field_70170_p.func_72956_a((Entity)user, "simplyjetpacks:rocket", 1.0f, 1.0f);
        }
    }
}

