/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins;

import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.IPlugin;
import mods.neiplugins.common.RecipeHandlerUtils;
import mods.neiplugins.common.Utils;
import mods.neiplugins.forge.DamageValueTooltipHandler;
import mods.neiplugins.railcraft.BlastFurnaceRecipeHandler;
import mods.neiplugins.railcraft.CokeOvenRecipeHandler;
import mods.neiplugins.railcraft.RockCrusherRecipeHandler;
import mods.neiplugins.railcraft.RollingMachineRecipeHandler;
import mods.neiplugins.railcraft.RollingMachineShapelessRecipeHandler;
import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.api.core.items.TagList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NEIPlugins_Railcraft
implements IPlugin {
    public static final String PLUGIN_NAME = "Railcraft";
    public static final String PLUGIN_VERSION = "1.6.5";
    public static final String REQUIRED_MOD = "Railcraft";

    @Override
    public String getPluginName() {
        return "Railcraft";
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod("Railcraft");
    }

    @Override
    public void init() {
    }

    @Override
    public void loadConfig() {
        this.addHandlers();
        this.configureItemPanel();
    }

    private void addHandlers() {
        RockCrusherRecipeHandler.guiclass = Utils.findClass("mods.railcraft.client.gui.GuiRockCrusher");
        BlastFurnaceRecipeHandler.guiclass = Utils.findClass("mods.railcraft.client.gui.GuiBlastFurnace");
        CokeOvenRecipeHandler.guiclass = Utils.findClass("mods.railcraft.client.gui.GuiCokeOven");
        RollingMachineRecipeHandler.guiclass = Utils.findClass("mods.railcraft.client.gui.GuiRollingMachine");
        RollingMachineShapelessRecipeHandler.guiclass = Utils.findClass("mods.railcraft.client.gui.GuiRollingMachine");
        API.registerGuiOverlay(RollingMachineRecipeHandler.guiclass, (String)"railcraft.rolling");
        API.registerGuiOverlayHandler(RollingMachineRecipeHandler.guiclass, (IOverlayHandler)new DefaultOverlayHandler(5, 9), (String)"railcraft.rolling");
        API.registerRecipeHandler((ICraftingHandler)new RollingMachineRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RollingMachineRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RollingMachineShapelessRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RollingMachineShapelessRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CokeOvenRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CokeOvenRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new BlastFurnaceRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new BlastFurnaceRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RockCrusherRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RockCrusherRecipeHandler());
        RecipeHandlerUtils.addToRecipeList("Railcraft", NEIPlugins_Railcraft.getItemByTag("machine.alpha.rolling.machine"), "Rolling Machine", 0, "railcraft.rolling", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Railcraft", NEIPlugins_Railcraft.getItemByTag("machine.alpha.rock.crusher"), "Rock Crusher", 0, "railcraft.crusher", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Railcraft", NEIPlugins_Railcraft.getItemByTag("machine.alpha.coke.oven"), "Coke Oven", 0, "railcraft.cokeoven", new Object[0]);
        RecipeHandlerUtils.addToRecipeList("Railcraft", NEIPlugins_Railcraft.getItemByTag("machine.alpha.blast.furnace"), "Blast Furnace", 0, "railcraft.blastfurnace", new Object[0]);
    }

    private void configureItemPanel() {
        try {
            this.addSubsets();
            DamageValueTooltipHandler.addPrefix(NEIPlugins_Railcraft.getItemByTag("firestone.refined"), "Charges: ");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static ItemStack getItemByTag(String tag) {
        try {
            return GameRegistry.findItemStack((String)"Railcraft", (String)tag, (int)1);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void addTag(String tag, MultiItemRange items) {
        ItemStack item = NEIPlugins_Railcraft.getItemByTag(tag);
        if (item != null) {
            items.add(item);
        }
    }

    private static ArrayList<Map.Entry<String, ItemStack>> getAllItems() {
        ArrayList<Map.Entry<String, ItemStack>> result = new ArrayList<Map.Entry<String, ItemStack>>();
        for (String tag : TagList.getTags()) {
            result.add(new AbstractMap.SimpleEntry<String, ItemStack>(tag, NEIPlugins_Railcraft.getItemByTag(tag)));
        }
        return result;
    }

    private void addSubsets() {
        MultiItemRange rails = new MultiItemRange();
        rails.add(Block.field_72056_aG.field_71990_ca);
        rails.add(Block.field_71953_U.field_71990_ca);
        rails.add(Block.field_71954_T.field_71990_ca);
        MultiItemRange allcarts = new MultiItemRange();
        MultiItemRange allrails = new MultiItemRange();
        MultiItemRange woodenrails = new MultiItemRange();
        MultiItemRange speedrails = new MultiItemRange();
        MultiItemRange reinforcedrails = new MultiItemRange();
        MultiItemRange posts = new MultiItemRange();
        MultiItemRange walls = new MultiItemRange();
        MultiItemRange cubes = new MultiItemRange();
        MultiItemRange signals = new MultiItemRange();
        MultiItemRange detectors = new MultiItemRange();
        MultiItemRange machines = new MultiItemRange();
        MultiItemRange parts = new MultiItemRange();
        MultiItemRange tools = new MultiItemRange();
        MultiItemRange steeltools = new MultiItemRange();
        MultiItemRange armors = new MultiItemRange();
        MultiItemRange creosoteliquid = new MultiItemRange();
        MultiItemRange liquids = new MultiItemRange();
        MultiItemRange other = new MultiItemRange();
        MultiItemRange carts = new MultiItemRange();
        MultiItemRange dusts = new MultiItemRange();
        MultiItemRange ballasts = new MultiItemRange();
        carts.add(Item.field_77773_az.field_77779_bT);
        carts.add(Item.field_77762_aN.field_77779_bT);
        carts.add(Item.field_77763_aO.field_77779_bT);
        for (Item i : Item.field_77698_e) {
            if (i instanceof ITrackItem) {
                allrails.add(i.field_77779_bT);
            }
            if (!(i instanceof IMinecartItem)) continue;
            allcarts.add(i.field_77779_bT);
        }
        for (Map.Entry<String, ItemStack> entry : NEIPlugins_Railcraft.getAllItems()) {
            if (entry.getKey().startsWith("track.slow")) {
                woodenrails.add(entry.getValue());
            } else if (entry.getKey().startsWith("track.speed")) {
                speedrails.add(entry.getValue());
            } else if (entry.getKey().startsWith("track.reinforced")) {
                reinforcedrails.add(entry.getValue());
            } else if (entry.getKey().startsWith("post")) {
                posts.add(entry.getValue());
            } else if (entry.getKey().startsWith("signal")) {
                signals.add(entry.getValue());
            } else if (entry.getKey().startsWith("detector.")) {
                detectors.add(entry.getValue());
            } else if (entry.getKey().startsWith("machine.")) {
                machines.add(entry.getValue());
            } else if (entry.getKey().startsWith("part.")) {
                parts.add(entry.getValue());
            } else if (entry.getKey().startsWith("liquid.creosote.")) {
                creosoteliquid.add(entry.getValue());
            } else if (entry.getKey().startsWith("liquid.")) {
                liquids.add(entry.getValue());
            } else if (entry.getKey().startsWith("tool.steel.")) {
                steeltools.add(entry.getValue());
            } else if (entry.getKey().startsWith("armor.steel.")) {
                armors.add(entry.getValue());
            } else if (entry.getKey().startsWith("tool.")) {
                tools.add(entry.getValue());
            } else if (entry.getKey().startsWith("dust.")) {
                dusts.add(entry.getValue());
            } else if (entry.getKey().startsWith("cart.")) {
                carts.add(entry.getValue());
            } else if (entry.getKey().startsWith("wall.")) {
                walls.add(entry.getValue());
            } else if (entry.getKey().startsWith("cube.")) {
                cubes.add(entry.getValue());
            } else if (!entry.getKey().startsWith("track.")) {
                other.add(entry.getValue());
            }
            if (!entry.getKey().startsWith("track.")) continue;
            rails.add(entry.getValue());
        }
        NEIPlugins_Railcraft.addTag("tool.signal.tuner", signals);
        NEIPlugins_Railcraft.addTag("tool.surveyor", signals);
        NEIPlugins_Railcraft.addTag("fuel.coke", other);
        NEIPlugins_Railcraft.addTag("ic2.upgrade.lapotron", other);
        MultiItemRange crowbar = new MultiItemRange();
        NEIPlugins_Railcraft.addTag("tool.crowbar", crowbar);
        API.addSetRange((String)"RailCraft.Rails", (MultiItemRange)rails);
        API.addSetRange((String)"RailCraft.Rails.Wooden", (MultiItemRange)woodenrails);
        API.addSetRange((String)"RailCraft.Rails.HighSpeed", (MultiItemRange)speedrails);
        API.addSetRange((String)"RailCraft.Rails.Reinforced", (MultiItemRange)reinforcedrails);
        API.addSetRange((String)"RailCraft.Detectors", (MultiItemRange)detectors);
        API.addSetRange((String)"RailCraft.Structure.Post", (MultiItemRange)posts);
        API.addSetRange((String)"RailCraft.Structure.Walls", (MultiItemRange)walls);
        API.addSetRange((String)"RailCraft.Structure.Bricks", (MultiItemRange)cubes);
        API.addSetRange((String)"RailCraft.Carts", (MultiItemRange)carts);
        API.addSetRange((String)"RailCraft.Signals", (MultiItemRange)signals);
        API.addSetRange((String)"RailCraft.Parts", (MultiItemRange)parts);
        API.addSetRange((String)"RailCraft.Machines", (MultiItemRange)machines);
        API.addSetRange((String)"RailCraft.Tools", (MultiItemRange)tools);
        API.addSetRange((String)"RailCraft.Liquids.Creosote", (MultiItemRange)creosoteliquid);
        API.addSetRange((String)"RailCraft.Liquids", (MultiItemRange)liquids);
        API.addSetRange((String)"RailCraft.Other.Dusts", (MultiItemRange)dusts);
        API.addSetRange((String)"RailCraft.Other", (MultiItemRange)other);
        API.addSetRange((String)"RailCraft.Other.Armor", (MultiItemRange)armors);
        API.addSetRange((String)"RailCraft.Other.SteelTools", (MultiItemRange)steeltools);
        API.addSetRange((String)"RailCraft", (MultiItemRange)crowbar);
        API.addToRange((String)"Items.Tools.Other", (MultiItemRange)crowbar);
    }
}

