/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.lists;

import codechicken.nei.PositionedStack;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mods.neiplugins.common.Utils;
import mods.neiplugins.lists.GuiList;
import mods.neiplugins.lists.IListElement;
import net.minecraft.item.ItemStack;

public class MultipleStackListElement
implements IListElement {
    protected int margin;
    public ArrayList<PositionedStack> stacks;

    public MultipleStackListElement(Iterator<ItemStack> stacks, int margin, Dimension size) {
        int pos = 0;
        this.margin = margin;
        this.stacks = new ArrayList();
        while (pos + 16 < size.width && stacks.hasNext()) {
            ItemStack stack = stacks.next();
            if (stack == null || !Utils.isSafeItemStack(stack, "mistaqur.nei.lists.MultipleStackListElement")) continue;
            this.stacks.add(new PositionedStack((Object)stack, pos, 1));
            pos += 16 + margin;
        }
    }

    protected MultipleStackListElement() {
    }

    @Override
    public void draw(Dimension size) {
    }

    @Override
    public boolean click(int button) {
        return false;
    }

    @Override
    public List<String> handleTooltip(GuiList gui, List<String> currenttip, Point mousepos) {
        return currenttip;
    }

    protected List<String> handleItemTooltip(GuiList gui, int index, List<String> currenttip, Point mousePos) {
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiList gui, ItemStack stack, List<String> currenttip, Point mousePos) {
        if (mousePos.y < 0 || mousePos.y > 17) {
            return currenttip;
        }
        int t = 16 + this.margin;
        int index = mousePos.x / t;
        if (index >= 0 && index < this.stacks.size() && mousePos.x % t < 18) {
            this.handleItemTooltip(gui, index, currenttip, mousePos);
        }
        return currenttip;
    }

    @Override
    public ArrayList<PositionedStack> getStacks() {
        return this.stacks;
    }
}

