/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.options;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.Utils;
import mods.neiplugins.options.TickHandlerVersion;

public class VersionCheck {
    private static final String VERSION_URL = "https://dl.dropbox.com/u/53845448/minecraft/neiplugins/NEI_1.6.2/version.txt";
    private static boolean checkUpdate;
    private static boolean checkAllUpdates;
    private static String latestModVersion;
    private static String description;
    private static boolean newVersionAvailable;
    private static boolean versionCheckCompleted;
    public static TickHandlerVersion tickHandler;

    public static void checkForNewVersion() {
        checkUpdate = Utils.getBooleanSetting("neiplugins.update.checkUpdate");
        checkAllUpdates = Utils.getBooleanSetting("neiplugins.update.checkAllUpdates");
        if (!checkUpdate) {
            return;
        }
        if (tickHandler == null) {
            tickHandler = new TickHandlerVersion();
            TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)tickHandler, (Side)Side.CLIENT);
        } else {
            tickHandler.reset();
        }
        VersionCheckThread versionCheckThread = new VersionCheckThread();
        versionCheckThread.start();
    }

    public static boolean isNewVersionAvailable() {
        return newVersionAvailable;
    }

    public static String getLatestVersion() {
        return latestModVersion;
    }

    public static String getVersionDescription() {
        return description;
    }

    public static boolean isVersionCheckComplete() {
        return versionCheckCompleted;
    }

    static /* synthetic */ String access$002(String x0) {
        latestModVersion = x0;
        return latestModVersion;
    }

    static /* synthetic */ boolean access$102(boolean x0) {
        newVersionAvailable = x0;
        return newVersionAvailable;
    }

    static /* synthetic */ String access$000() {
        return latestModVersion;
    }

    static /* synthetic */ boolean access$200() {
        return checkAllUpdates;
    }

    static /* synthetic */ String access$302(String x0) {
        description = x0;
        return description;
    }

    static /* synthetic */ boolean access$100() {
        return newVersionAvailable;
    }

    static /* synthetic */ String access$300() {
        return description;
    }

    static /* synthetic */ boolean access$402(boolean x0) {
        versionCheckCompleted = x0;
        return versionCheckCompleted;
    }

    static {
        latestModVersion = "";
        description = "";
    }

    private static class VersionCheckThread
    extends Thread {
        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            modVersions = NEIPlugins.getMod().modVersions;
            try {
                versionFile = new URL("https://dl.dropbox.com/u/53845448/minecraft/neiplugins/NEI_1.6.2/version.txt");
                reader = new BufferedReader(new InputStreamReader(versionFile.openStream()));
                VersionCheck.access$002(reader.readLine());
                invalidFile = false;
                VersionCheck.access$102(false);
                line = reader.readLine();
                while (line != null && !line.equals("")) {
                    parts = line.trim().split("\t");
                    if (parts.length != 2 && parts.length != 1 || !line.contains("\t")) {
                        invalidFile = true;
                        break;
                    }
                    modName = "NEIPlugins";
                    if (parts.length != 2) ** GOTO lbl-1000
                    modVersion = VersionParser.parseVersionReference((String)parts[1]);
                    modName = modVersion.getLabel();
                    if (!NEIPlugins.getMod().hasMod(modVersion)) {
                        NEIPlugins.log(Level.FINE, "Update for mod \"{0}\" is ignored", new Object[]{modVersion.getLabel()});
                    } else if ((part0 = parts[0].trim().split("@")).length == 2) {
                        latestPluginVersion = new DefaultArtifactVersion(part0[0], part0[1]);
                        plugin = NEIPlugins.getMod().plugins.get(part0[0]);
                        if (plugin == null) {
                            NEIPlugins.log(Level.INFO, "New plugin for \"{0}\" is available: {1} ({2})", new Object[]{modName, latestPluginVersion.getLabel(), latestPluginVersion.getVersionString()});
                            VersionCheck.access$102(true);
                        } else {
                            currentPluginVersion = new DefaultArtifactVersion(part0[0], plugin.getPluginVersion());
                            if (latestPluginVersion.compareTo((Object)currentPluginVersion) > 0) {
                                NEIPlugins.log(Level.INFO, "New version of plugin for \"{0}\" is available: {1} ({2})", new Object[]{modName, latestPluginVersion.getLabel(), latestPluginVersion.getVersionString()});
                                VersionCheck.access$102(true);
                            }
                        }
                    }
                    line = reader.readLine();
                }
                latestVersion = new DefaultArtifactVersion(VersionCheck.access$000());
                currentVersion = new DefaultArtifactVersion("1.1.0.6");
                NEIPlugins.log(Level.FINE, "Latest and current version of NEIPlugins: {0} and {1}", new Object[]{latestVersion.getVersionString(), currentVersion.getVersionString()});
                if (VersionCheck.access$200() && latestVersion.compareTo((Object)currentVersion) > 0 || invalidFile) {
                    VersionCheck.access$102(true);
                }
                if (!invalidFile) {
                    VersionCheck.access$302(reader.readLine());
                }
                reader.close();
                if (VersionCheck.access$100()) {
                    NEIPlugins.log(Level.INFO, "An updated version of NEIPlugins is available: {0} {1}", new Object[]{VersionCheck.access$000(), VersionCheck.access$300()});
                }
            }
            catch (Exception ex) {
                NEIPlugins.logWarning("Latest Version Check Failed:", new Object[]{ex});
            }
            VersionCheck.access$402(true);
        }
    }
}

