/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.te;

import java.util.HashMap;
import java.util.List;
import mods.neiplugins.common.FuelTooltip;
import mods.neiplugins.common.SimpleFuelContextHelper;
import mods.neiplugins.common.SimpleFuelHelper;
import mods.neiplugins.common.Utils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TEFuelHelper {
    private static Utils.MethodInvoker Compression_getFuelEnergy;
    private static Utils.MethodInvoker Compression_getCoolantEnergy;
    private static Utils.MethodInvoker Compression_isValidFuel;
    private static Utils.MethodInvoker Compression_isValidCoolant;
    private static Utils.MethodInvoker Magmatic_getFuelEnergy;
    private static Utils.MethodInvoker Magmatic_isValidFuel;
    private static Utils.MethodInvoker Steam_getItemEnergyValue;

    public static void registerFuelHelpers() {
        Class cls = Utils.findClass("thermalexpansion.block.dynamo.TileDynamoCompression");
        if (cls != null) {
            Compression_getFuelEnergy = Utils.getMethodInvoker(cls, "getFuelEnergy", null, FluidStack.class);
            Compression_getCoolantEnergy = Utils.getMethodInvoker(cls, "getCoolantEnergy", null, FluidStack.class);
            Compression_isValidFuel = Utils.getMethodInvoker(cls, "isValidFuel", null, FluidStack.class);
            Compression_isValidCoolant = Utils.getMethodInvoker(cls, "isValidCoolant", null, FluidStack.class);
        }
        if ((cls = Utils.findClass("thermalexpansion.block.dynamo.TileDynamoMagmatic")) != null) {
            Magmatic_getFuelEnergy = Utils.getMethodInvoker(cls, "getFuelEnergy", null, FluidStack.class);
            Magmatic_isValidFuel = Utils.getMethodInvoker(cls, "isValidFuel", null, FluidStack.class);
        }
        if ((cls = Utils.findClass("thermalexpansion.block.dynamo.TileDynamoSteam")) != null) {
            Steam_getItemEnergyValue = Utils.getMethodInvoker(cls, "getItemEnergyValue", null, ItemStack.class);
        }
        if (Compression_getFuelEnergy != null && Compression_isValidFuel != null && Compression_getCoolantEnergy != null && Compression_isValidCoolant != null) {
            FuelTooltip.addFuelHelper(new SimpleFuelHelper("te.DynamoCompression", "Compression Dynamo fuel", null){

                @Override
                public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                    int fuelValue;
                    if (((Boolean)Compression_isValidFuel.invoke(liquid)).booleanValue() && (fuelValue = ((Integer)Compression_getFuelEnergy.invoke(liquid)).intValue()) > 0) {
                        fuelValue = fuelValue * liquid.amount / 10;
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (Compression Dynamo fuel)");
                    }
                    if (((Boolean)Compression_isValidCoolant.invoke(liquid)).booleanValue() && (fuelValue = ((Integer)Compression_getCoolantEnergy.invoke(liquid)).intValue()) > 0) {
                        fuelValue = fuelValue * liquid.amount / 10;
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (Compression Dynamo coolant)");
                    }
                    return currenttip;
                }
            });
        }
        if (Steam_getItemEnergyValue != null) {
            FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("te.DynamoSteam", "Steam Dynamo", null){

                @Override
                public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                    int fuelValue = (Integer)Steam_getItemEnergyValue.invoke(stack);
                    if (fuelValue > 0) {
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (Steam Dynamo)");
                    }
                    return currenttip;
                }
            });
        }
        if (Magmatic_getFuelEnergy != null && Magmatic_isValidFuel != null) {
            FuelTooltip.addFuelHelper(new SimpleFuelHelper("te.DynamoMagmatic", "Magmatic Dynamo", null){

                @Override
                public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                    if (!((Boolean)Magmatic_isValidFuel.invoke(liquid)).booleanValue()) {
                        return currenttip;
                    }
                    int fuelValue = (Integer)Magmatic_getFuelEnergy.invoke(liquid);
                    if (fuelValue > 0) {
                        fuelValue = fuelValue * liquid.amount / 10;
                        currenttip.add("\u00a77" + FuelTooltip.compactValue(fuelValue) + " RF (Magmatic Engine)");
                    }
                    return currenttip;
                }
            });
        }
        HashMap<Class, String> map = new HashMap<Class, String>();
        cls = Utils.findClass("thermalexpansion.gui.gui.dynamo.GuiDynamoCompression");
        if (cls != null) {
            map.put(cls, "te.DynamoCompression");
        }
        if ((cls = Utils.findClass("thermalexpansion.gui.gui.dynamo.GuiDynamoMagmatic")) != null) {
            map.put(cls, "te.DynamoMagmatic");
        }
        if ((cls = Utils.findClass("thermalexpansion.gui.gui.dynamo.GuiDynamoSteam")) != null) {
            map.put(cls, "te.DynamoSteam");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("te.DynamoAll", "Thermal Expansion", null, map));
        }
    }
}

