/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.util;

import buildcraft.api.transport.IPipeTile;
import cofh.api.transport.IItemConduit;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.inventory.InventoryManager;
import powercrystals.core.position.BlockPosition;

public abstract class UtilInventory {
    public static Map<ForgeDirection, IItemConduit> findConduits(World world, int n, int n2, int n3) {
        return UtilInventory.findConduits(world, n, n2, n3, ForgeDirection.VALID_DIRECTIONS);
    }

    public static Map<ForgeDirection, IItemConduit> findConduits(World world, int n, int n2, int n3, ForgeDirection[] forgeDirectionArray) {
        LinkedHashMap<ForgeDirection, IItemConduit> linkedHashMap = new LinkedHashMap<ForgeDirection, IItemConduit>();
        for (ForgeDirection forgeDirection : forgeDirectionArray) {
            BlockPosition blockPosition = new BlockPosition(n, n2, n3);
            blockPosition.orientation = forgeDirection;
            blockPosition.moveForwards(1);
            TileEntity tileEntity = world.func_72796_p(blockPosition.x, blockPosition.y, blockPosition.z);
            if (!(tileEntity instanceof IItemConduit)) continue;
            linkedHashMap.put(forgeDirection, (IItemConduit)tileEntity);
        }
        return linkedHashMap;
    }

    public static Map<ForgeDirection, IPipeTile> findPipes(World world, int n, int n2, int n3) {
        return UtilInventory.findPipes(world, n, n2, n3, ForgeDirection.VALID_DIRECTIONS);
    }

    public static Map<ForgeDirection, IPipeTile> findPipes(World world, int n, int n2, int n3, ForgeDirection[] forgeDirectionArray) {
        LinkedHashMap<ForgeDirection, IPipeTile> linkedHashMap = new LinkedHashMap<ForgeDirection, IPipeTile>();
        for (ForgeDirection forgeDirection : forgeDirectionArray) {
            BlockPosition blockPosition = new BlockPosition(n, n2, n3);
            blockPosition.orientation = forgeDirection;
            blockPosition.moveForwards(1);
            TileEntity tileEntity = world.func_72796_p(blockPosition.x, blockPosition.y, blockPosition.z);
            if (!(tileEntity instanceof IPipeTile)) continue;
            linkedHashMap.put(forgeDirection, (IPipeTile)tileEntity);
        }
        return linkedHashMap;
    }

    public static Map<ForgeDirection, IInventory> findChests(World world, int n, int n2, int n3) {
        return UtilInventory.findChests(world, n, n2, n3, ForgeDirection.VALID_DIRECTIONS);
    }

    public static Map<ForgeDirection, IInventory> findChests(World world, int n, int n2, int n3, ForgeDirection[] forgeDirectionArray) {
        LinkedHashMap<ForgeDirection, IInventory> linkedHashMap = new LinkedHashMap<ForgeDirection, IInventory>();
        for (ForgeDirection forgeDirection : forgeDirectionArray) {
            BlockPosition blockPosition = new BlockPosition(n, n2, n3);
            blockPosition.orientation = forgeDirection;
            blockPosition.moveForwards(1);
            TileEntity tileEntity = world.func_72796_p(blockPosition.x, blockPosition.y, blockPosition.z);
            if (tileEntity == null || !(tileEntity instanceof IInventory)) continue;
            linkedHashMap.put(forgeDirection, UtilInventory.checkForDoubleChest(world, tileEntity, blockPosition));
        }
        return linkedHashMap;
    }

    private static IInventory checkForDoubleChest(World world, TileEntity tileEntity, BlockPosition blockPosition) {
        if (world.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z) == Block.field_72077_au.field_71990_ca) {
            for (BlockPosition blockPosition2 : blockPosition.getAdjacent(false)) {
                if (world.func_72798_a(blockPosition2.x, blockPosition2.y, blockPosition2.z) != Block.field_72077_au.field_71990_ca) continue;
                return new InventoryLargeChest("Large Chest", (IInventory)tileEntity, (IInventory)world.func_72796_p(blockPosition2.x, blockPosition2.y, blockPosition2.z));
            }
        }
        return (IInventory)tileEntity;
    }

    public static ItemStack dropStack(TileEntity tileEntity, ItemStack itemStack) {
        return UtilInventory.dropStack(tileEntity.field_70331_k, new BlockPosition(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n), itemStack, ForgeDirection.VALID_DIRECTIONS, ForgeDirection.UNKNOWN);
    }

    public static ItemStack dropStack(TileEntity tileEntity, ItemStack itemStack, ForgeDirection forgeDirection) {
        return UtilInventory.dropStack(tileEntity.field_70331_k, new BlockPosition(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n), itemStack, ForgeDirection.VALID_DIRECTIONS, forgeDirection);
    }

    public static ItemStack dropStack(TileEntity tileEntity, ItemStack itemStack, ForgeDirection forgeDirection, ForgeDirection forgeDirection2) {
        ForgeDirection[] forgeDirectionArray = new ForgeDirection[]{forgeDirection};
        return UtilInventory.dropStack(tileEntity.field_70331_k, new BlockPosition(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n), itemStack, forgeDirectionArray, forgeDirection2);
    }

    public static ItemStack dropStack(TileEntity tileEntity, ItemStack itemStack, ForgeDirection[] forgeDirectionArray, ForgeDirection forgeDirection) {
        return UtilInventory.dropStack(tileEntity.field_70331_k, new BlockPosition(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n), itemStack, forgeDirectionArray, forgeDirection);
    }

    public static ItemStack dropStack(World world, BlockPosition blockPosition, ItemStack itemStack, ForgeDirection[] forgeDirectionArray, ForgeDirection forgeDirection) {
        Object object;
        if (itemStack == null || itemStack.field_77994_a == 0 || world.field_72995_K || itemStack.func_77973_b() == null) {
            return itemStack;
        }
        itemStack = itemStack.func_77946_l();
        for (Map.Entry<ForgeDirection, IItemConduit> entry : UtilInventory.findConduits(world, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirectionArray).entrySet()) {
            object = entry.getKey().getOpposite();
            itemStack = entry.getValue().sendItems(itemStack, (ForgeDirection)object);
            if (itemStack != null && itemStack.field_77994_a > 0) continue;
            return null;
        }
        for (Map.Entry<ForgeDirection, IItemConduit> entry : UtilInventory.findPipes(world, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirectionArray).entrySet()) {
            object = entry.getKey().getOpposite();
            if (!((IPipeTile)entry.getValue()).isPipeConnected((ForgeDirection)object) || ((IPipeTile)entry.getValue()).injectItem(itemStack.func_77946_l(), false, (ForgeDirection)object) <= 0) continue;
            itemStack.field_77994_a -= ((IPipeTile)entry.getValue()).injectItem(itemStack.func_77946_l(), true, (ForgeDirection)object);
            if (itemStack.field_77994_a > 0) continue;
            return null;
        }
        for (Map.Entry<ForgeDirection, IItemConduit> entry : UtilInventory.findChests(world, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirectionArray).entrySet()) {
            object = InventoryManager.create((IInventory)entry.getValue(), entry.getKey().getOpposite());
            itemStack = object.addItem(itemStack);
            if (itemStack != null && itemStack.field_77994_a != 0) continue;
            return null;
        }
        blockPosition.orientation = forgeDirection;
        blockPosition.moveForwards(1);
        if (Arrays.asList(ForgeDirection.VALID_DIRECTIONS).contains(forgeDirection) && world.func_72799_c(blockPosition.x, blockPosition.y, blockPosition.z)) {
            blockPosition.moveBackwards(1);
            UtilInventory.dropStackInAir(itemStack, blockPosition, world, forgeDirection);
            return null;
        }
        return itemStack;
    }

    private static void dropStackInAir(ItemStack itemStack, BlockPosition blockPosition, World world, ForgeDirection forgeDirection) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        switch (forgeDirection) {
            case UNKNOWN: 
            case UP: {
                f = 0.5f;
                f2 = 1.5f;
                f3 = 0.5f;
                break;
            }
            case DOWN: {
                f = 0.5f;
                f2 = -0.75f;
                f3 = 0.5f;
                break;
            }
            case NORTH: {
                f = 0.5f;
                f2 = 0.5f;
                f3 = -0.5f;
                break;
            }
            case SOUTH: {
                f = 0.5f;
                f2 = 0.5f;
                f3 = 1.5f;
                break;
            }
            case EAST: {
                f = 1.5f;
                f2 = 0.5f;
                f3 = 0.5f;
                break;
            }
            case WEST: {
                f = -0.5f;
                f2 = 0.5f;
                f3 = 0.5f;
                break;
            }
        }
        EntityItem entityItem = new EntityItem(world, (double)((float)blockPosition.x + f), (double)((float)blockPosition.y + f2), (double)((float)blockPosition.z + f3), itemStack.func_77946_l());
        entityItem.field_70159_w = 0.0;
        if (forgeDirection != ForgeDirection.DOWN) {
            entityItem.field_70181_x = 0.3;
        }
        entityItem.field_70179_y = 0.0;
        entityItem.field_70293_c = 20;
        world.func_72838_d((Entity)entityItem);
    }

    @Deprecated
    public static ItemStack consumeItem(ItemStack itemStack) {
        if (itemStack.field_77994_a <= 1) {
            if (itemStack.func_77973_b().func_77634_r()) {
                return itemStack.func_77973_b().getContainerItemStack(itemStack);
            }
            return null;
        }
        --itemStack.field_77994_a;
        return itemStack;
    }

    public static ItemStack consumeItem(ItemStack itemStack, EntityPlayer entityPlayer) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return null;
        }
        if (item.func_77634_r()) {
            ItemStack itemStack2 = item.getContainerItemStack(itemStack);
            if (itemStack.field_77994_a < 2) {
                return itemStack2;
            }
            if (!entityPlayer.field_71071_by.func_70441_a(itemStack2)) {
                entityPlayer.func_71021_b(itemStack2);
            }
        }
        --itemStack.field_77994_a;
        if (itemStack.field_77994_a > 0) {
            return itemStack;
        }
        return null;
    }

    public static void mergeStacks(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null) {
            return;
        }
        if (itemStack.field_77993_c != itemStack2.field_77993_c || itemStack.func_77960_j() != itemStack2.func_77960_j()) {
            return;
        }
        if (itemStack.func_77978_p() != null || itemStack2.func_77978_p() != null) {
            return;
        }
        int n = Math.min(itemStack.func_77976_d() - itemStack.field_77994_a, itemStack2.field_77994_a);
        itemStack.field_77994_a += n;
        itemStack2.field_77994_a -= n;
    }

    public static boolean stacksEqual(ItemStack itemStack, ItemStack itemStack2) {
        return UtilInventory.stacksEqual(itemStack, itemStack2, true);
    }

    public static boolean stacksEqual(ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        if (!itemStack.func_77969_a(itemStack2)) {
            return false;
        }
        if (bl) {
            if (itemStack.func_77978_p() == null && itemStack2.func_77978_p() == null) {
                return true;
            }
            if (itemStack.func_77978_p() == null || itemStack2.func_77978_p() == null) {
                return false;
            }
            return itemStack.func_77978_p().equals((Object)itemStack2.func_77978_p());
        }
        return true;
    }
}

