/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.bloodmagic;

import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipe;
import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipeRegistry;
import modtweaker.util.ItemHelper;
import modtweaker.util.TweakerBaseFunction;
import modtweaker.util.TweakerHelper;
import net.minecraft.item.ItemStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerValue;

public class AlchemyRemoveRecipe
extends TweakerBaseFunction {
    public static final AlchemyRemoveRecipe INSTANCE = new AlchemyRemoveRecipe();

    private AlchemyRemoveRecipe() {
        super("bloodmagic.alchemy.removeRecipe");
    }

    @Override
    public void perform(TweakerValue ... args) {
        if (TweakerHelper.canContinue(1, args)) {
            ItemStack output = TweakerHelper.getItem();
            Tweaker.apply((IUndoableAction)new Action(output));
        } else {
            TweakerHelper.throwException((TweakerBaseFunction)this, 1);
        }
    }

    private static class Action
    implements IUndoableAction {
        private final ItemStack result;
        private AlchemyRecipe recipe;

        public Action(ItemStack result) {
            this.result = result;
        }

        public void apply() {
            for (AlchemyRecipe r : AlchemyRecipeRegistry.recipes) {
                if (!ItemHelper.areEqual(this.result, r.getResult())) continue;
                this.recipe = r;
                break;
            }
            if (this.recipe != null) {
                AlchemyRecipeRegistry.recipes.remove(this.recipe);
            }
        }

        public boolean canUndo() {
            return AlchemyRecipeRegistry.recipes != null;
        }

        public void undo() {
            AlchemyRecipeRegistry.recipes.add(this.recipe);
        }

        public String describe() {
            return "Removing Alchemy Recipe: " + this.result.func_82833_r();
        }

        public String describeUndo() {
            return "Restoring Alchemy Recipe: " + this.result.func_82833_r();
        }
    }
}

