/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.exnihilo.action;

import exnihilo.registries.HeatRegistry;
import exnihilo.registries.helpers.HeatSource;
import java.util.Map;
import modtweaker.util.ItemHelper;
import net.minecraft.item.ItemStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItemStack;

public class HeatRemoveRecipeAction
implements IUndoableAction {
    private final TweakerItemStack result;
    private HeatSource recipe;

    public HeatRemoveRecipeAction(TweakerItemStack output) {
        this.result = output;
    }

    public void apply() {
        for (Map.Entry registry : HeatRegistry.entries.entrySet()) {
            HeatSource r = (HeatSource)registry.getValue();
            if (!ItemHelper.areEqual(this.result.get(), new ItemStack(r.id, 1, r.meta))) continue;
            this.recipe = r;
            break;
        }
        if (this.recipe != null) {
            HeatRegistry.entries.remove(this.recipe.id + ":" + this.recipe.meta);
        }
    }

    public boolean canUndo() {
        return HeatRegistry.entries != null;
    }

    public void undo() {
        HeatRegistry.entries.put(this.recipe.id + ":" + this.recipe.meta, this.recipe);
    }

    public String describe() {
        return "Removing Heat Source: " + this.result.getDisplayName();
    }

    public String describeUndo() {
        return "Restoring Heat Source: " + this.result.getDisplayName();
    }
}

