/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mekanism;

import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import modtweaker.mekanism.TweakerGasBase;
import modtweaker.mekanism.TweakerGasStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerField;
import stanhebben.minetweaker.api.value.TweakerString;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.base.actions.SetLocalizedStringAction;

public final class TweakerGas
extends TweakerGasBase {
    private final Gas gas;

    public TweakerGas(Gas gas) {
        this.gas = gas;
    }

    public Gas get() {
        return this.gas;
    }

    public GasStack make(int amount) {
        return new GasStack(this.gas, amount);
    }

    public boolean equalsGas(Gas gas) {
        if (gas == null) {
            return false;
        }
        return gas.getName().equals(this.gas.getName());
    }

    public String getName() {
        return this.gas.getName();
    }

    public String getDisplayName() {
        return this.gas.getLocalizedName();
    }

    @Override
    public TweakerGas asGas() {
        return this;
    }

    @Override
    public TweakerGasStack asGasStack() {
        return new TweakerGasStack(new GasStack(this.gas, 1));
    }

    public TweakerValue mul(TweakerValue value) {
        int amount = TweakerValue.notNull((TweakerValue)value, (String)"cannot multiply a gas by null").toInt("can only multiply a gas by an int value").get();
        return new TweakerGasStack(new GasStack(this.gas, amount));
    }

    public TweakerValue index(String index) {
        switch (TweakerField.get((String)index)) {
            case NAME: {
                return new TweakerString(this.gas.getUnlocalizedName());
            }
            case DISPLAYNAME: {
                return new TweakerString(this.gas.getLocalizedName());
            }
        }
        throw new TweakerExecuteException("no such field in gas: " + index);
    }

    public void indexSet(String index, TweakerValue value) {
        switch (TweakerField.get((String)index)) {
            case DISPLAYNAME: {
                Tweaker.apply((IUndoableAction)new SetLocalizedStringAction(this.gas.getUnlocalizedName(), "en_US", value.toBasicString()));
                return;
            }
        }
        throw new TweakerExecuteException("no such settable field in gas: " + index);
    }

    public boolean equals(TweakerValue other) {
        if (!(other instanceof TweakerGas)) {
            return false;
        }
        TweakerGas asGas = ((TweakerGas)other).asGas();
        if (asGas == null) {
            return false;
        }
        return asGas.gas.getName().equals(this.gas.getName());
    }

    @Override
    public String toString() {
        return "Gas:" + this.gas.getUnlocalizedName();
    }
}

