/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.tconstruct;

import modtweaker.tconstruct.TConstructHacks;
import modtweaker.util.TweakerBaseFunction;
import modtweaker.util.TweakerHelper;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerValue;
import tconstruct.library.crafting.AlloyMix;

public class AlloyRemoveRecipe
extends TweakerBaseFunction {
    public static final AlloyRemoveRecipe INSTANCE = new AlloyRemoveRecipe();

    private AlloyRemoveRecipe() {
        super("tconstruct.smeltery.removeAlloy");
    }

    @Override
    public void perform(TweakerValue ... args) {
        if (TweakerHelper.canContinue(1, args)) {
            FluidStack output = TweakerHelper.getFluid();
            Tweaker.apply((IUndoableAction)new Action(output));
        } else {
            TweakerHelper.throwException((TweakerBaseFunction)this, 1);
        }
    }

    private static class Action
    implements IUndoableAction {
        private final FluidStack output;
        private AlloyMix recipe;

        public Action(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            for (AlloyMix mix : TConstructHacks.alloys) {
                if (!mix.result.isFluidStackIdentical(this.output)) continue;
                this.recipe = mix;
                break;
            }
            TConstructHacks.alloys.remove(this.recipe);
        }

        public boolean canUndo() {
            return TConstructHacks.alloys != null;
        }

        public void undo() {
            TConstructHacks.alloys.add(this.recipe);
        }

        public String describe() {
            return "Removing Alloy Recipe: " + this.output.getFluid().getLocalizedName();
        }

        public String describeUndo() {
            return "Restoring Alloy Recipe: " + this.output.getFluid().getLocalizedName();
        }
    }
}

