/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.thermalexpansion;

import cofh.util.inventory.ComparableItemStackSafe;
import modtweaker.thermalexpansion.TEHacks;
import modtweaker.thermalexpansion.TEHelper;
import modtweaker.util.TweakerBaseFunction;
import modtweaker.util.TweakerHelper;
import net.minecraft.item.ItemStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerValue;
import thermalexpansion.util.crafting.FurnaceManager;

public class FurnaceAddRecipe
extends TweakerBaseFunction {
    public static final FurnaceAddRecipe INSTANCE = new FurnaceAddRecipe();

    private FurnaceAddRecipe() {
        super("thermalexpansion.furnace.addRecipe");
    }

    @Override
    public void perform(TweakerValue ... args) {
        if (TweakerHelper.canContinue(3, args)) {
            ItemStack input = TweakerHelper.getItem();
            ItemStack output = TweakerHelper.getItem();
            int energy = TweakerHelper.getInt();
            Tweaker.apply((IUndoableAction)new Action(new ComparableItemStackSafe(input), TEHelper.getFurnaceRecipe(input, output, energy)));
        } else {
            TweakerHelper.throwException((TweakerBaseFunction)this, 3);
        }
    }

    private static class Action
    implements IUndoableAction {
        private final ComparableItemStackSafe key;
        private final FurnaceManager.RecipeFurnace recipe;

        public Action(ComparableItemStackSafe key, FurnaceManager.RecipeFurnace recipe) {
            this.key = key;
            this.recipe = recipe;
        }

        public void apply() {
            TEHacks.furnace.put(this.key, this.recipe);
        }

        public boolean canUndo() {
            return TEHacks.furnace != null;
        }

        public void undo() {
            TEHacks.furnace.remove(this.key);
        }

        public String describe() {
            return "Adding TE Furnace Recipe: " + this.recipe.getInput().func_82833_r() + " to " + this.recipe.getOutput().func_82833_r();
        }

        public String describeUndo() {
            return "Adding TE Furnace Recipe: " + this.recipe.getInput().func_82833_r() + " to " + this.recipe.getOutput().func_82833_r();
        }
    }
}

