/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.blocks.tileentities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import exnihilo.data.BlockData;
import exnihilo.particles.ParticleSieve;
import exnihilo.registries.SieveRegistry;
import exnihilo.registries.helpers.Color;
import exnihilo.registries.helpers.SiftReward;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;

public class TileEntitySieve
extends TileEntity {
    private static final float MIN_RENDER_CAPACITY = 0.7f;
    private static final float MAX_RENDER_CAPACITY = 0.9f;
    private static final float PROCESSING_INTERVAL = 0.075f;
    private static final int UPDATE_INTERVAL = 20;
    private Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public int contentID = 0;
    public int contentMeta = 0;
    private float volume = 0.0f;
    public SieveMode mode = SieveMode.EMPTY;
    private int timer = 0;
    private boolean update = false;
    private boolean particleMode = false;
    private int timesClicked = 0;

    public void addSievable(int blockID, int blockMeta) {
        this.contentID = blockID;
        this.contentMeta = blockMeta;
        this.mode = SieveMode.FILLED;
        this.volume = 1.0f;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K && this.particleMode) {
            this.spawnFX(this.contentID, this.contentMeta);
        }
        ++this.timer;
        if (this.timer >= 20) {
            this.timesClicked = 0;
            this.timer = 0;
            this.disableParticles();
            if (this.update) {
                this.update();
            }
        }
    }

    public void ProcessContents(boolean creative) {
        if (creative) {
            this.volume = 0.0f;
        } else {
            ++this.timesClicked;
            if (this.timesClicked <= 6) {
                this.volume -= 0.075f;
            }
        }
        if (this.volume <= 0.0f) {
            ArrayList<SiftReward> rewards;
            this.mode = SieveMode.EMPTY;
            if (!this.field_70331_k.field_72995_K && (rewards = SieveRegistry.getRewards(this.contentID, this.contentMeta)).size() > 0) {
                for (SiftReward reward : rewards) {
                    if (this.field_70331_k.field_73012_v.nextInt(reward.rarity) != 0) continue;
                    EntityItem entityitem = new EntityItem(this.field_70331_k, (double)this.field_70329_l + 0.5, (double)this.field_70330_m + 1.5, (double)this.field_70327_n + 0.5, new ItemStack(reward.id, 1, reward.meta));
                    double f3 = 0.05f;
                    entityitem.field_70159_w = this.field_70331_k.field_73012_v.nextGaussian() * f3;
                    entityitem.field_70181_x = 0.2;
                    entityitem.field_70179_y = this.field_70331_k.field_73012_v.nextGaussian() * f3;
                    this.field_70331_k.func_72838_d((Entity)entityitem);
                }
            }
        } else {
            this.particleMode = true;
        }
        this.update = true;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnFX(int blockID, int blockMeta) {
        Block block = Block.field_71973_m[blockID];
        if (block != null) {
            Icon icon = block.func_71858_a(0, blockMeta);
            for (int x = 0; x < 4; ++x) {
                ParticleSieve dust = new ParticleSieve(this.field_70331_k, (double)this.field_70329_l + 0.8 * (double)this.field_70331_k.field_73012_v.nextFloat() + 0.15, (double)this.field_70330_m + 0.69, (double)this.field_70327_n + 0.8 * (double)this.field_70331_k.field_73012_v.nextFloat() + 0.15, 0.0, 0.0, 0.0, icon);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)dust);
            }
        }
    }

    public float getAdjustedVolume() {
        float capacity = 0.19999999f;
        float adjusted = this.volume * capacity;
        return adjusted += 0.7f;
    }

    private void update() {
        this.update = false;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    private void disableParticles() {
        this.particleMode = false;
    }

    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        switch (compound.func_74762_e("mode")) {
            case 0: {
                this.mode = SieveMode.EMPTY;
                break;
            }
            case 1: {
                this.mode = SieveMode.FILLED;
            }
        }
        this.contentID = compound.func_74762_e("contentID");
        this.contentMeta = compound.func_74762_e("contentMeta");
        this.volume = compound.func_74760_g("volume");
        this.particleMode = compound.func_74767_n("particles");
    }

    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        compound.func_74768_a("mode", this.mode.value);
        compound.func_74768_a("contentID", this.contentID);
        compound.func_74768_a("contentMeta", this.contentMeta);
        compound.func_74776_a("volume", this.volume);
        compound.func_74757_a("particles", this.particleMode);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, BlockData.SIEVE_ID, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        NBTTagCompound tag = pkt.field_73331_e;
        this.func_70307_a(tag);
    }

    public static enum SieveMode {
        EMPTY(0),
        FILLED(1);

        public int value;

        private SieveMode(int v) {
            this.value = v;
        }
    }
}

