/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.registries;

import exnihilo.Blocks;
import exnihilo.Items;
import exnihilo.registries.helpers.SiftReward;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.Configuration;

public class SieveRegistry {
    public static ArrayList<SiftReward> rewards = new ArrayList();
    public static boolean dropCopper = false;
    public static boolean dropTin = false;
    public static boolean dropSilver = false;
    public static boolean dropLead = false;
    public static boolean dropNickel = false;
    public static boolean dropPlatinum = false;
    public static boolean dropAluminum = false;
    public static boolean dropRubberSeeds = false;

    public static void register(int sourceID, int sourceMeta, int outputID, int outputMeta, int rarity) {
        SiftReward entry = new SiftReward(sourceID, sourceMeta, outputID, outputMeta, rarity);
        if (Block.field_71973_m[sourceID] != null) {
            rewards.add(entry);
        } else {
            System.out.println("Ex Nihilo: An item was added to the SieveRegistry which was not a block");
        }
    }

    public static void register(int sourceID, int outputID, int outputMeta, int rarity) {
        SiftReward entry = new SiftReward(sourceID, outputID, outputMeta, rarity);
        if (Block.field_71973_m[sourceID] != null) {
            rewards.add(entry);
        } else {
            System.out.println("Ex Nihilo: An item was added to the SieveRegistry which was not a block");
        }
    }

    public static ArrayList<SiftReward> getRewards(int id, int meta) {
        ArrayList<SiftReward> rewardList = new ArrayList<SiftReward>();
        for (SiftReward reward : rewards) {
            if (reward.sourceID != id || reward.sourceMeta != meta) continue;
            rewardList.add(reward);
        }
        return rewardList;
    }

    public static boolean Contains(int id, int meta) {
        for (SiftReward reward : rewards) {
            if (reward.sourceID != id || reward.sourceMeta != meta && !reward.ignoreMeta) continue;
            return true;
        }
        return false;
    }

    public static boolean Contains(int id) {
        for (SiftReward reward : rewards) {
            if (reward.sourceID != id || !reward.ignoreMeta) continue;
            return true;
        }
        return false;
    }

    public static void load(Configuration config) {
        String CATEGORY_SIEVE_OPTIONS = "sieve options";
        dropCopper = config.get(CATEGORY_SIEVE_OPTIONS, "give copper", false, "Forces the sieve to give copper even if no mods are detected which require it.").getBoolean(false);
        dropTin = config.get(CATEGORY_SIEVE_OPTIONS, "give tin", false, "Forces the sieve to give tin even if no mods are detected which require it.").getBoolean(false);
        dropLead = config.get(CATEGORY_SIEVE_OPTIONS, "give lead", false, "Forces the sieve to give lead even if no mods are detected which require it.").getBoolean(false);
        dropSilver = config.get(CATEGORY_SIEVE_OPTIONS, "give silver", false, "Forces the sieve to give silver even if no mods are detected which require it.").getBoolean(false);
        dropNickel = config.get(CATEGORY_SIEVE_OPTIONS, "give nickel", false, "Forces the sieve to give nickel even if no mods are detected which require it.").getBoolean(false);
        dropPlatinum = config.get(CATEGORY_SIEVE_OPTIONS, "give platinum", false, "Forces the sieve to give platinum even if no mods are detected which require it.").getBoolean(false);
        dropAluminum = config.get(CATEGORY_SIEVE_OPTIONS, "give aluminum", false, "Forces the sieve to give aluminum even if no mods are detected which require it.").getBoolean(false);
    }

    public static void registerRewards() {
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.Stones.field_77779_bT, 0, 1);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.Stones.field_77779_bT, 0, 1);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.Stones.field_77779_bT, 0, 2);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.Stones.field_77779_bT, 0, 2);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.Stones.field_77779_bT, 0, 3);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.Stones.field_77779_bT, 0, 3);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Item.field_77690_S.field_77779_bT, 0, 15);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.GrassSeeds.field_77779_bT, 0, 15);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Item.field_77740_bh.field_77779_bT, 0, 32);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Item.field_77739_bg.field_77779_bT, 0, 32);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.SeedsSugarcane.field_77779_bT, 0, 32);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.SeedsCarrot.field_77779_bT, 0, 64);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.SeedsPotato.field_77779_bT, 0, 64);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.SeedsOak.field_77779_bT, 0, 64);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.SeedsSpruce.field_77779_bT, 0, 90);
        SieveRegistry.register(Block.field_71979_v.field_71990_ca, 0, Items.SeedsBirch.field_77779_bT, 0, 90);
        SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Item.field_77804_ap.field_77779_bT, 0, 4);
        SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Items.IronGravel.field_77779_bT, 0, 5);
        SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Items.GoldGravel.field_77779_bT, 0, 11);
        SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Item.field_77705_m.field_77779_bT, 0, 8);
        SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Item.field_77756_aW.field_77779_bT, 4, 20);
        SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Item.field_77702_n.field_77779_bT, 0, 128);
        SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Item.field_77817_bH.field_77779_bT, 0, 150);
        SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Items.IronSand.field_77779_bT, 0, 5);
        SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Items.GoldSand.field_77779_bT, 0, 11);
        SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Item.field_77756_aW.field_77779_bT, 3, 32);
        SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Items.SeedsCactus.field_77779_bT, 0, 32);
        SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Items.SeedsJungle.field_77779_bT, 0, 64);
        SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Items.Spores.field_77779_bT, 0, 128);
        SieveRegistry.register(Block.field_72013_bc.field_71990_ca, 0, Item.field_94583_ca.field_77779_bT, 0, 1);
        SieveRegistry.register(Block.field_72013_bc.field_71990_ca, 0, Item.field_94583_ca.field_77779_bT, 0, 3);
        SieveRegistry.register(Block.field_72013_bc.field_71990_ca, 0, Item.field_77727_br.field_77779_bT, 0, 20);
        SieveRegistry.register(Block.field_72013_bc.field_71990_ca, 0, Item.field_77732_bp.field_77779_bT, 0, 64);
        SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Items.IronDust.field_77779_bT, 0, 5);
        SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Items.GoldDust.field_77779_bT, 0, 11);
        SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Item.field_77756_aW.field_77779_bT, 15, 5);
        SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Item.field_77767_aC.field_77779_bT, 0, 8);
        SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Item.field_77677_M.field_77779_bT, 0, 15);
        SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Item.field_77751_aT.field_77779_bT, 0, 16);
        SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Item.field_77722_bw.field_77779_bT, 0, 20);
    }

    public static void RegisterOptionalOres() {
        if (dropCopper) {
            SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Items.CopperGravel.field_77779_bT, 0, 7);
            SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Items.CopperSand.field_77779_bT, 0, 7);
            SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Items.CopperDust.field_77779_bT, 0, 7);
        }
        if (dropTin) {
            SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Items.TinGravel.field_77779_bT, 0, 7);
            SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Items.TinSand.field_77779_bT, 0, 7);
            SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Items.TinDust.field_77779_bT, 0, 7);
        }
        if (dropSilver) {
            SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Items.SilverGravel.field_77779_bT, 0, 11);
            SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Items.SilverSand.field_77779_bT, 0, 11);
            SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Items.SilverDust.field_77779_bT, 0, 11);
        }
        if (dropLead) {
            SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Items.LeadGravel.field_77779_bT, 0, 9);
            SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Items.LeadSand.field_77779_bT, 0, 9);
            SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Items.LeadDust.field_77779_bT, 0, 9);
        }
        if (dropNickel) {
            SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Items.NickelGravel.field_77779_bT, 0, 11);
            SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Items.NickelSand.field_77779_bT, 0, 11);
            SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Items.NickelDust.field_77779_bT, 0, 11);
        }
        if (dropPlatinum) {
            SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Items.PlatinumGravel.field_77779_bT, 0, 32);
            SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Items.PlatinumSand.field_77779_bT, 0, 32);
            SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Items.PlatinumDust.field_77779_bT, 0, 32);
        }
        if (dropAluminum) {
            SieveRegistry.register(Block.field_71940_F.field_71990_ca, 0, Items.AluminumGravel.field_77779_bT, 0, 10);
            SieveRegistry.register(Block.field_71939_E.field_71990_ca, 0, Items.AluminumSand.field_77779_bT, 0, 10);
            SieveRegistry.register(Blocks.Dust.field_71990_ca, 0, Items.AluminumDust.field_77779_bT, 0, 10);
        }
    }
}

