/*
 * Decompiled with CFR 0.152.
 */
package nl.lang2619.rockdigger;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;
import nl.lang2619.rockdigger.BlockRegistry;
import nl.lang2619.rockdigger.LoggerHelper;
import nl.lang2619.rockdigger.RockTab;
import nl.lang2619.rockdigger.config.BlockConfig;
import nl.lang2619.rockdigger.config.ConfigLoader;
import nl.lang2619.rockdigger.proxy.CommonProxy;
import nl.lang2619.rockdigger.world.RockGen;

@Mod(modid="RockDigger", name="Rock Digger", version="1.0.0")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class RockDigger {
    @SidedProxy(clientSide="nl.lang2619.rockdigger.proxy.ClientProxy", serverSide="nl.lang2619.rockdigger.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs RockTab;
    public static RockGen rockGen;
    public static RockDigger _instance;
    public static String path;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LoggerHelper.init();
        LoggerHelper.log(Level.INFO, "preInit()");
        _instance = this;
        File rootFolder = null;
        try {
            String rootFolderName = event.getModConfigurationDirectory() + File.separator + "RockDigger".toLowerCase();
            rootFolder = ConfigLoader.getInstance().init(rootFolderName);
            List<BlockConfig> configs = ConfigLoader.getInstance().findBlocks(rootFolder);
            BlockRegistry.registerAll(configs);
        }
        catch (IOException e) {
            RockDigger.log("Something went wrong while trying to initialize config folder and template, no blocks were registered.", Level.SEVERE);
            System.err.println(e);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LoggerHelper.log(Level.INFO, "init()");
        rockGen = new RockGen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)rockGen);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LoggerHelper.log(Level.INFO, "postInit()");
        MinecraftForge.EVENT_BUS.register((Object)proxy);
    }

    public static void log(String message) {
        RockDigger.log(message, Level.INFO);
    }

    public static void log(String message, Level level) {
        LoggerHelper.log(level, message);
    }

    static {
        RockTab = new RockTab(CreativeTabs.getNextID(), "Rock Digger");
    }
}

