/*
 * Decompiled with CFR 0.152.
 */
package nl.lang2619.rockdigger.proxy;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.Icon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.ForgeSubscribe;
import nl.lang2619.rockdigger.BlockRegistry;
import nl.lang2619.rockdigger.block.RockBlock;
import nl.lang2619.rockdigger.block.RockSlab;
import nl.lang2619.rockdigger.client.ExternalTextureAtlasSprite;
import nl.lang2619.rockdigger.proxy.CommonProxy;

public class ClientProxy
extends CommonProxy {
    private static boolean ISOBFUSICATED_CHECKED = false;
    private static boolean ISOBFUSICATED;
    private static final int BLOCK_TEXTURE_TYPE = 0;

    public static boolean isObfusicated() {
        if (!ISOBFUSICATED_CHECKED) {
            ISOBFUSICATED_CHECKED = true;
            ISOBFUSICATED = false;
            try {
                Minecraft.func_71410_x().getClass().getField("currentScreen");
            }
            catch (NoSuchFieldException e) {
                ISOBFUSICATED = true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return ISOBFUSICATED;
    }

    private static final String getMapRegisteredSpritesFieldName() {
        if (ClientProxy.isObfusicated()) {
            return "field_110574_e";
        }
        return "mapRegisteredSprites";
    }

    private Map<String, TextureAtlasSprite> getRegisteredSpritesMap(TextureMap textureMap) {
        try {
            Field registeredSpritesMapField = TextureMap.class.getDeclaredField(ClientProxy.getMapRegisteredSpritesFieldName());
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(registeredSpritesMapField, registeredSpritesMapField.getModifiers() & 0xFFFFFFEF);
            registeredSpritesMapField.setAccessible(true);
            return (Map)registeredSpritesMapField.get(textureMap);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @ForgeSubscribe
    public void textureHook(TextureStitchEvent.Pre event) throws IOException {
        if (event.map.field_94255_a == 0) {
            for (RockBlock block : BlockRegistry.REGISTERED_BLOCKS) {
                if (block.getConfig().hasResourceTexture()) continue;
                TextureAtlasSprite oldSprite = event.map.getTextureExtry(block.func_111023_E());
                Map<String, TextureAtlasSprite> spritesMap = this.getRegisteredSpritesMap(event.map);
                ExternalTextureAtlasSprite newSprite = new ExternalTextureAtlasSprite(oldSprite, block.getConfig().getIconPath());
                spritesMap.put(block.func_111023_E(), newSprite);
                block.setIcon((Icon)newSprite);
            }
        }
    }

    @ForgeSubscribe
    public void textureHook(TextureStitchEvent.Post event) throws IOException {
        if (event.map.field_94255_a == 0) {
            for (RockSlab block : BlockRegistry.REGISTERED_SLABS) {
                if (block.getConfig().hasResourceTexture()) continue;
                TextureAtlasSprite oldSprite = event.map.getTextureExtry(block.func_111023_E());
                Map<String, TextureAtlasSprite> spritesMap = this.getRegisteredSpritesMap(event.map);
                ExternalTextureAtlasSprite newSprite = new ExternalTextureAtlasSprite(oldSprite, block.getConfig().getIconPath());
                spritesMap.put(block.func_111023_E(), newSprite);
                block.setIcon((Icon)newSprite);
            }
        }
    }
}

