/*
 * Decompiled with CFR 0.152.
 */
package nl.lang2619.rockdigger.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import nl.lang2619.rockdigger.BlockRegistry;
import nl.lang2619.rockdigger.block.RockBlock;

public class RockGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == 0) {
            for (int i = 0; i < BlockRegistry.REGISTERED_BLOCKS.size(); ++i) {
                this.generateSurface(BlockRegistry.REGISTERED_BLOCKS.get(i), world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(RockBlock block, World world, Random random, int x, int z) {
        this.generateBlock(block, world, random, x, z, block.getVeinSize(), block.getRarity());
    }

    void generateBlock(RockBlock block, World world, Random random, int xChunk, int zChunk, int maxVein, int spawnChance) {
        BiomeGenBase biome = world.func_72959_q().func_76935_a(xChunk, zChunk);
        for (int i = 0; i < block.getBiome().size(); ++i) {
            if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)block.getBiome().get(i).getBiomeType())) continue;
            for (int q = 0; q < spawnChance; ++q) {
                int xPos = xChunk + random.nextInt(16);
                int yPos = block.getHeight() + random.nextInt(block.getRange());
                int zPos = zChunk + random.nextInt(16);
                for (int u = 0; u < BlockRegistry.REGISTERED_BLOCKS.size(); ++u) {
                    new WorldGenMinable(block.field_71990_ca, maxVein).func_76484_a(world, random, xPos, yPos, zPos);
                }
            }
        }
    }
}

