/*
 * Decompiled with CFR 0.152.
 */
package appeng.common;

import appeng.api.WorldCoord;
import appeng.common.AppEng;
import appeng.common.network.packets.PacketNewStorageDim;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DimensionManager;

public class AppEngWorldSettings
extends Configuration {
    private static AppEngWorldSettings instance;
    List<Integer> storageCellDims = new ArrayList<Integer>();

    public AppEngWorldSettings(File f) {
        super(f);
    }

    public static AppEngWorldSettings getInstance() {
        if (instance == null) {
            MinecraftServer srv = MinecraftServer.func_71276_C();
            File f = DimensionManager.getWorld((int)0).func_72860_G().func_75758_b("AppEng");
            instance = new AppEngWorldSettings(f);
        }
        return instance;
    }

    public void addStorageCellDim(int newDim) {
        this.storageCellDims.add(newDim);
        DimensionManager.registerDimension((int)newDim, (int)AppEng.getInstance().config.storageProviderID);
        try {
            PacketNewStorageDim pnsd = new PacketNewStorageDim(newDim);
            PacketDispatcher.sendPacketToAllPlayers((Packet)pnsd.getPacket());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] values = new String[this.storageCellDims.size()];
        for (int x = 0; x < values.length; ++x) {
            values[x] = "" + this.storageCellDims.get(x);
        }
        this.get("DimensionManager", "StorageCells", new int[0]).set(values);
        this.save();
    }

    public LinkedList<Packet> getJoinPackets() {
        LinkedList<Packet> out = new LinkedList<Packet>();
        List set = Lists.partition(this.storageCellDims, (int)800);
        for (List o : set) {
            try {
                PacketNewStorageDim pnsd = new PacketNewStorageDim(o);
                out.add((Packet)pnsd.getPacket());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    public void sendToPlayer(Player p) {
        for (Packet pak : this.getJoinPackets()) {
            PacketDispatcher.sendPacketToPlayer((Packet)pak, (Player)p);
        }
    }

    public void init() {
        for (int x : this.get("DimensionManager", "StorageCells", new int[0]).getIntList()) {
            this.storageCellDims.add(x);
            DimensionManager.registerDimension((int)x, (int)AppEng.getInstance().config.storageProviderID);
        }
        this.save();
    }

    public void shutdown() {
        for (int x : this.storageCellDims) {
            DimensionManager.unregisterDimension((int)x);
        }
        this.storageCellDims.clear();
        instance = null;
    }

    public WorldCoord getStoredSize(int dim) {
        int x = this.get("StorageCell" + dim, "scaleX", 0).getInt();
        int y = this.get("StorageCell" + dim, "scaleY", 0).getInt();
        int z = this.get("StorageCell" + dim, "scaleZ", 0).getInt();
        return new WorldCoord(x, y, z);
    }

    public void setStoredSize(int dim, int targetX, int targetY, int targetZ) {
        this.get("StorageCell" + dim, "scaleX", 0).set(targetX);
        this.get("StorageCell" + dim, "scaleY", 0).set(targetY);
        this.get("StorageCell" + dim, "scaleZ", 0).set(targetZ);
        this.save();
    }
}

