/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.base;

import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngTile;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AppEngSubBlock {
    private boolean isBlockEnabled = true;
    protected String unlocalizedName = "Untitled Block";
    protected int metaData;
    protected AppEngMultiBlock imb;

    public boolean isEnabled() {
        return this.isBlockEnabled;
    }

    public int getBlockID() {
        return this.imb.field_71990_ca;
    }

    public int getMetaData() {
        return this.metaData;
    }

    public AppEngSubBlock(AppEngMultiBlock mb, boolean isEnabled) {
        this.imb = mb;
        this.metaData = mb.addSubBlock(this);
        this.isBlockEnabled = isEnabled;
    }

    public ItemStack getItemStack(int x) {
        return new ItemStack((Block)this.imb, x, this.metaData);
    }

    public ItemStack getItemStack() {
        return new ItemStack((Block)this.imb, 1, this.metaData);
    }

    public TileEntity createNewTileEntity(World w) {
        return null;
    }

    public boolean hasTileEntity() {
        return false;
    }

    public Icon getBlockTextureFromSide(int side) {
        return AppEngTextureRegistry.Blocks.NullIcon.get();
    }

    public boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer p, int side) {
        return false;
    }

    public void breakBlock(World world, int x, int y, int z) {
    }

    public void onNeighborBlockChange(World w, int x, int y, int z, int blockid) {
        TileEntity te;
        if (this.hasTileEntity() && (te = w.func_72796_p(x, y, z)) instanceof AppEngTile) {
            ((AppEngTile)te).onNeighborBlockChange();
        }
    }

    public void getDrops(World w, int x, int y, int z, int fortune, ArrayList drops) {
        drops.add(new ItemStack(this.imb.field_71990_ca, 1, this.metaData));
    }

    public boolean canConnectRedstone(IBlockAccess w, int x, int y, int z, int side) {
        TileEntity te;
        if (this.hasTileEntity() && (te = w.func_72796_p(x, y, z)) instanceof AppEngTile) {
            return ((AppEngTile)te).canConnectRedstone(side);
        }
        return false;
    }

    public abstract boolean isOpaqueCube();

    public void onEntityCollidedWithBlock(World w, int x, int y, int z, Entity entitiy) {
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World w, int x, int y, int z, ItemStack is) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x + minX, (double)y + minY, (double)z + minZ, (double)x + maxX, (double)y + maxY, (double)z + maxZ);
    }

    public int getLightOpacity() {
        return 255;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata2) {
        return this.isOpaqueCube();
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public int quantityDroppedWithBonus(int meta, Random rand) {
        return 1;
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public int idDropped(int meta, Random rand, int fortune) {
        return this.imb.field_71990_ca;
    }

    public void onBlockDismantle(World w, int x, int y, int z, EntityPlayer player, int side) {
        int id = w.func_72798_a(x, y, z);
        if (id != 0) {
            AppEngTile tile = this.imb.getTile((IBlockAccess)w, x, y, z);
            ItemStack[] drops = Platform.getBlockDrops(w, x, y, z);
            ItemStack op = this.getItemStack();
            for (ItemStack ol : drops) {
                NBTTagCompound tag;
                if (!Platform.isSameItemType(ol, op) || !(tile instanceof AppEngTile) || (tag = tile.getSettings(AppEngTile.ConfigMode.Wrench)) == null) continue;
                ol.func_77982_d(tag);
            }
            if (Block.field_71973_m[id].removeBlockByPlayer(w, player, x, y, z)) {
                ArrayList<ItemStack> l = new ArrayList<ItemStack>();
                for (ItemStack is : drops) {
                    l.add(is);
                }
                Platform.spawnDrops(w, x, y, z, l);
                w.func_94571_i(x, y, z);
            }
        }
    }

    public void updateTick(World w, int x, int y, int z, Random r) {
        TileEntity tileEntity = w.func_72796_p(x, y, z);
        if (tileEntity instanceof AppEngTile) {
            tileEntity.func_70316_g();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasSpecialRender() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean specialRenderer(IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World w, int x, int y, int z, Random r) {
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 0;
    }

    public void getSubBlocks(List subItems) {
        ItemStack mbs = new ItemStack((Block)this.imb, 1, this.metaData);
        subItems.add(mbs);
    }

    public float getBlockHardness(World w, int x, int y, int z) {
        return this.imb.field_71989_cb;
    }

    public int getSidedMetadata(int meta, int side) {
        return meta;
    }

    public boolean isAirBlock(World world, int x, int y, int z) {
        return false;
    }

    public boolean canBeReplacedByLeaves(World w, int x, int y, int z) {
        return false;
    }

    public boolean canCollideCheck(int meta, boolean par2) {
        return true;
    }

    public boolean isBlockReplaceable(World w, int x, int y, int z) {
        return false;
    }

    public boolean canBeBroken(World w, int x, int y, int z) {
        return true;
    }
}

