/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.network.packets;

import appeng.common.AppEng;
import appeng.common.network.AppEngPacket;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.INetworkManager;
import net.minecraftforge.common.DimensionManager;

public class PacketNewStorageDim
extends AppEngPacket {
    int[] id;

    @Override
    public void clientPacketData(INetworkManager network, AppEngPacket packet, Player player) {
        try {
            for (int x = 0; x < this.id.length; ++x) {
                if (DimensionManager.isDimensionRegistered((int)this.id[x])) continue;
                DimensionManager.registerDimension((int)this.id[x], (int)AppEng.getInstance().config.storageProviderID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PacketNewStorageDim(DataInputStream stream) throws IOException {
        int len = stream.readShort();
        this.id = new int[len];
        for (int x = 0; x < len; ++x) {
            this.id[x] = stream.readInt();
        }
    }

    public PacketNewStorageDim(List<Integer> o) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        data.writeInt(this.getPacketID());
        data.writeShort(o.size());
        for (Integer p : o) {
            data.writeInt(p);
        }
        this.isChunkDataPacket = false;
        this.configureWrite(bytes.toByteArray());
    }

    public PacketNewStorageDim(int newDim) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        data.writeInt(this.getPacketID());
        data.writeShort(1);
        data.writeInt(newDim);
        this.isChunkDataPacket = false;
        this.configureWrite(bytes.toByteArray());
    }
}

