/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.TileRef;
import appeng.api.config.FuzzyMode;
import appeng.api.config.ItemFlow;
import appeng.api.config.ListMode;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventory;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.interfaces.ICellFeedBack;
import appeng.interfaces.IMEInterfaceHandlerExtended;
import appeng.interfaces.INetworkNotifiable;
import appeng.me.MEInventoryArray;
import appeng.util.ItemList;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class MEInventoryHandler
implements IMEInterfaceHandlerExtended {
    int myCellIndex;
    int priority;
    IItemList filter;
    ItemFlow flow = ItemFlow.READ_WRITE;
    ListMode lmode = ListMode.WHITELIST;
    FuzzyMode fmode = FuzzyMode.Percent_99;
    boolean fuzzyFilter;
    IMEInventoryHandler p;
    List<TileRef<TileEntity>> src;
    IMEInventory inv;
    IGridInterface g;

    @Override
    public IMEInventoryHandler getParent() {
        return this.p;
    }

    @Override
    public void setParent(IMEInventoryHandler _p) {
        this.p = _p;
    }

    public MEInventoryHandler(IMEInventory obj) {
        this.inv = obj;
        if (obj instanceof MEInventoryArray) {
            throw new RuntimeException("Invalid usage of InvHandler");
        }
    }

    @Override
    public long storedItemTypes() {
        return this.inv.storedItemTypes();
    }

    @Override
    public long storedItemCount() {
        return this.inv.storedItemCount();
    }

    @Override
    public long remainingItemCount() {
        return this.inv.remainingItemCount();
    }

    @Override
    public long remainingItemTypes() {
        return this.inv.remainingItemTypes();
    }

    @Override
    public boolean containsItemType(IAEItemStack i) {
        return this.inv.containsItemType(i);
    }

    @Override
    public long getTotalItemTypes() {
        return this.inv.getTotalItemTypes();
    }

    @Override
    public long countOfItemType(IAEItemStack i) {
        return this.inv.countOfItemType(i);
    }

    void updateTE() {
        try {
            if (this.src != null) {
                for (TileRef<TileEntity> srci : this.src) {
                    TileEntity tx = srci.getTile();
                    tx.func_70296_d();
                }
            }
        }
        catch (AppEngTileMissingException appEngTileMissingException) {
            // empty catch block
        }
    }

    @Override
    public boolean canAccept(IAEItemStack s) {
        if (this.isPreformatted()) {
            List<ItemStack> l = this.getPreformattedItems();
            boolean hasList = l.size() > 0 && this.getListMode() == ListMode.WHITELIST;
            for (int x = 0; x < l.size(); ++x) {
                ItemStack is = l.get(x);
                if (is == null) continue;
                if (this.isFuzzyPreformatted()) {
                    if (!Platform.isSameItemFuzzy(is, Platform.getSharedItemStack(s), this.getFuzzyModePreformatted())) continue;
                    return this.getListMode() == ListMode.WHITELIST;
                }
                if (!Platform.isSameItemPrecise(is, Platform.getSharedItemStack(s))) continue;
                return this.getListMode() == ListMode.WHITELIST;
            }
            return !hasList;
        }
        return true;
    }

    private void updateSrc(long old, IAEItemStack input) {
        if (this.src != null) {
            for (TileRef<TileEntity> srci : this.src) {
                try {
                    TileEntity te = srci.getTile();
                    if (te instanceof INetworkNotifiable) {
                        IAEItemStack vo = input.copy();
                        if (old > 0L) {
                            vo.setStackSize(old);
                            ((INetworkNotifiable)te).notifyAddItems(vo);
                        } else {
                            vo.setStackSize(-old);
                            ((INetworkNotifiable)te).notifyExtractItems(vo);
                        }
                    }
                    if (te instanceof ICellFeedBack) {
                        ((ICellFeedBack)te).updateCellIndex(this.myCellIndex);
                    }
                    te.func_70296_d();
                }
                catch (AppEngTileMissingException e) {}
            }
        }
    }

    @Override
    public IAEItemStack addItems(IAEItemStack input) {
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (this.flow == ItemFlow.READ) {
            return input;
        }
        if (!this.canAccept(input)) {
            return input;
        }
        IAEItemStack Out = this.inv.addItems(input);
        if (Out == null) {
            this.updateSrc(input.getStackSize(), input);
            return null;
        }
        if (Out.getStackSize() != input.getStackSize()) {
            this.updateSrc(input.getStackSize() - Out.getStackSize(), input);
        }
        return Out;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request) {
        if (request == null) {
            return null;
        }
        if (request.getStackSize() == 0L) {
            return null;
        }
        if (this.flow == ItemFlow.WRITE) {
            return null;
        }
        IAEItemStack Out = this.inv.extractItems(request);
        if (Out != null) {
            this.updateSrc(-Out.getStackSize(), request);
            this.updateTE();
        }
        return Out;
    }

    @Override
    public IItemList getAvailableItems(IItemList out) {
        if (this.flow == ItemFlow.WRITE) {
            return out;
        }
        return this.inv.getAvailableItems(out);
    }

    @Override
    public IAEItemStack calculateItemAddition(IAEItemStack input) {
        if (this.flow == ItemFlow.READ) {
            return input;
        }
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (!this.canAccept(input)) {
            return input;
        }
        return this.inv.calculateItemAddition(input);
    }

    @Override
    public long getAvailableSpaceByItem(IAEItemStack i, long maxNeeded) {
        if (this.flow == ItemFlow.READ) {
            return 0L;
        }
        if (this.canAccept(i)) {
            return this.inv.getAvailableSpaceByItem(i, maxNeeded);
        }
        return 0L;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int p) {
        this.priority = p;
    }

    @Override
    public long totalBytes() {
        return 0L;
    }

    @Override
    public long freeBytes() {
        return 0L;
    }

    @Override
    public long usedBytes() {
        return 0L;
    }

    @Override
    public long unusedItemCount() {
        return 0L;
    }

    @Override
    public boolean canHoldNewItem() {
        if (this.flow == ItemFlow.READ) {
            return false;
        }
        return this.remainingItemTypes() > 0L;
    }

    @Override
    public void setUpdateTarget(TileEntity e) {
        if (this.src == null) {
            this.src = new ArrayList<TileRef<TileEntity>>();
        }
        this.src.add(new TileRef(e));
    }

    @Override
    public List<ItemStack> getPreformattedItems() {
        return ((ItemList)this.filter).getSharedItems();
    }

    @Override
    public void setPreformattedItems(IItemList in, FuzzyMode fzmode, ListMode m) {
        this.lmode = m;
        this.fmode = fzmode;
        this.filter = in;
    }

    @Override
    public boolean isPreformatted() {
        return this.filter != null;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getName() {
        return "unnamed";
    }

    @Override
    public void setGrid(IGridInterface grid) {
        this.g = grid;
    }

    @Override
    public IGridInterface getGrid() {
        return this.g;
    }

    @Override
    public void removeGrid(IGridInterface grid, IMEInventoryHandler ignore, List<IMEInventoryHandler> duplicates) {
    }

    @Override
    public void validate(List<IMEInventoryHandler> duplicates) {
    }

    @Override
    public void setCellIndex(int x) {
        this.myCellIndex = x;
    }

    @Override
    public boolean isFuzzyPreformatted() {
        return this.fuzzyFilter;
    }

    @Override
    public void setFuzzyPreformatted(boolean nf) {
        this.fuzzyFilter = nf;
    }

    @Override
    public IItemList getAvailableItems() {
        return this.getAvailableItems(new ItemList());
    }

    @Override
    public ItemFlow getFlow() {
        return this.flow;
    }

    @Override
    public void setFlow(ItemFlow p) {
        this.flow = p;
    }

    @Override
    public FuzzyMode getFuzzyModePreformatted() {
        return this.fmode;
    }

    @Override
    public ListMode getListMode() {
        return this.lmode;
    }
}

