/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.block;

import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.common.AppEng;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngSubBlock;
import appeng.gui.AppEngGuiHandler;
import appeng.interfaces.IDismantleable;
import appeng.me.tile.TileInterfaceBase;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class BlockInterface
extends AppEngSubBlock
implements IDismantleable {
    public BlockInterface(AppEngMultiBlock mb) {
        super(mb, true);
        this.unlocalizedName = "Interface";
    }

    @Override
    public boolean isOpaqueCube() {
        return true;
    }

    @Override
    public boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer p, int side) {
        TileEntity tileEntity = w.func_72796_p(x, y, z);
        ItemStack eq = p.func_71045_bC();
        if (Platform.isWrench(p, eq, x, y, z) && tileEntity instanceof TileInterfaceBase) {
            TileInterfaceBase ate = (TileInterfaceBase)tileEntity;
            ate.cycleOrientation();
            ate.markForUpdate();
            ate.notifyNeightbors();
            MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(ate, w, new WorldCoord(x, y, z)));
            return true;
        }
        if (tileEntity == null || p.func_70093_af()) {
            return false;
        }
        Platform.openGui(p, AppEngGuiHandler.GUI_INTERFACE, w, x, y, z);
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World w) {
        return AppEng.getInstance().registration.createInterfaceTile();
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public Icon getBlockTextureFromSide(int side) {
        return AppEngTextureRegistry.Blocks.BlockInterface.get();
    }
}

