/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.block;

import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.common.AppEng;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.gui.AppEngGuiHandler;
import appeng.me.block.BlockCableBase;
import appeng.me.tile.TileLevelEmitter;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class BlockLevelEmitter
extends BlockCableBase {
    public BlockLevelEmitter(AppEngMultiBlock mb, boolean en) {
        super(mb, en);
        this.unlocalizedName = "LevelEmitter";
    }

    @Override
    public Icon getBlockTextureFromSide(int side) {
        return AppEngTextureRegistry.Blocks.MECableClear.get();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World w, int x, int y, int z, Random rand) {
        TileEntity te = w.func_72796_p(x, y, z);
        if (te instanceof TileLevelEmitter && ((TileLevelEmitter)te).isLevelEmitterOn()) {
            TileLevelEmitter le = (TileLevelEmitter)te;
            ForgeDirection d = ((TileLevelEmitter)te).getCurrentOrientation();
            double d0 = (double)((float)d.offsetX * 0.45f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)d.offsetY * 0.45f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)d.offsetZ * 0.45f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            w.func_72869_a("reddust", 0.5 + (double)x + d0, 0.5 + (double)y + d1, 0.5 + (double)z + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer p, int side) {
        TileEntity te;
        if (super.onBlockActivated(w, x, y, z, p, side)) {
            return true;
        }
        TileEntity tileEntity = w.func_72796_p(x, y, z);
        ItemStack eq = p.func_71045_bC();
        if (Platform.isWrench(p, eq, x, y, z) && (te = w.func_72796_p(x, y, z)) instanceof TileLevelEmitter) {
            TileLevelEmitter ate = (TileLevelEmitter)te;
            ate.cycleOrientation();
            ate.markForUpdate();
            ate.notifyNeightbors();
            MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(ate, w, new WorldCoord(x, y, z)));
            if (AppEng.getInstance().BCProxy != null) {
                AppEng.getInstance().BCProxy.wrenchUsed(eq.func_77973_b(), p, x, y, z);
            }
            return true;
        }
        if (tileEntity == null || p.func_70093_af()) {
            return false;
        }
        Platform.openGui(p, AppEngGuiHandler.GUI_LEVELEMITTER, w, x, y, z);
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World w) {
        return new TileLevelEmitter();
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }
}

