/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.block;

import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.common.AppEng;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.me.block.BlockCableBase;
import appeng.me.tile.TileP2PTunnel;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class BlockP2PTunnel
extends BlockCableBase {
    public BlockP2PTunnel(AppEngMultiBlock mb, boolean en) {
        super(mb, en);
        this.unlocalizedName = "P2PTunnel";
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public Icon getBlockTextureFromSide(int side) {
        return AppEngTextureRegistry.Blocks.MECableClear.get();
    }

    @Override
    public boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer p, int side) {
        if (super.onBlockActivated(w, x, y, z, p, side)) {
            return true;
        }
        TileEntity tileEntity = w.func_72796_p(x, y, z);
        if (tileEntity == null || p.func_70093_af()) {
            return false;
        }
        if (tileEntity instanceof TileP2PTunnel) {
            TileP2PTunnel ate = (TileP2PTunnel)tileEntity;
            ItemStack eq = p.func_71045_bC();
            if (Platform.isWrench(p, eq, x, y, z)) {
                ate.cycleOrientation();
                ate.markForUpdate();
                ate.notifyNeightbors();
                MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(ate, w, new WorldCoord(x, y, z)));
                if (AppEng.getInstance().BCProxy != null) {
                    AppEng.getInstance().BCProxy.wrenchUsed(eq.func_77973_b(), p, x, y, z);
                }
                return true;
            }
            if (ate.attune(eq)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public TileEntity createNewTileEntity(World w) {
        return new TileP2PTunnel();
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }
}

