/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.TileRef;
import appeng.api.WorldCoord;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.util.IGridCache;
import appeng.api.me.util.IGridInterface;
import appeng.common.AppEngConfiguration;
import appeng.me.cluster.implementations.SpatialPylonCluster;
import appeng.me.tile.TileSpatialIOPort;
import appeng.me.tile.TileSpatialPylon;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class SpatialPylonCache
implements IGridCache {
    public static int index;
    WorldCoord captureMin;
    WorldCoord captureMax;
    boolean isValid = false;
    List<TileRef<TileSpatialIOPort>> ioPorts = new LinkedList<TileRef<TileSpatialIOPort>>();
    HashMap<SpatialPylonCluster, SpatialPylonCluster> clusters = new HashMap();

    public boolean hasRegion() {
        return this.captureMin != null;
    }

    public boolean isValidRegion() {
        return this.hasRegion() && this.isValid;
    }

    public WorldCoord getMin() {
        return this.captureMin;
    }

    public WorldCoord getMax() {
        return this.captureMax;
    }

    @Override
    public void reset(IGridInterface grid) {
        int reqX = 0;
        int reqY = 0;
        int reqZ = 0;
        int requirePylongBlocks = 1;
        double effiency = 0.0;
        double minPower = 0.0;
        double maxPower = 0.0;
        this.clusters = new HashMap();
        this.ioPorts = new LinkedList<TileRef<TileSpatialIOPort>>();
        for (TileRef<IGridMachine> g : grid.getMachines()) {
            try {
                SpatialPylonCluster c;
                IGridMachine gm = g.getTile();
                if (gm instanceof TileSpatialIOPort) {
                    this.ioPorts.add(new TileRef((TileSpatialIOPort)gm));
                    continue;
                }
                if (!(gm instanceof TileSpatialPylon) || (c = (SpatialPylonCluster)((TileSpatialPylon)gm).getCluster()) == null) continue;
                this.clusters.put(c, c);
            }
            catch (AppEngTileMissingException e) {}
        }
        this.captureMax = null;
        this.captureMin = null;
        this.isValid = true;
        int pylonBlocks = 0;
        for (SpatialPylonCluster cl : this.clusters.values()) {
            if (this.captureMax == null) {
                this.captureMax = cl.max.copy();
            }
            if (this.captureMin == null) {
                this.captureMin = cl.min.copy();
            }
            pylonBlocks += cl.tileCount();
            this.captureMin.x = Math.min(this.captureMin.x, cl.min.x);
            this.captureMin.y = Math.min(this.captureMin.y, cl.min.y);
            this.captureMin.z = Math.min(this.captureMin.z, cl.min.z);
            this.captureMax.x = Math.max(this.captureMax.x, cl.max.x);
            this.captureMax.y = Math.max(this.captureMax.y, cl.max.y);
            this.captureMax.z = Math.max(this.captureMax.z, cl.max.z);
        }
        if (this.hasRegion()) {
            this.isValid = this.captureMax.x - this.captureMin.x > 1 && this.captureMax.y - this.captureMin.y > 1 && this.captureMax.z - this.captureMin.z > 1;
            for (SpatialPylonCluster cl : this.clusters.values()) {
                switch (cl.currentAxis) {
                    case X: {
                        this.isValid = !(!this.isValid || this.captureMax.y != cl.min.y && this.captureMin.y != cl.max.y && this.captureMax.z != cl.min.z && this.captureMin.z != cl.max.z || this.captureMax.y != cl.max.y && this.captureMin.y != cl.min.y && this.captureMax.z != cl.max.z && this.captureMin.z != cl.min.z);
                        break;
                    }
                    case Y: {
                        this.isValid = !(!this.isValid || this.captureMax.x != cl.min.x && this.captureMin.x != cl.max.x && this.captureMax.z != cl.min.z && this.captureMin.z != cl.max.z || this.captureMax.x != cl.max.x && this.captureMin.x != cl.min.x && this.captureMax.z != cl.max.z && this.captureMin.z != cl.min.z);
                        break;
                    }
                    case Z: {
                        this.isValid = !(!this.isValid || this.captureMax.y != cl.min.y && this.captureMin.y != cl.max.y && this.captureMax.x != cl.min.x && this.captureMin.x != cl.max.x || this.captureMax.y != cl.max.y && this.captureMin.y != cl.min.y && this.captureMax.x != cl.max.x && this.captureMin.x != cl.min.x);
                        break;
                    }
                    case UNFORMED: {
                        this.isValid = false;
                    }
                }
            }
            reqX = this.captureMax.x - this.captureMin.x;
            reqZ = this.captureMax.z - this.captureMin.z;
            reqY = this.captureMax.y - this.captureMin.y;
            requirePylongBlocks = (reqX * reqZ + reqX * reqY + reqY * reqZ) * 3 / 5;
            effiency = (double)pylonBlocks / (double)requirePylongBlocks;
            if (effiency > 1.0) {
                effiency = 1.0;
            }
            if (effiency < 0.0) {
                effiency = 0.0;
            }
            minPower = (double)reqX * (double)reqY * (double)reqZ * AppEngConfiguration.spatialPowerMultiplier;
            maxPower = Math.pow(minPower, AppEngConfiguration.spatialPowerScaler);
        }
        double affective_effiency = Math.pow(effiency, 0.25);
        long powerRequired = (long)(affective_effiency * minPower + (1.0 - affective_effiency) * maxPower);
        for (TileRef<TileSpatialIOPort> te : this.ioPorts) {
            try {
                te.getTile().effiency = effiency;
                te.getTile().powerRequired = powerRequired;
            }
            catch (AppEngTileMissingException e) {}
        }
        for (SpatialPylonCluster cl : this.clusters.values()) {
            cl.setNetworkStatus(this.isValid);
        }
    }

    @Override
    public void onUpdateTick(IGridInterface grid) {
    }

    @Override
    public String getCacheName() {
        return "SpatialPylonCache";
    }

    @Override
    public NBTTagCompound savetoNBTData() {
        return null;
    }

    @Override
    public void loadfromNBTData(NBTTagCompound data) {
    }
}

