/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.container;

import appeng.common.AppEng;
import appeng.gui.AppEngContainer;
import appeng.interfaces.IMENetworkContainer;
import appeng.me.NetworkedIMEI;
import appeng.me.tile.TileChest;
import appeng.slot.SlotME;
import appeng.slot.SlotPlayerHotBar;
import appeng.slot.SlotPlayerInv;
import appeng.slot.SlotRestrictedInput;
import appeng.util.Platform;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.IOException;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class ContainerChest
extends AppEngContainer
implements IMENetworkContainer {
    public NetworkedIMEI imeiinv;
    protected TileChest tileEntity;

    public ContainerChest(InventoryPlayer inventoryPlayer, TileChest te) {
        super(inventoryPlayer.field_70458_d, te);
        this.tileEntity = te;
        this.imeiinv = new NetworkedIMEI();
        this.imeiinv.targetPlayer = (Player)inventoryPlayer.field_70458_d;
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlaceableItemType.STORAGE_CELLS, this.tileEntity.cellinv, 0, 152, 8));
        if (Platform.isServer()) {
            this.imeiinv.realInv = te;
            this.imeiinv.update();
        }
        int off = 0;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotME(this.imeiinv, off++, 8 + j * 18, i * 18 + 8 + 18));
            }
        }
        this.bindPlayerInventory(inventoryPlayer);
        if (Platform.isClient()) {
            try {
                PacketDispatcher.sendPacketToServer((Packet)this.imeiinv.getRequestPacket());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.tileEntity.provideCell() != null;
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotPlayerInv((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 166 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new SlotPlayerHotBar((IInventory)inventoryPlayer, i, 8 + i * 18, 224));
        }
    }

    @Override
    public NetworkedIMEI GetNetworkIME() {
        return this.imeiinv;
    }

    @Override
    public void updateClient() {
        if (this.tileEntity.invChanges.size() == 0) {
            AppEng.log("Ful update triggered?");
        }
        try {
            this.imeiinv.postChanges(this.tileEntity.invChanges);
            for (Packet250CustomPayload cp : this.imeiinv.getDataPacket()) {
                PacketDispatcher.sendPacketToPlayer((Packet)cp, (Player)((Player)this.getPlayer()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update() {
    }
}

