/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.crafting;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.me.util.ICraftRequest;
import appeng.api.me.util.ICraftingPattern;
import appeng.api.me.util.ICraftingPatternMAC;
import appeng.api.me.util.IMEInventory;
import appeng.api.me.util.ITileCraftingProvider;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.me.MEInventoryUtil;
import appeng.me.crafting.Crafting;
import appeng.me.crafting.CraftingJobPacket;
import appeng.me.crafting.DelayedCraftRequest;
import appeng.me.crafting.ExternalCraftRequest;
import appeng.me.crafting.MultiPushCraftRequest;
import appeng.me.crafting.MultiPushTask;
import appeng.me.tile.TileController;
import appeng.util.AEItemStack;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.minecraft.item.ItemStack;

public class CraftRequest
implements ICraftRequest {
    protected String NetworkID;
    private int craftingAttempts;
    private int retryDelay;
    private int lastAttempt;
    private int prereqsrequested;
    private int lastRequest;
    private boolean reqPre = true;
    protected IAEItemStack req;
    private List<ItemStack> missing;
    public boolean allowPrereqs;
    protected CraftRequest parent;
    protected List<CraftRequest> Prereqs;

    public List<CraftRequest> getPrereqs() {
        return this.Prereqs;
    }

    public CraftRequest getParent() {
        return this.parent;
    }

    public int getAmount() {
        if (this.req == null) {
            return 0;
        }
        return (int)this.req.getStackSize();
    }

    public void clearMissing() {
        this.missing.clear();
    }

    public void addMissing(ItemStack m) {
        InventoryAdaptor.getAdaptor(this.missing, null).addItems(m);
    }

    public List<ItemStack> getMissing() {
        return this.missing;
    }

    public IAEItemStack getAERequest() {
        return this.req.copy();
    }

    public ItemStack getRequest() {
        if (this.req == null) {
            return null;
        }
        ItemStack r = Platform.getSharedItemStack(this.req);
        return r;
    }

    public boolean canTry() {
        if (this.Prereqs.size() > 0) {
            return false;
        }
        return this.lastAttempt++ >= this.retryDelay;
    }

    public void incrementCounter() {
        ++this.lastAttempt;
    }

    public void markAttempt() {
        ++this.craftingAttempts;
        this.lastAttempt = 0;
    }

    public boolean canRequestPrereqs() {
        return this.reqPre && this.Prereqs.size() == 0;
    }

    public CraftRequest(String network, ItemStack is) {
        this.req = AEItemStack.create(is);
        this.NetworkID = network;
        this.allowPrereqs = true;
        this.craftingAttempts = 0;
        this.lastAttempt = this.retryDelay = this.craftingAttempts > 10 ? this.retryDelay * 20 * 4 : 0;
        this.missing = new ArrayList<ItemStack>();
        this.Prereqs = new ArrayList<CraftRequest>();
    }

    public void markCrafted() {
        this.req.decStackSize(1L);
        this.craftingAttempts = 0;
        if (this.req.getStackSize() <= 0L && this.parent != null) {
            if (AppEngConfiguration.allowLogging && AppEngConfiguration.logCrafting) {
                AppEng.log(this.NetworkID + ": " + this.requestType() + " " + Platform.getSharedItemStack(this.req).func_77977_a() + " is done!");
            }
            this.parent.completePreReq(this);
            this.parent = null;
            for (CraftRequest cr : this.Prereqs) {
                cr.parent = null;
                cr.markChainCrafted();
            }
        }
    }

    public String requestType() {
        return "CraftRequest";
    }

    protected void completePreReq(CraftRequest craftRequest) {
        this.OnCraftingChange();
        this.Prereqs.remove(craftRequest);
    }

    protected void OnCraftingChange() {
        if (this.parent != null) {
            this.parent.OnCraftingChange();
        }
    }

    public void requestedPreReqs(ICraftRequest iCraftRequest) {
        CraftRequest cr = (CraftRequest)iCraftRequest;
        this.Prereqs.add(cr);
        cr.parent = this;
        this.OnCraftingChange();
    }

    public int roundUp(int num, int divisor) {
        if (divisor <= 0) {
            return 0;
        }
        return (num + divisor - 1) / divisor;
    }

    public boolean Craft(TileController tc, ICraftingPattern patternp, IMEInventory invItemPool, IItemList all, Deque<CraftRequest> craftingQueue, Deque<CraftRequest> waitingQueue) {
        block6: {
            int count;
            block7: {
                List<Object> notAvailable;
                ICraftingPatternMAC pattern;
                block5: {
                    if (!(patternp instanceof ICraftingPatternMAC)) {
                        return false;
                    }
                    pattern = (ICraftingPatternMAC)patternp;
                    MEInventoryUtil itemPool = new MEInventoryUtil(invItemPool);
                    int Amt = this.getAmount();
                    notAvailable = new ArrayList();
                    List<ITileCraftingProvider> ti = pattern.getProviders();
                    if (ti == null) break block5;
                    int reqAmount = (int)this.req.getStackSize();
                    reqAmount = this.roundUp(reqAmount, pattern.getOutput().field_77994_a);
                    if (!this.canRequestPrereqs()) break block6;
                    if (AppEngConfiguration.allowLogging && AppEngConfiguration.logCrafting) {
                        AppEng.log(this.NetworkID + ": " + this.requestType() + " wants " + this.req.getStackSize() + " of " + Platform.getSharedItemStack(this.req).func_77977_a());
                    }
                    notAvailable = pattern.getRequirements();
                    ItemStack ireq = Platform.getSharedItemStack(this.req);
                    ireq.field_77994_a = reqAmount * pattern.getOutput().field_77994_a;
                    ExternalCraftRequest externalCraftRequest = new ExternalCraftRequest(this.NetworkID, ireq);
                    waitingQueue.add(externalCraftRequest);
                    this.requestedPreReqs(externalCraftRequest);
                    this.req.setStackSize(ireq.field_77994_a);
                    AppEng.craftingLog(this.NetworkID, ireq, " waiting for " + ireq.field_77994_a);
                    ItemStack fullJob = ireq.func_77946_l();
                    fullJob.field_77994_a = 0;
                    MultiPushTask[] Items2 = new MultiPushTask[notAvailable.size()];
                    for (int pw = 0; pw < notAvailable.size(); ++pw) {
                        ItemStack p = Platform.cloneItemStack((ItemStack)notAvailable.get(pw));
                        fullJob.field_77994_a += p.field_77994_a * reqAmount;
                        Items2[pw] = new MultiPushTask(p, reqAmount);
                    }
                    MultiPushCraftRequest pcr = new MultiPushCraftRequest(this.NetworkID, fullJob, Items2, ti, true);
                    craftingQueue.add(pcr);
                    this.requestedPreReqs(pcr);
                    break block6;
                }
                count = Crafting.craftItem(tc.field_70331_k, tc, pattern, invItemPool, all, null, notAvailable, null);
                if (count != 0) break block7;
                this.markAttempt();
                if (!this.canRequestPrereqs()) break block6;
                AppEng.craftingLog(this.NetworkID, this.req, " is missing some mats, adding pre-reqs.");
                for (ItemStack itemStack : notAvailable) {
                    this.requestedPreReqs(tc.craftingRequest(itemStack));
                }
                break block6;
            }
            tc.OnCraftingChange(null);
            AppEng.craftingLog(this.NetworkID, this.req, " crafted.");
            for (int j = 0; j < count; ++j) {
                this.markCrafted();
            }
        }
        return true;
    }

    public boolean requirePattern() {
        return true;
    }

    public void markChainCrafted() {
        if (this.parent != null) {
            this.parent.markChainCrafted();
            this.parent.Prereqs.remove(this);
        }
        if (this.req != null) {
            this.req.setStackSize(0L);
        }
        this.parent = null;
    }

    public void populateJobPacket(CraftingJobPacket cjp) {
        if (!Platform.isSameItemType(this.getRequest(), cjp.Target)) {
            Platform.sumItemToList(cjp.Dependencies, this.getRequest());
        }
        for (CraftRequest cr : this.Prereqs) {
            if (Platform.isSameItem(cr.getRequest(), this.getRequest()) && !(cr instanceof DelayedCraftRequest) && !(cr instanceof MultiPushCraftRequest)) continue;
            cr.populateJobPacket(cjp);
        }
    }

    public void completeChildren(TileController tc) {
        while (this.Prereqs.size() > 0) {
            CraftRequest cr = this.Prereqs.get(0);
            cr.completeChildren(tc);
            if (this.Prereqs.indexOf(cr) == -1) continue;
            this.Prereqs.remove(cr);
        }
        while (this.getAmount() > 0) {
            this.markCrafted();
        }
        tc.removeFromCraftingQueues(this);
    }

    public void cancel(ItemStack subjob, TileController tc) {
        if (Platform.isSameItem(this.getRequest(), subjob)) {
            this.completeChildren(tc);
        } else {
            while (this.Prereqs.size() > 0) {
                CraftRequest cr = this.Prereqs.get(0);
                cr.cancel(subjob, tc);
                this.Prereqs.remove(cr);
            }
        }
    }

    public void printJobDetails() {
        if (AppEngConfiguration.allowLogging && AppEngConfiguration.logCrafting) {
            AppEng.log(this.NetworkID + ": " + this.requestType() + " " + Platform.getSharedItemStack(this.req).func_77977_a() + " has " + this.req.getStackSize() + " remaining.");
        }
    }

    public void disablePreReqs() {
        this.reqPre = false;
    }

    public boolean isValid(TileController tileController) {
        return true;
    }
}

