/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile.P2PTunnel;

import appeng.common.AppEngConfiguration;
import appeng.me.METhrottle;
import appeng.me.tile.TileP2PTunnel;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileP2PBCPower
extends TileP2PTunnel
implements IPowerReceptor {
    METhrottle tr = new METhrottle(5, 5, 20);
    PowerHandler pp = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.MACHINE);

    public TileP2PBCPower() {
        this.pp.configure(1.0f, 320.0f, 800.0f, 640.0f);
    }

    @Override
    public boolean requiresTickingUpdates() {
        return true;
    }

    @Override
    public void updateTileEntity() {
        if (!this.output && this.tr.process() && this.isPowered()) {
            float totalRequiredPower = 0.0f;
            Collection<TileP2PTunnel> outs = this.getOutputs();
            for (TileP2PTunnel o : outs) {
                PowerHandler.PowerReceiver tp;
                IPowerReceptor target;
                if (!(o instanceof TileP2PBCPower) || (target = ((TileP2PBCPower)o).getPowerTarget()) == null || (tp = target.getPowerReceiver(this.orientation.getOpposite())) == null) continue;
                float howmuch = tp.powerRequest();
                if (howmuch > tp.getMaxEnergyReceived()) {
                    howmuch = tp.getMaxEnergyReceived();
                }
                if (!((double)howmuch > 0.01) || !(howmuch > tp.getMinEnergyReceived())) continue;
                totalRequiredPower += howmuch;
            }
            if ((double)totalRequiredPower < 0.1) {
                return;
            }
            this.tr.hasAccomplishedWork();
            float currentTotal = this.pp.getEnergyStored();
            if ((double)currentTotal < 0.01) {
                return;
            }
            for (TileP2PTunnel o : outs) {
                PowerHandler.PowerReceiver tp;
                IPowerReceptor target;
                if (!(o instanceof TileP2PBCPower) || (target = ((TileP2PBCPower)o).getPowerTarget()) == null || (tp = target.getPowerReceiver(this.orientation.getOpposite())) == null) continue;
                float howmuch = tp.powerRequest();
                if (howmuch > tp.getMaxEnergyReceived()) {
                    howmuch = tp.getMaxEnergyReceived();
                }
                if (!((double)howmuch > 0.01) || !(howmuch > tp.getMinEnergyReceived())) continue;
                float toPull = currentTotal * (howmuch / totalRequiredPower);
                float pulled = this.pp.useEnergy(0.0f, toPull, true);
                this.usePower(pulled * 5.0f * AppEngConfiguration.TunnelPowerLoss);
                tp.receiveEnergy(PowerHandler.Type.PIPE, pulled, o.orientation.getOpposite());
            }
        }
    }

    @Override
    public float getPowerDrainPerTick() {
        return 0.5f;
    }

    private IPowerReceptor getPowerTarget() {
        TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + this.orientation.offsetX, this.field_70330_m + this.orientation.offsetY, this.field_70327_n + this.orientation.offsetZ);
        if (te != null && te instanceof IPowerReceptor) {
            return (IPowerReceptor)te;
        }
        return null;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.pp.writeToNBT(tag);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.pp.readFromNBT(tag);
    }

    @Override
    public String getTunnelTip() {
        return "AppEng.GuiITooltip.P2PMJTunnel";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getTypeTexture() {
        return Block.field_72076_bV.func_71851_a(0);
    }

    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (side.equals((Object)this.orientation)) {
            return this.pp.getPowerReceiver();
        }
        return null;
    }

    public void doWork(PowerHandler workProvider) {
    }
}

