/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile.P2PTunnel;

import appeng.api.WorldCoord;
import appeng.me.tile.TileP2PTunnel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;

public class TileP2PRedstone
extends TileP2PTunnel {
    int power;

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int isProvidingStrongPower(int s) {
        WorldCoord wc = this.getLocation();
        wc = wc.add(this.orientation, 1);
        ForgeDirection opposite = this.orientation.getOpposite();
        if (this.field_70331_k.func_72804_r(wc.x, wc.y, wc.z) || this.field_70331_k.isBlockSolidOnSide(wc.x, wc.y, wc.z, opposite)) {
            if (opposite.ordinal() == s) {
                return this.output ? this.power : 0;
            }
            if (s == -1) {
                return this.output ? this.power : 0;
            }
        }
        return 0;
    }

    @Override
    public String getTunnelTip() {
        return "AppEng.GuiITooltip.P2PFRedstoneTunnel";
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int x, int y, int z, ForgeDirection side) {
        if (side == this.orientation) {
            return RedNetConnectionType.CableSingle;
        }
        return RedNetConnectionType.None;
    }

    @Override
    public int isProvidingWeakPower(int s) {
        if (this.orientation.getOpposite().ordinal() == s) {
            return this.output ? this.power : 0;
        }
        if (s == -1) {
            return this.output ? this.power : 0;
        }
        return 0;
    }

    @Override
    public void onChange() {
        this.sendToOutput(this.power);
    }

    @Override
    public void setPowerStatus(boolean _hasPower) {
        TileP2PTunnel in;
        super.setPowerStatus(_hasPower);
        if (this.output && (in = this.getInput()) instanceof TileP2PRedstone) {
            this.putInput(((TileP2PRedstone)in).power);
        }
    }

    @Override
    public void setNetworkReady(boolean isReady) {
        TileP2PTunnel in;
        super.setNetworkReady(isReady);
        if (this.output && (in = this.getInput()) instanceof TileP2PRedstone) {
            this.putInput(((TileP2PRedstone)in).power);
        }
    }

    @Override
    protected void putInput(Object o) {
        int newPower;
        if (this.output && this.isMachineActive() && this.power != (newPower = ((Integer)o).intValue())) {
            this.power = newPower;
            this.notifyNeightbors();
        }
    }

    @Override
    public void notifyNeightbors() {
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72898_h(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72898_h(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74768_a("power", this.power);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.power = tag.func_74762_e("power");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getTypeTexture() {
        return Block.field_94341_cq.func_71851_a(0);
    }

    @Override
    public float getPowerDrainPerTick() {
        return 0.5f;
    }

    @Override
    public void onNeighborBlockChange() {
        if (!this.output) {
            int x = this.field_70329_l + this.orientation.offsetX;
            int y = this.field_70330_m + this.orientation.offsetY;
            int z = this.field_70327_n + this.orientation.offsetZ;
            Block b = Block.field_71973_m[this.field_70331_k.func_72798_a(x, y, z)];
            if (b != null && !this.output) {
                int side = this.orientation.ordinal();
                this.power = b.func_71855_c((IBlockAccess)this.field_70331_k, x, y, z, side);
                this.power = Math.max(this.power, b.func_71865_a((IBlockAccess)this.field_70331_k, x, y, z, side));
                this.sendToOutput(this.power);
            } else {
                this.sendToOutput(0);
            }
        }
    }
}

