/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.config.IConfigEnum;
import appeng.api.config.InterfaceBlockingMode;
import appeng.api.config.InterfaceCraftingMode;
import appeng.api.events.GridPatternUpdateEvent;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.ICraftingTracker;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IOrientableTile;
import appeng.api.me.tiles.ITileInterfaceApi;
import appeng.api.me.tiles.ITilePushable;
import appeng.api.me.tiles.InterfaceCraftingPattern;
import appeng.api.me.util.IConfigManager;
import appeng.api.me.util.ICraftingPattern;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventory;
import appeng.api.me.util.ITileCraftingProvider;
import appeng.api.me.util.InterfaceCraftingResponse;
import appeng.common.AppEng;
import appeng.common.AppEngInternalInventory;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngTile;
import appeng.common.network.IAppEngNetworkTile;
import appeng.interfaces.IConfigEnabledTile;
import appeng.interfaces.InvOperation;
import appeng.me.MEIInventoryWrapper;
import appeng.me.basetiles.TileMEWInventory;
import appeng.me.crafting.CraftingManager;
import appeng.me.crafting.ICraftingManagerOwner;
import appeng.me.tile.IInternalInventory;
import appeng.me.tile.TileController;
import appeng.proxy.helpers.IFacadeProxy;
import appeng.proxy.helpers.IFacadeTile;
import appeng.util.AEItemStack;
import appeng.util.ConfigManager;
import appeng.util.InventoryAdaptor;
import appeng.util.ItemList;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileInterfaceBase
extends TileMEWInventory
implements IOrientableTile,
ITileCraftingProvider,
IConfigEnabledTile,
IFacadeTile,
ICraftingManagerOwner,
ITilePushable,
IInventory,
ITileInterfaceApi,
IAppEngNetworkTile,
IGridMachine,
IDirectionalMETile {
    public AppEngInternalInventory Crafting;
    public AppEngInternalInventory Exports;
    public boolean reqUpdate = true;
    private ConfigManager cm;
    InterfaceBlockingMode blockingMode = InterfaceBlockingMode.NonBlocking;
    InterfaceCraftingMode craftingMode = InterfaceCraftingMode.Craft;
    List<Object> PowerPipes;
    IFacadeProxy FP;
    public int loopsSinceUpdate = 0;
    private CraftingManager craftingManager;

    @Override
    public void InvChanged(IInternalInventory inv, int slot, InvOperation Operation) {
        super.InvChanged(inv, slot, Operation);
        if (this.Crafting == inv && this.getGrid() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GridPatternUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
        }
    }

    @Override
    public NBTTagCompound getSettings(AppEngTile.ConfigMode mode) {
        NBTTagCompound tag = new NBTTagCompound();
        this.cm.writeToNBT(tag);
        NBTTagCompound expConfig = new NBTTagCompound();
        this.Exports.writeToNBT(expConfig);
        tag.func_74766_a("Exports", expConfig);
        return tag;
    }

    @Override
    public void restoreSettings(NBTTagCompound tag, AppEngTile.ConfigMode mode) {
        try {
            this.cm.readFromNBT(tag);
            NBTTagCompound expConfig = tag.func_74775_l("Exports");
            if (expConfig != null) {
                this.Exports.readFromNBT(expConfig);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public IMEInventory getApiArray() {
        if (this.getGrid() == null || !this.hasPower) {
            return new MEIInventoryWrapper(this, null);
        }
        if (this.Exports.isEmpty()) {
            return this.getGrid().getCellArray();
        }
        return new MEIInventoryWrapper(this, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.FP.facadeRender(renderer, block, this, x, y, z, 0.0f);
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        float thickness = 0.0625f;
        if (this.FP.hasFacade(this, ForgeDirection.EAST)) {
            maxX -= thickness;
        }
        if (this.FP.hasFacade(this, ForgeDirection.WEST)) {
            minX += thickness;
        }
        if (this.FP.hasFacade(this, ForgeDirection.UP)) {
            maxY -= thickness;
        }
        if (this.FP.hasFacade(this, ForgeDirection.DOWN)) {
            minY += thickness;
        }
        if (this.FP.hasFacade(this, ForgeDirection.SOUTH)) {
            maxZ -= thickness;
        }
        if (this.FP.hasFacade(this, ForgeDirection.NORTH)) {
            minZ += thickness;
        }
        renderer.func_83020_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        if (this.orientation == ForgeDirection.UP) {
            renderer.field_78662_g = 3;
            renderer.field_78683_h = 3;
            renderer.field_78679_j = 3;
            renderer.field_78685_i = 3;
        }
        if (this.orientation == ForgeDirection.SOUTH) {
            renderer.field_78679_j = 2;
            renderer.field_78685_i = 1;
        }
        if (this.orientation == ForgeDirection.NORTH) {
            renderer.field_78681_k = 3;
            renderer.field_78675_l = 3;
            renderer.field_78679_j = 1;
            renderer.field_78685_i = 2;
        }
        if (this.orientation == ForgeDirection.EAST) {
            renderer.field_78681_k = 2;
            renderer.field_78675_l = 1;
            renderer.field_78662_g = 1;
            renderer.field_78683_h = 2;
        }
        if (this.orientation == ForgeDirection.WEST) {
            renderer.field_78681_k = 1;
            renderer.field_78675_l = 2;
            renderer.field_78662_g = 2;
            renderer.field_78683_h = 1;
        }
        boolean res = renderer.func_78570_q(block, x, y, z);
        renderer.field_78675_l = 0;
        renderer.field_78681_k = 0;
        renderer.field_78662_g = 0;
        renderer.field_78683_h = 0;
        renderer.field_78679_j = 0;
        renderer.field_78685_i = 0;
        return res;
    }

    @Override
    public boolean containsItems() {
        if (!this.hasPower) {
            return false;
        }
        if (this.getGrid() == null) {
            return false;
        }
        IMEInventory ime = this.getApiArray();
        if (ime == null) {
            return false;
        }
        return ime.getAvailableItems().size() > 0;
    }

    @Override
    public int apiCurrentAvailableSpace(ItemStack i, int MaxNeeded) {
        if (!this.hasPower) {
            return 0;
        }
        if (this.getGrid() == null) {
            return 0;
        }
        IMEInventory ime = this.getApiArray();
        if (ime == null) {
            return 0;
        }
        long room = ime.getAvailableSpaceByItem(AEItemStack.create(i), MaxNeeded);
        if (room >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)room;
    }

    @Override
    public ItemStack apiExtractNetworkItem(ItemStack i, boolean doExtract) {
        if (i == null) {
            return i;
        }
        if (!this.hasPower) {
            return null;
        }
        if (this.getGrid() == null) {
            return null;
        }
        IMEInventory ime = this.getApiArray();
        if (ime == null) {
            return null;
        }
        if (doExtract) {
            return Platform.extractItems(ime, i);
        }
        long howMany = ime.countOfItemType(AEItemStack.create(i));
        ItemStack result = i.func_77946_l();
        if (howMany > (long)i.field_77994_a) {
            return result;
        }
        result.field_77994_a = howMany > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)howMany;
        return result;
    }

    @Override
    public ItemStack apiAddNetworkItem(ItemStack i, boolean doAdd) {
        if (i == null) {
            return i;
        }
        if (!this.hasPower) {
            return i;
        }
        if (this.getGrid() == null) {
            return i;
        }
        IMEInventory ime = this.getApiArray();
        if (ime == null) {
            return i;
        }
        if (doAdd) {
            int howMany = this.getGrid().usePowerForAddition(i.field_77994_a, 1);
            if (howMany >= i.field_77994_a) {
                return Platform.refundEnergy(this.getGrid(), Platform.addItems(ime, i), "interface api");
            }
            i = i.func_77946_l();
            ItemStack myPart = i.func_77979_a(howMany);
            if ((myPart = Platform.addItems(ime, myPart)) != null) {
                i.field_77994_a += myPart.field_77994_a;
            }
            return i;
        }
        return Platform.calculateItemAddition(ime, i);
    }

    @Override
    public List<ItemStack> apiGetNetworkContents() {
        if (this.getGrid() == null) {
            return new ArrayList<ItemStack>();
        }
        if (!this.hasPower) {
            return new ArrayList<ItemStack>();
        }
        IMEInventory ime = this.getApiArray();
        if (ime == null) {
            return new ArrayList<ItemStack>();
        }
        List<ItemStack> out = ime.getAvailableItems(new ItemList()).getItems();
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (ItemStack s : out) {
            if (s.field_77994_a <= 0) continue;
            output.add(s.func_77946_l());
        }
        return output;
    }

    private boolean hasPipe(ForgeDirection dir) {
        WorldCoord entityPos = this.getLocation();
        entityPos.add(dir, 1);
        TileEntity te = this.field_70331_k.func_72796_p(entityPos.x, entityPos.y, entityPos.z);
        if (AppEng.getInstance().BCProxy != null) {
            return AppEng.getInstance().BCProxy.isPipe(te, dir);
        }
        return false;
    }

    public ItemStack pushToPipe(ForgeDirection dir, ItemStack is) {
        if (is == null) {
            return is;
        }
        WorldCoord entityPos = this.getLocation();
        entityPos.add(dir, 1);
        TileEntity te = this.field_70331_k.func_72796_p(entityPos.x, entityPos.y, entityPos.z);
        if (AppEng.getInstance().BCProxy != null && AppEng.getInstance().BCProxy.addItemsToPipe(te, is, dir.getOpposite())) {
            return null;
        }
        return is;
    }

    public ItemStack pushToInv(ForgeDirection dir, ItemStack is) {
        InventoryAdaptor ia;
        if (is == null) {
            return is;
        }
        WorldCoord wc = this.getLocation();
        wc.add(dir, 1);
        TileEntity te = this.field_70331_k.func_72796_p(wc.x, wc.y, wc.z);
        if (te instanceof ITileInterfaceApi && !this.orientation.equals((Object)ForgeDirection.UNKNOWN)) {
            ITileInterfaceApi api = (ITileInterfaceApi)te;
            return api.apiAddNetworkItem(is, true);
        }
        if (!(te == null || this.orientation.equals((Object)ForgeDirection.UNKNOWN) && te instanceof TileInterfaceBase || (ia = InventoryAdaptor.getAdaptor(te, dir.getOpposite())) == null)) {
            is = ia.addItems(is);
        }
        return is;
    }

    @Override
    public void setGrid(IGridInterface gi) {
        super.setGrid(gi);
        this.reqUpdate = true;
        this.notifyNeightbors();
        this.craftingManager = new CraftingManager(this.getGrid() == null ? "NULL" : this.getGrid().getName(), this);
    }

    @Override
    public boolean getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        AppEngInternalInventory inv = this.Crafting;
        for (int l = 0; l < inv.func_70302_i_(); ++l) {
            ItemStack is = inv.func_70301_a(l);
            if (is == null) continue;
            drops.add(is);
            inv.func_70299_a(l, null);
        }
        for (ItemStack is : this.FP.getDrops(this)) {
            drops.add(is);
        }
        return false;
    }

    @Override
    public ItemStack func_70298_a(int var1, int var2) {
        ItemStack o = super.func_70298_a(var1, var2);
        this.reqUpdate = true;
        return o;
    }

    @Override
    public void func_70299_a(int var1, ItemStack var2) {
        super.func_70299_a(var1, var2);
        this.reqUpdate = true;
    }

    void requestCrafting(ItemStack i) {
        IGridInterface gi = this.getGrid();
        if (gi != null) {
            if (this.craftingManager.isCrafting(i)) {
                return;
            }
            TileController tc = (TileController)gi.getController();
            this.craftingManager.requestedPreReqs(tc.craftingRequest(i, true, true));
        }
    }

    @Override
    public void updateTileEntity() {
        if (this.loopsSinceUpdate++ > 32 && !this.reqUpdate) {
            for (int x = 0; x < this.Exports.func_70302_i_(); ++x) {
                ItemStack r = this.Exports.func_70301_a(x);
                ItemStack m = this.func_70301_a(x);
                if (r == null && m == null) continue;
                if (r == null || m == null) {
                    this.reqUpdate = true;
                    break;
                }
                if (Platform.isSameItem(r, m)) {
                    if (r.field_77994_a == m.field_77994_a) continue;
                    this.reqUpdate = true;
                    break;
                }
                this.reqUpdate = true;
                break;
            }
        }
        if (this.reqUpdate) {
            IGridInterface gi = this.getGrid();
            if (this.reqUpdate && gi != null) {
                gi.requestUpdate(this);
            } else {
                this.loopsSinceUpdate = 0;
            }
        }
    }

    public TileInterfaceBase() {
        super(8);
        this.Crafting = new AppEngInternalInventory(this, 9);
        this.Exports = new AppEngInternalInventory(this, 8);
        this.craftingManager = new CraftingManager(this.getGrid() == null ? "NULL" : this.getGrid().getName(), this);
        this.orientation = ForgeDirection.UNKNOWN;
        this.PowerPipes = new ArrayList<Object>();
        this.updatesOnPower = false;
        this.cm = new ConfigManager(this);
        this.cm.RegisterSetting(this.craftingMode);
        this.cm.RegisterSetting(this.blockingMode);
        this.FP = AppEng.getInstance().BCProxy != null ? AppEng.getInstance().BCProxy.createFacadeProxy() : AppEng.getInstance().nFacadeProxy;
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74757_a("r1", true);
        NBTTagCompound c = new NBTTagCompound();
        NBTTagCompound e = new NBTTagCompound();
        NBTTagCompound m = new NBTTagCompound();
        this.Crafting.writeToNBT(c);
        this.Exports.writeToNBT(e);
        par1nbtTagCompound.func_74766_a("cr", c);
        par1nbtTagCompound.func_74766_a("ex", e);
        par1nbtTagCompound.func_74766_a("mr", m);
        this.cm.writeToNBT(par1nbtTagCompound);
        this.FP.writeToNBT(par1nbtTagCompound);
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return st == IAppEngNetworkTile.SyncTime.WORLD;
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        if (!par1nbtTagCompound.func_74764_b("r1")) {
            this.orientation = ForgeDirection.UNKNOWN;
        }
        this.Crafting.readFromNBT(par1nbtTagCompound.func_74775_l("cr"));
        this.Exports.readFromNBT(par1nbtTagCompound.func_74775_l("ex"));
        this.cm.readFromNBT(par1nbtTagCompound);
        this.FP.readFromNBT(par1nbtTagCompound);
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        if (this.orientation.equals((Object)ForgeDirection.UNKNOWN)) {
            return AppEngTextureRegistry.Blocks.BlockInterface.get();
        }
        if (side.getOpposite().equals((Object)this.orientation)) {
            return AppEngTextureRegistry.Blocks.BlockInterfaceAlternate.get();
        }
        if (!side.equals((Object)this.orientation)) {
            return AppEngTextureRegistry.Blocks.BlockInterfaceAlternateArrow.get();
        }
        return AppEngTextureRegistry.Blocks.BlockInterface.get();
    }

    public String func_70303_b() {
        return "ME Interface";
    }

    @Override
    public float getPowerDrainPerTick() {
        return 1.0f;
    }

    public void addRequestPipe(List<IMEInventory> invs, ForgeDirection up) {
        IMEInventory mei;
        if (AppEng.getInstance().LPProxy == null) {
            return;
        }
        WorldCoord wc = this.getLocation();
        wc.add(up, 1);
        TileEntity te = this.field_70331_k.func_72796_p(wc.x, wc.y, wc.z);
        if (AppEng.getInstance().LPProxy.isRequestPipe(te) && (mei = AppEng.getInstance().LPProxy.getInv(te)) != null) {
            invs.add(mei);
        }
    }

    public List<IMEInventory> getLogisticsInv() {
        ArrayList<IMEInventory> o = new ArrayList<IMEInventory>();
        this.addRequestPipe(o, ForgeDirection.UP);
        this.addRequestPipe(o, ForgeDirection.DOWN);
        this.addRequestPipe(o, ForgeDirection.EAST);
        this.addRequestPipe(o, ForgeDirection.WEST);
        this.addRequestPipe(o, ForgeDirection.NORTH);
        this.addRequestPipe(o, ForgeDirection.SOUTH);
        return o;
    }

    public void addPowerPipe(List<Object> X, ForgeDirection up) {
    }

    public List<Object> getLogisticsPowerSources() {
        return this.PowerPipes;
    }

    boolean canPushItemToInv(ForgeDirection dir, ItemStack is) {
        InventoryAdaptor ia;
        WorldCoord wc = this.getLocation();
        wc = wc.add(dir, 1);
        TileEntity te = this.field_70331_k.func_72796_p(wc.x, wc.y, wc.z);
        if (te instanceof ITileInterfaceApi && !this.orientation.equals((Object)ForgeDirection.UNKNOWN)) {
            ITileInterfaceApi api = (ITileInterfaceApi)te;
            ItemStack out = api.apiAddNetworkItem(is, false);
            if (out == null) {
                return true;
            }
            return out.field_77994_a != is.field_77994_a;
        }
        if (!(te == null || this.orientation.equals((Object)ForgeDirection.UNKNOWN) && te instanceof TileInterfaceBase || (ia = InventoryAdaptor.getAdaptor(te, dir.getOpposite())) == null)) {
            ItemStack out = ia.simulateAdd(is);
            if (out == null) {
                return true;
            }
            return out.field_77994_a != is.field_77994_a;
        }
        return false;
    }

    boolean shouldPushInto(ForgeDirection dir) {
        InventoryAdaptor ia;
        WorldCoord wc = this.getLocation();
        wc = wc.add(dir, 1);
        TileEntity te = this.field_70331_k.func_72796_p(wc.x, wc.y, wc.z);
        if (te instanceof ITileInterfaceApi && !this.orientation.equals((Object)ForgeDirection.UNKNOWN)) {
            ITileInterfaceApi api = (ITileInterfaceApi)te;
            return this.blockingMode != InterfaceBlockingMode.Blocking || !api.containsItems();
        }
        if (!(te == null || this.orientation.equals((Object)ForgeDirection.UNKNOWN) && te instanceof TileInterfaceBase || (ia = InventoryAdaptor.getAdaptor(te, dir.getOpposite())) == null)) {
            return this.blockingMode != InterfaceBlockingMode.Blocking || !ia.containsItems();
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        if (this.orientation != ForgeDirection.UNKNOWN) {
            if (this.hasPipe(this.orientation)) {
                return false;
            }
            if (this.shouldPushInto(this.orientation)) {
                return false;
            }
        } else {
            if (this.hasPipe(ForgeDirection.NORTH)) {
                return false;
            }
            if (this.hasPipe(ForgeDirection.SOUTH)) {
                return false;
            }
            if (this.hasPipe(ForgeDirection.EAST)) {
                return false;
            }
            if (this.hasPipe(ForgeDirection.WEST)) {
                return false;
            }
            if (this.hasPipe(ForgeDirection.UP)) {
                return false;
            }
            if (this.hasPipe(ForgeDirection.DOWN)) {
                return false;
            }
            if (this.shouldPushInto(ForgeDirection.NORTH)) {
                return false;
            }
            if (this.shouldPushInto(ForgeDirection.SOUTH)) {
                return false;
            }
            if (this.shouldPushInto(ForgeDirection.EAST)) {
                return false;
            }
            if (this.shouldPushInto(ForgeDirection.WEST)) {
                return false;
            }
            if (this.shouldPushInto(ForgeDirection.UP)) {
                return false;
            }
            if (this.shouldPushInto(ForgeDirection.DOWN)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canPushItem(ItemStack out) {
        if (this.orientation != ForgeDirection.UNKNOWN) {
            if (this.hasPipe(this.orientation)) {
                return true;
            }
            if (this.canPushItemToInv(this.orientation, out)) {
                return true;
            }
        } else {
            if (this.hasPipe(ForgeDirection.NORTH)) {
                return true;
            }
            if (this.hasPipe(ForgeDirection.SOUTH)) {
                return true;
            }
            if (this.hasPipe(ForgeDirection.EAST)) {
                return true;
            }
            if (this.hasPipe(ForgeDirection.WEST)) {
                return true;
            }
            if (this.hasPipe(ForgeDirection.UP)) {
                return true;
            }
            if (this.hasPipe(ForgeDirection.DOWN)) {
                return true;
            }
            if (this.canPushItemToInv(ForgeDirection.NORTH, out)) {
                return true;
            }
            if (this.canPushItemToInv(ForgeDirection.SOUTH, out)) {
                return true;
            }
            if (this.canPushItemToInv(ForgeDirection.EAST, out)) {
                return true;
            }
            if (this.canPushItemToInv(ForgeDirection.WEST, out)) {
                return true;
            }
            if (this.canPushItemToInv(ForgeDirection.UP, out)) {
                return true;
            }
            if (this.canPushItemToInv(ForgeDirection.DOWN, out)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack pushItem(ItemStack is) {
        if (this.orientation != ForgeDirection.UNKNOWN) {
            is = this.pushToPipe(this.orientation, is);
            is = this.pushToInv(this.orientation, is);
        } else {
            is = this.pushToPipe(ForgeDirection.NORTH, is);
            is = this.pushToPipe(ForgeDirection.SOUTH, is);
            is = this.pushToPipe(ForgeDirection.EAST, is);
            is = this.pushToPipe(ForgeDirection.WEST, is);
            is = this.pushToPipe(ForgeDirection.UP, is);
            is = this.pushToPipe(ForgeDirection.DOWN, is);
            is = this.pushToInv(ForgeDirection.NORTH, is);
            is = this.pushToInv(ForgeDirection.SOUTH, is);
            is = this.pushToInv(ForgeDirection.EAST, is);
            is = this.pushToInv(ForgeDirection.WEST, is);
            is = this.pushToInv(ForgeDirection.UP, is);
            is = this.pushToInv(ForgeDirection.DOWN, is);
        }
        return is;
    }

    @Override
    public void OnCraftingChange(CraftingManager cm) {
    }

    @Override
    public void jobDone(CraftingManager cm) {
        if (cm == this.craftingManager && this.getGrid() != null) {
            this.reqUpdate = true;
        }
    }

    @Override
    public List<ItemStack> getCraftingOptions() {
        if (this.getGrid() == null) {
            return new ArrayList<ItemStack>();
        }
        return this.getGrid().getCraftableArray().getAvailableItems(new ItemList()).getItems();
    }

    @Override
    public InterfaceCraftingResponse requestCrafting(ItemStack req, boolean enableRecursion) {
        IGridInterface gi = this.getGrid();
        if (gi == null) {
            return null;
        }
        InterfaceCraftingResponse icr = new InterfaceCraftingResponse();
        icr.Request = Platform.cloneItemStack(req);
        ICraftingPattern pattern = gi.getPatternFor(req);
        if (pattern == null) {
            return null;
        }
        try {
            gi.craftingRequest(req, true, enableRecursion);
        }
        catch (AppEngTileMissingException e) {
            return null;
        }
        return icr;
    }

    @Override
    public List<InterfaceCraftingPattern> findCraftingPatterns(ItemStack req) {
        InterfaceCraftingPattern icr = new InterfaceCraftingPattern();
        IGridInterface gi = this.getGrid();
        if (gi == null) {
            return null;
        }
        ICraftingPattern pattern = gi.getPatternFor(req);
        if (pattern == null) {
            return null;
        }
        icr.Output = pattern.getOutput();
        icr.Inputs = pattern.getRequirements();
        ArrayList<InterfaceCraftingPattern> o = new ArrayList<InterfaceCraftingPattern>();
        o.add(icr);
        return o;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public void cycleOrientation() {
        switch (this.orientation) {
            case UP: {
                this.orientation = ForgeDirection.DOWN;
                break;
            }
            case DOWN: {
                this.orientation = ForgeDirection.NORTH;
                break;
            }
            case NORTH: {
                this.orientation = ForgeDirection.SOUTH;
                break;
            }
            case SOUTH: {
                this.orientation = ForgeDirection.EAST;
                break;
            }
            case EAST: {
                this.orientation = ForgeDirection.WEST;
                break;
            }
            case WEST: {
                this.orientation = ForgeDirection.UNKNOWN;
                break;
            }
            case UNKNOWN: {
                this.orientation = ForgeDirection.UP;
            }
        }
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        this.FP.writeToStream(data);
        data.writeByte(this.getAERotationFromDirection(this.orientation));
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        boolean facadesChanged = this.FP.readFromStream(stream);
        ForgeDirection oldOrientation = this.orientation;
        this.orientation = this.getDirectionFromAERotation(stream.readByte());
        return this.orientation != oldOrientation || facadesChanged;
    }

    @Override
    public boolean isConnected(ForgeDirection direction) {
        return false;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.PowerPipes = new ArrayList<Object>();
        this.addPowerPipe(this.PowerPipes, ForgeDirection.UP);
        this.addPowerPipe(this.PowerPipes, ForgeDirection.DOWN);
        this.addPowerPipe(this.PowerPipes, ForgeDirection.EAST);
        this.addPowerPipe(this.PowerPipes, ForgeDirection.WEST);
        this.addPowerPipe(this.PowerPipes, ForgeDirection.NORTH);
        this.addPowerPipe(this.PowerPipes, ForgeDirection.SOUTH);
    }

    @Override
    public IFacadeProxy getFacadeProxy() {
        return this.FP;
    }

    @Override
    public void dropFacadeItem(ItemStack facade) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(facade);
        Platform.spawnDrops(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, drops);
    }

    public int getPowerLevel() {
        TileController tc;
        if (this.getGrid() != null && (tc = (TileController)this.getGrid().getController()) != null) {
            return (int)Math.floor(tc.storedPower);
        }
        return 0;
    }

    public boolean useEnergy(int amount) {
        if (this.getGrid() != null) {
            return this.getGrid().useMEEnergy(amount, "LP");
        }
        return false;
    }

    public boolean canUseEnergy(int amount) {
        return this.getPowerLevel() > amount;
    }

    public boolean useEnergy(int amount, List<Object> providersToIgnore) {
        if (this.getGrid() != null) {
            TileEntity te = this.getGrid().getController();
            if (providersToIgnore == null) {
                providersToIgnore = new ArrayList<Object>();
            }
            return ((TileController)te).useMEEnergyRecursive(amount, providersToIgnore);
        }
        return false;
    }

    public boolean canUseEnergy(int amount, List<Object> providersToIgnore) {
        if (this.getGrid() != null) {
            TileEntity te = this.getGrid().getController();
            if (providersToIgnore == null) {
                providersToIgnore = new ArrayList<Object>();
            }
            return ((TileController)te).canUseEnergyRecursive(amount, providersToIgnore);
        }
        return false;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        if (this.orientation.equals((Object)ForgeDirection.UNKNOWN)) {
            return true;
        }
        return !this.orientation.equals((Object)dir);
    }

    @Override
    public float getHoleThickness(ForgeDirection direction) {
        return 0.0f;
    }

    @Override
    public void updateSetting(IConfigEnum newValue) {
        if (newValue instanceof InterfaceBlockingMode) {
            this.blockingMode = (InterfaceBlockingMode)newValue;
        } else if (newValue instanceof InterfaceCraftingMode) {
            this.craftingMode = (InterfaceCraftingMode)newValue;
            this.craftingManager = new CraftingManager(this.getGrid() == null ? "NULL" : this.getGrid().getName(), this);
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public void provideCrafting(ICraftingTracker tc) {
        for (int x = 0; x < this.Crafting.func_70302_i_(); ++x) {
            ItemStack s = this.Crafting.func_70301_a(x);
            if (s == null || !Util.isAssemblerPattern(s).booleanValue()) continue;
            tc.addCraftingOption(this, Util.getAssemblerPattern(s));
        }
    }

    @Override
    public ForgeDirection getPrimaryOrientation() {
        return this.orientation;
    }

    @Override
    public int getSpin() {
        return 0;
    }

    @Override
    public void setPrimaryOrientation(ForgeDirection s) {
        this.orientation = s;
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.getWorld(), this.getLocation()));
    }

    @Override
    public void setSpin(int spin) {
    }
}

