/*
 * Decompiled with CFR 0.152.
 */
package appeng.proxy;

import appeng.api.exceptions.AppEngException;
import appeng.me.tile.P2PTunnel.TileP2PBCPower;
import appeng.me.tile.P2PTunnel.TileP2PItems;
import appeng.me.tile.P2PTunnel.TileP2PLiquids;
import appeng.me.tile.TileP2PTunnel;
import appeng.proxy.IProxyBC;
import appeng.proxy.helpers.FacadeProxyBC;
import appeng.proxy.helpers.IFacadeProxy;
import appeng.util.Platform;
import buildcraft.BuildCraftEnergy;
import buildcraft.BuildCraftTransport;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.FacadeManager;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.TileGenericPipe;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class ProxyBC
implements IProxyBC {
    public ProxyBC() throws AppEngException {
        if (!Platform.isModLoaded("BuildCraft|Core")) {
            throw new AppEngException("Buildcraft is not available.");
        }
    }

    @Override
    public void addFacade(ItemStack item) {
        FacadeManager.addFacade((ItemStack)item);
    }

    @Override
    public IFacadeProxy createFacadeProxy() {
        return new FacadeProxyBC();
    }

    @Override
    public boolean isWrench(Item eq) {
        return eq instanceof IToolWrench;
    }

    @Override
    public boolean isPipe(TileEntity te, ForgeDirection dir) {
        if (te instanceof IPipeTile) {
            try {
                if (te instanceof TileGenericPipe && ((TileGenericPipe)te).hasPlug(dir.getOpposite())) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrench(Item i, EntityPlayer p, int x, int y, int z) {
        return ((IToolWrench)i).canWrench(p, x, y, z);
    }

    @Override
    public void wrenchUsed(Item i, EntityPlayer p, int x, int y, int z) {
        ((IToolWrench)i).wrenchUsed(p, x, y, z);
    }

    @Override
    public boolean addItemsToPipe(TileEntity te, ItemStack is, ForgeDirection dir) {
        int amt;
        IPipeTile pt;
        if (is != null && te != null && te instanceof IPipeTile && (pt = (IPipeTile)te).getPipeType() == IPipeTile.PipeType.ITEM && (amt = pt.injectItem(is, false, dir)) == is.field_77994_a) {
            pt.injectItem(is, true, dir);
            return true;
        }
        return false;
    }

    @Override
    public boolean isFacade(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() instanceof ItemFacade;
    }

    @Override
    public boolean canAddItemsToPipe(TileEntity te, ItemStack is, ForgeDirection dir) {
        int amt;
        IPipeTile pt;
        return is != null && te != null && te instanceof IPipeTile && (pt = (IPipeTile)te).getPipeType() == IPipeTile.PipeType.ITEM && (amt = pt.injectItem(is, false, dir)) == is.field_77994_a;
    }

    @Override
    public void registerPowerP2P() {
        TileP2PTunnel.addType(new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 0), TileP2PBCPower.class);
        TileP2PTunnel.addType(new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 1), TileP2PBCPower.class);
        TileP2PTunnel.addType(new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 2), TileP2PBCPower.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipePowerCobblestone), TileP2PBCPower.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipePowerDiamond), TileP2PBCPower.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipePowerGold), TileP2PBCPower.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipePowerQuartz), TileP2PBCPower.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipePowerStone), TileP2PBCPower.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipePowerWood), TileP2PBCPower.class);
    }

    @Override
    public void registerItemP2P() {
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeItemsWood), TileP2PItems.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeItemsVoid), TileP2PItems.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeItemsSandstone), TileP2PItems.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeItemsQuartz), TileP2PItems.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeItemsObsidian), TileP2PItems.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeItemsIron), TileP2PItems.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeItemsGold), TileP2PItems.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeItemsEmerald), TileP2PItems.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeItemsDiamond), TileP2PItems.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeItemsStone), TileP2PItems.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeItemsCobblestone), TileP2PItems.class);
    }

    @Override
    public void registerLiquidsP2P() {
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeFluidsCobblestone), TileP2PLiquids.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeFluidsEmerald), TileP2PLiquids.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeFluidsGold), TileP2PLiquids.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeFluidsIron), TileP2PLiquids.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeFluidsSandstone), TileP2PLiquids.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeFluidsStone), TileP2PLiquids.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeFluidsVoid), TileP2PLiquids.class);
        TileP2PTunnel.addType(new ItemStack(BuildCraftTransport.pipeFluidsWood), TileP2PLiquids.class);
    }
}

