/*
 * Decompiled with CFR 0.152.
 */
package appeng.proxy.helpers;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.me.util.IMEInventory;
import appeng.proxy.IProxyFactorization;
import appeng.util.AEItemStack;
import appeng.util.ItemList;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class FactorizationBarrel
implements IMEInventory {
    private final TileEntity te;
    private List<ItemStack> filterList;
    IProxyFactorization fProxy;

    public FactorizationBarrel(IProxyFactorization proxy, TileEntity tile) {
        this.te = tile;
        this.fProxy = proxy;
    }

    @Override
    public long storedItemTypes() {
        return this.fProxy.barrelGetItem(this.te) == null ? 0L : 1L;
    }

    @Override
    public long storedItemCount() {
        return this.fProxy.barrelGetItemCount(this.te);
    }

    @Override
    public long remainingItemTypes() {
        return this.fProxy.barrelGetItem(this.te) == null ? 1L : 0L;
    }

    @Override
    public long remainingItemCount() {
        return this.fProxy.barrelGetMaxItemCount(this.te) - this.fProxy.barrelGetItemCount(this.te);
    }

    @Override
    public boolean containsItemType(IAEItemStack i) {
        return i.equals(this.fProxy.barrelGetItem(this.te));
    }

    @Override
    public long getTotalItemTypes() {
        return 1L;
    }

    @Override
    public long countOfItemType(IAEItemStack i) {
        return i.equals(this.fProxy.barrelGetItem(this.te)) ? this.storedItemCount() : 0L;
    }

    @Override
    public IAEItemStack addItems(IAEItemStack input) {
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        ItemStack shared = Platform.getSharedItemStack(input);
        if (shared.func_77951_h()) {
            return input;
        }
        if (this.remainingItemTypes() > 0L) {
            this.fProxy.setItemType(this.te, input.getItemStack());
        }
        if (this.containsItemType(input)) {
            int max = this.fProxy.barrelGetMaxItemCount(this.te);
            int newTotal = (int)this.storedItemCount() + (int)input.getStackSize();
            if (newTotal > max) {
                this.fProxy.barrelSetCount(this.te, max);
                IAEItemStack result = input.copy();
                result.setStackSize(newTotal - max);
                return result;
            }
            this.fProxy.barrelSetCount(this.te, newTotal);
            return null;
        }
        return input;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request) {
        if (this.containsItemType(request)) {
            int howMany = (int)this.storedItemCount();
            if (request.getStackSize() >= (long)howMany) {
                this.fProxy.setItemType(this.te, null);
                this.fProxy.barrelSetCount(this.te, 0);
                IAEItemStack r = request.copy();
                r.setStackSize(howMany);
                return r;
            }
            this.fProxy.barrelSetCount(this.te, (int)((long)howMany - request.getStackSize()));
            return request.copy();
        }
        return null;
    }

    @Override
    public IItemList getAvailableItems(IItemList out) {
        ItemStack i = this.fProxy.barrelGetItem(this.te);
        if (i != null) {
            i.field_77994_a = this.fProxy.barrelGetItemCount(this.te);
            out.addStorage(AEItemStack.create(i));
        }
        return out;
    }

    @Override
    public IAEItemStack calculateItemAddition(IAEItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.getStackSize() == 0L) {
            return null;
        }
        ItemStack shared = Platform.getSharedItemStack(stack);
        if (shared.func_77951_h()) {
            return stack;
        }
        if (this.remainingItemTypes() > 0L || this.containsItemType(stack)) {
            int max = this.fProxy.barrelGetMaxItemCount(this.te);
            int newTotal = (int)this.storedItemCount() + (int)stack.getStackSize();
            if (newTotal > max) {
                IAEItemStack result = stack.copy();
                result.setStackSize(newTotal - max);
                return result;
            }
            return null;
        }
        return stack;
    }

    @Override
    public long getAvailableSpaceByItem(IAEItemStack i, long maxNeeded) {
        if (this.containsItemType(i) || this.remainingItemTypes() > 0L) {
            return this.remainingItemCount();
        }
        return 0L;
    }

    @Override
    public IItemList getAvailableItems() {
        return this.getAvailableItems(new ItemList());
    }
}

