/*
 * Decompiled with CFR 0.152.
 */
package appeng.tech1.tile;

import appeng.api.IAEItemStack;
import appeng.api.IAppEngGrinderRecipe;
import appeng.api.Materials;
import appeng.api.WorldCoord;
import appeng.common.AppEng;
import appeng.common.AppEngInternalInventory;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngTile;
import appeng.common.network.IAppEngNetworkTile;
import appeng.me.MEIInventoryWrapper;
import appeng.util.InventoryAdaptor;
import appeng.util.ItemList;
import appeng.util.Platform;
import appeng.util.inv.WrapperInventoryRange;
import appeng.util.inv.WrapperMCISidedInventory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileGrinder
extends AppEngTile
implements ISidedInventory,
IAppEngNetworkTile {
    ForgeDirection orientation;
    public AppEngInternalInventory storage;
    int cycle = 0;
    int Times = 0;
    int[] outputs = new int[]{3, 4, 5};
    int[] inputs = new int[]{0, 1, 2};
    int[] squat = new int[0];

    public TileGrinder() {
        this.storage = new AppEngInternalInventory(this, 7);
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return true;
    }

    @Override
    public void updateTileEntity() {
        if (this.storage.func_70301_a(6) != null && this.cycle++ % 8 == 0 && Platform.isSameItem(Materials.testItem, this.storage.func_70301_a(6))) {
            ItemStack r = new ItemStack(Block.field_71978_w);
            NBTTagCompound p = Platform.openNbtData(r);
            r.field_77994_a = 64;
            NBTTagCompound display = new NBTTagCompound();
            display.func_74778_a("Name", "EVIL: " + Integer.toString(Platform.getRandomInt()));
            p.func_74766_a("display", display);
            InventoryAdaptor sia = InventoryAdaptor.getAdaptor(new WrapperInventoryRange((IInventory)this, 3, 3, true), ForgeDirection.EAST);
            ItemStack notAdded = sia.addItems(r);
            if (notAdded != null) {
                WorldCoord wc = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                wc.add(this.orientation, 1);
                ArrayList<ItemStack> out = new ArrayList<ItemStack>();
                out.add(notAdded);
                Platform.spawnDrops(this.field_70331_k, wc.x, wc.y, wc.z, out);
            }
        }
    }

    @Override
    public boolean getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        if (this.storage.func_70301_a(6) != null) {
            drops.add(this.storage.func_70301_a(6));
        }
        return false;
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return AppEngTextureRegistry.Blocks.BlockGrinderBottom.get();
        }
        if (side == ForgeDirection.UP) {
            return AppEngTextureRegistry.Blocks.BlockGrinderTop.get();
        }
        if (this.orientation == side) {
            return AppEngTextureRegistry.Blocks.BlockGrinderFace.get();
        }
        return AppEngTextureRegistry.Blocks.BlockGrinderSide.get();
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        try {
            this.orientation = this.getDirectionFromAERotation((byte)par1nbtTagCompound.func_74762_e("rotation"));
        }
        catch (Exception err) {
            // empty catch block
        }
        NBTTagCompound stor = par1nbtTagCompound.func_74775_l("it");
        if (stor != null) {
            this.storage.readFromNBT(stor);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("rotation", (int)this.getAERotationFromDirection(this.orientation));
        NBTTagCompound it = new NBTTagCompound();
        if (this.storage != null) {
            this.storage.writeToNBT(it);
        }
        par1nbtTagCompound.func_74766_a("it", it);
    }

    @Override
    public void placedBy(EntityLivingBase entityliving) {
        byte l = (byte)(MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3);
        this.orientation = this.getDirectionFromAERotation(l);
    }

    public void applyForce(int f) {
        if (Platform.isClient()) {
            return;
        }
        this.Times += f;
        ItemStack processing = this.storage.func_70301_a(6);
        IAppEngGrinderRecipe r = AppEng.getApiInstance().getGrinderRecipeManage().getRecipeForInput(processing);
        if (r != null && this.Times >= r.getEnergyCost()) {
            this.Times = 0;
            InventoryAdaptor sia = InventoryAdaptor.getAdaptor(new WrapperInventoryRange((IInventory)this, 3, 3, true), ForgeDirection.EAST);
            ItemStack notAdded = sia.addItems(r.getOutput());
            if (notAdded != null) {
                WorldCoord wc = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                wc.add(this.orientation, 1);
                ArrayList<ItemStack> out = new ArrayList<ItemStack>();
                out.add(notAdded);
                Platform.spawnDrops(this.field_70331_k, wc.x, wc.y, wc.z, out);
            }
            this.storage.func_70299_a(6, null);
            this.markForUpdate();
        }
    }

    public boolean beginForceApplication() {
        if (null == this.storage.func_70301_a(6)) {
            this.Times = 0;
            MEIInventoryWrapper input = new MEIInventoryWrapper(new WrapperMCISidedInventory(this, ForgeDirection.NORTH), null);
            for (IAEItemStack i : input.getAvailableItems(new ItemList())) {
                IAppEngGrinderRecipe r = AppEng.getApiInstance().getGrinderRecipeManage().getRecipeForInput(i.getItemStack());
                if (r == null || i.getStackSize() < (long)r.getInput().field_77994_a) continue;
                i = i.copy();
                i.setStackSize(r.getInput().field_77994_a);
                IAEItemStack ais = input.extractItems(i);
                if (ais != null) {
                    this.storage.func_70299_a(6, ais.getItemStack());
                }
                this.markForUpdate();
                return true;
            }
            return false;
        }
        return true;
    }

    public int func_70302_i_() {
        return 6;
    }

    public ItemStack func_70301_a(int var1) {
        return this.storage.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.storage.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.storage.func_70299_a(var1, var2);
    }

    public String func_70303_b() {
        return "grinder";
    }

    public int func_70297_j_() {
        return this.storage.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int s) {
        ForgeDirection side = ForgeDirection.getOrientation((int)s);
        if (side == ForgeDirection.UP) {
            return this.squat;
        }
        if (side == ForgeDirection.DOWN) {
            return this.outputs;
        }
        return this.inputs;
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        ForgeDirection oldOri = this.orientation;
        this.orientation = this.getDirectionFromAERotation(stream.readByte());
        return oldOri != this.orientation;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        data.writeByte(this.getAERotationFromDirection(this.orientation));
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i < 3) {
            return AppEng.getApiInstance().getGrinderRecipeManage().getRecipeForInput(itemstack) != null;
        }
        return false;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.isCommonUseableByPlayer(entityplayer);
    }
}

