/*
 * Decompiled with CFR 0.152.
 */
package appeng.tools;

import appeng.common.AppEngConfiguration;
import appeng.interfaces.IElectricChargeable;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.ICustomElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public final class ElectricBaseImplementation
implements IElectricChargeable {
    Item ref;
    final float UERatio = 0.2f;

    public ElectricBaseImplementation(Item i) {
        this.ref = i;
    }

    public boolean canShowChargeToolTip(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getStoredAEPower(ItemStack i) {
        if (!AppEngConfiguration.requirePower) {
            return this.getMaxPower();
        }
        NBTTagCompound data = Platform.openNbtData(i);
        double dbl = data.func_74764_b("powerLevel") ? data.func_74769_h("powerLevel") : 0.0;
        return dbl;
    }

    @Override
    public void setMaxPower(ItemStack i) {
        NBTTagCompound data = Platform.openNbtData(i);
        data.func_74780_a("powerLevel", this.getMaxPower());
    }

    @Override
    public float addEnergy(ItemStack target, float energy) {
        float extra = 0.0f;
        float rate = this.getTransferLimit(target) * 2;
        if (energy > rate) {
            extra = energy - rate;
            energy = rate;
        }
        return extra + (energy - (float)this.modifyPowerLevel(target, energy, false));
    }

    @Override
    public boolean isChargeable(ItemStack it) {
        return true;
    }

    public double getMaxPower() {
        return 200000.0;
    }

    public double modifyPowerLevel(ItemStack i, double change, boolean simulate) {
        if (!AppEngConfiguration.requirePower) {
            return change;
        }
        NBTTagCompound data = Platform.openNbtData(i);
        double power = data.func_74764_b("powerLevel") ? data.func_74769_h("powerLevel") : 0.0;
        double newPower = change + power;
        if (newPower < 0.0) {
            newPower = 0.0;
        }
        if (newPower > this.getMaxPower()) {
            newPower = this.getMaxPower();
        }
        if (!simulate) {
            data.func_74780_a("powerLevel", newPower);
        }
        return newPower - power;
    }

    @Override
    public boolean use(ItemStack i, double powerusage, EntityLivingBase user, boolean simulate) {
        if (user instanceof EntityPlayer && AppEngConfiguration.requirePower) {
            try {
                int power = (int)Math.ceil(powerusage / 2.0);
                if ((double)this.getMaxCharge(i) - this.getStoredAEPower(i) * 2.0 > (double)power) {
                    for (int x = 0; x < 4; ++x) {
                        IElectricItemManager man;
                        ItemStack is = ((EntityPlayer)user).field_71071_by.field_70460_b[x];
                        if (is == null) continue;
                        if (is.func_77973_b() instanceof IElectricItem) {
                            int tier = ((IElectricItem)is.func_77973_b()).getTier(is);
                            int eu = ElectricItem.manager.discharge(is, power, tier, true, false);
                            this.modifyPowerLevel(i, 2.0 * (double)eu, false);
                            continue;
                        }
                        if (is.func_77973_b() instanceof ICustomElectricItem) {
                            int tier = ((ICustomElectricItem)is.func_77973_b()).getTier(is);
                            this.modifyPowerLevel(i, 2.0 * (double)((ICustomElectricItem)is.func_77973_b()).discharge(is, power, tier, true, false), false);
                            continue;
                        }
                        if (!(is.func_77973_b() instanceof ISpecialElectricItem) || (man = ((ISpecialElectricItem)is.func_77973_b()).getManager(i)) == null) continue;
                        this.modifyPowerLevel(i, 2.0 * (double)man.discharge(is, power, ((ISpecialElectricItem)is.func_77973_b()).getTier(is), true, false), false);
                    }
                }
            }
            catch (Error e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Math.abs(this.modifyPowerLevel(i, -powerusage, simulate) + powerusage) < 0.01;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public int getMaxCharge(ItemStack itemStack) {
        return (int)(this.getMaxPower() / 2.0);
    }

    public int getTier(ItemStack itemStack) {
        return 0;
    }

    public int getTransferLimit(ItemStack itemStack) {
        return 512;
    }

    public int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (!AppEngConfiguration.requirePower) {
            return 0;
        }
        int extra = amount > this.getTransferLimit(itemStack) ? amount - this.getTransferLimit(itemStack) : 0;
        return (int)Math.ceil(this.modifyPowerLevel(itemStack, (amount -= extra) * 2, simulate) / 2.0);
    }

    public int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        return 0;
    }

    public boolean canUse(ItemStack itemStack, int amount) {
        return this.use(itemStack, (double)amount * 2.0, null, true);
    }

    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (!AppEngConfiguration.requirePower) {
            return 0;
        }
        float extra = (float)energy > (float)this.getTransferLimit(theItem) * 4.0f ? (float)energy - (float)this.getTransferLimit(theItem) * 4.0f : 0.0f;
        energy = (int)((float)energy - extra);
        return (int)((double)((int)this.modifyPowerLevel(theItem, (float)energy / 2.0f, simulate)) * 2.0);
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ItemStack theItem) {
        return (int)Math.floor(this.getCurrentPowerLevel(theItem) * 2.0f);
    }

    private float getCurrentPowerLevel(ItemStack theItem) {
        NBTTagCompound data = Platform.openNbtData(theItem);
        return data.func_74764_b("powerLevel") ? (float)data.func_74769_h("powerLevel") : 0.0f;
    }

    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)this.getMaxPower() * 2;
    }

    public int getChargedItemId(ItemStack itemStack) {
        return itemStack.field_77993_c;
    }

    public int getEmptyItemId(ItemStack itemStack) {
        return itemStack.field_77993_c;
    }

    public boolean isRepairable() {
        return false;
    }

    public int getItemMaxDamageFromStack(ItemStack stack) {
        return 100;
    }

    public int getItemDamageFromStackForDisplay(ItemStack stack) {
        if (AppEngConfiguration.requirePower) {
            return 100 - (int)((double)this.getCurrentPowerLevel(stack) / this.getMaxPower() * 100.0);
        }
        return 0;
    }

    public boolean isDamageable() {
        return true;
    }

    public boolean getIsRepairable(ItemStack var1, ItemStack var2) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (AppEngConfiguration.requirePower) {
            par3List.add(StatCollector.func_74838_a((String)"AppEng.GuiITooltip.Energy") + ": " + (int)this.getStoredAEPower(par1ItemStack) / 1000 + StatCollector.func_74838_a((String)"AppEng.Sizes.1000") + " / " + this.getMaxCharge(par1ItemStack) * 2 / 1000 + StatCollector.func_74838_a((String)"AppEng.Sizes.1000"));
        }
    }

    public IElectricItemManager getManager(ItemStack itemStack) {
        return (IElectricItemManager)itemStack.func_77973_b();
    }

    public int getCharge(ItemStack itemStack) {
        return (int)Math.floor(this.getStoredAEPower(itemStack) / 2.0);
    }

    public boolean use(ItemStack itemStack, int amount, EntityLivingBase entity) {
        return this.use(itemStack, amount * 2, entity, false);
    }

    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
    }

    public String getToolTip(ItemStack itemStack) {
        return null;
    }

    public float recharge(ItemStack itemStack, float energy, boolean doRecharge) {
        if (!AppEngConfiguration.requirePower) {
            return 0.0f;
        }
        float AEPowerUsed = (float)this.modifyPowerLevel(itemStack, energy / 0.2f, !doRecharge);
        return AEPowerUsed * 0.2f;
    }

    public float discharge(ItemStack itemStack, float energy, boolean doDischarge) {
        return 0.0f;
    }

    public float getElectricityStored(ItemStack theItem) {
        return 0.0f;
    }

    public float getMaxElectricityStored(ItemStack theItem) {
        return (float)((this.getMaxPower() - (double)this.getCurrentPowerLevel(theItem)) * (double)0.2f);
    }

    public void setElectricity(ItemStack itemStack, float joules) {
        this.modifyPowerLevel(itemStack, joules / 0.2f, false);
    }

    public float getTransfer(ItemStack itemStack) {
        return (float)((this.getMaxPower() - this.getStoredAEPower(itemStack)) * (double)0.2f);
    }

    public float getVoltage(ItemStack itemStack) {
        return 120.0f;
    }
}

