/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.me.tiles.IConfigureableTile;
import appeng.common.AppEng;
import appeng.common.network.packets.PacketConfigureTile;
import appeng.interfaces.IConfigEnabledTile;
import appeng.util.Platform;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;

public class ConfigureableTileUtil
implements IConfigureableTile {
    IConfigEnabledTile target;

    private void setConfig(String n, String v) {
        try {
            TileEntity te = (TileEntity)this.target;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            Packet250CustomPayload packet = null;
            try {
                packet = new PacketConfigureTile(te.field_70329_l, te.field_70330_m, te.field_70327_n, n, v).getPacket();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (Platform.isClient()) {
                PacketDispatcher.sendPacketToServer(packet);
            } else {
                AppEng.getInstance().SideProxy.sendToAllNearExcept(null, te.field_70329_l, te.field_70330_m, te.field_70327_n, 64.0, te.field_70331_k, (Packet)packet);
            }
        }
        catch (Exception err) {
            FMLLog.severe((String)"[AppEng] Recovered from possible crash in descritibe packet generation.", (Object[])new Object[0]);
            err.printStackTrace();
        }
    }

    public ConfigureableTileUtil(IConfigEnabledTile te) {
        this.target = te;
    }

    @Override
    public String prevConfiguration(String name) {
        String x = this.target.getConfigManager().prevConfiguration(name);
        this.setConfig(name, x);
        return x;
    }

    @Override
    public String nextConfiguration(String name) {
        String x = this.target.getConfigManager().nextConfiguration(name);
        this.setConfig(name, x);
        return x;
    }

    @Override
    public List<String> getConfigurations() {
        return this.target.getConfigManager().getConfigurations();
    }

    @Override
    public List<String> getConfiguationOptions(String name) {
        return this.target.getConfigManager().getConfiguationOptions(name);
    }

    @Override
    public String setConfiguration(String name, String value) {
        String x = this.target.getConfigManager().setConfiguration(name, value);
        this.setConfig(name, value);
        return x;
    }

    @Override
    public String getConfiguration(String name) {
        return this.target.getConfigManager().getConfiguration(name);
    }
}

