/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.common.AppEngConfiguration;
import appeng.util.AEItemStack;
import appeng.util.ItemListIterator;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;

public final class ItemList
implements IItemList {
    private final TreeMap<IAEItemStack, IAEItemStack> records = new TreeMap();
    private int currentPriority = Integer.MIN_VALUE;
    int iteration = Integer.MIN_VALUE;
    public Throwable stacktrace;

    @Override
    public void setCurrentPriority(int priority) {
        this.currentPriority = priority;
    }

    @Override
    public synchronized void add(IAEItemStack option) {
        if (option == null) {
            return;
        }
        IAEItemStack st = this.records.get(option);
        ((AEItemStack)option).priority = this.currentPriority;
        if (st != null) {
            st.add(option);
            return;
        }
        IAEItemStack opt = option.copy();
        this.records.put(opt, opt);
    }

    @Override
    public synchronized void addStorage(IAEItemStack option) {
        if (option == null) {
            return;
        }
        IAEItemStack st = this.records.get(option);
        ((AEItemStack)option).priority = this.currentPriority;
        if (st != null) {
            st.incStackSize(option.getStackSize());
            return;
        }
        IAEItemStack opt = option.copy();
        this.records.put(opt, opt);
    }

    @Override
    public synchronized void addCrafting(IAEItemStack option) {
        if (option == null) {
            return;
        }
        IAEItemStack st = this.records.get(option);
        ((AEItemStack)option).priority = this.currentPriority;
        if (st != null) {
            st.setCraftable(true);
            return;
        }
        IAEItemStack beef = option.copy();
        beef.setStackSize(0L);
        beef.setCraftable(true);
        this.records.put(beef, beef);
    }

    @Override
    public synchronized void addRequestable(IAEItemStack option) {
        if (option == null) {
            return;
        }
        IAEItemStack st = this.records.get(option);
        ((AEItemStack)option).priority = this.currentPriority;
        if (st != null) {
            st.setCountRequestable(st.getCountRequestable() + option.getCountRequestable());
            return;
        }
        IAEItemStack beef = option.copy();
        beef.setStackSize(0L);
        beef.setCraftable(false);
        beef.setCountRequestable(beef.getCountRequestable());
        this.records.put(beef, beef);
    }

    @Override
    public synchronized List<ItemStack> getItems() {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            out.add(((IAEItemStack)i.next()).getItemStack());
        }
        return out;
    }

    @Override
    public synchronized IAEItemStack getFirstItem() {
        ArrayList out = new ArrayList();
        Iterator i = this.iterator();
        boolean x = false;
        if (i.hasNext()) {
            return (IAEItemStack)i.next();
        }
        return null;
    }

    public synchronized List<ItemStack> getSharedItems() {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            out.add(Platform.getSharedItemStack((IAEItemStack)i.next()));
        }
        return out;
    }

    public synchronized void resetStatus() {
        for (IAEItemStack i : this) {
            i.reset();
        }
    }

    public synchronized void clean() {
        if (AppEngConfiguration.logConcurrentModificationExceptions) {
            try {
                throw new RuntimeException("Marking Location.");
            }
            catch (Throwable e) {
                ++this.iteration;
                this.stacktrace = e;
            }
        }
        Iterator i = this.iterator();
        while (i.hasNext()) {
            IAEItemStack AEI = (IAEItemStack)i.next();
            if (AEI.isMeaninful()) continue;
            i.remove();
        }
    }

    @Override
    public synchronized Iterator iterator() {
        if (AppEngConfiguration.logConcurrentModificationExceptions) {
            return new ItemListIterator(this, this.records.values().iterator());
        }
        return this.records.values().iterator();
    }

    @Override
    public synchronized IAEItemStack findItem(IAEItemStack i) {
        if (i == null) {
            return null;
        }
        IAEItemStack is = this.records.get(i);
        if (is != null) {
            return is;
        }
        return null;
    }

    @Override
    public synchronized int size() {
        return this.records.values().size();
    }
}

