/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client.modloader;

import com.google.common.base.Equivalence;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import cpw.mods.fml.client.modloader.ModLoaderBlockRendererHandler;
import cpw.mods.fml.client.modloader.ModLoaderKeyBindingHandler;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.modloader.BaseModProxy;
import cpw.mods.fml.common.modloader.IModLoaderSidedHelper;
import cpw.mods.fml.common.modloader.ModLoaderHelper;
import cpw.mods.fml.common.modloader.ModLoaderModContainer;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class ModLoaderClientHelper
implements IModLoaderSidedHelper {
    private atv client;
    private static Multimap<ModLoaderModContainer, ModLoaderKeyBindingHandler> keyBindingContainers;
    private Map<cm, ez> managerLookups = new MapMaker().weakKeys().weakValues().makeMap();

    public static int obtainBlockModelIdFor(BaseMod mod, boolean inventoryRenderer) {
        int renderId = RenderingRegistry.getNextAvailableRenderId();
        ModLoaderBlockRendererHandler bri = new ModLoaderBlockRendererHandler(renderId, inventoryRenderer, mod);
        RenderingRegistry.registerBlockHandler(bri);
        return renderId;
    }

    public static void handleFinishLoadingFor(ModLoaderModContainer mc, atv game) {
        FMLLog.log(mc.getModId(), Level.FINE, "Handling post startup activities for ModLoader mod %s", mc.getModId());
        BaseMod mod = (BaseMod)mc.getMod();
        HashMap<Class<? extends nn>, bgm> renderers = Maps.newHashMap(bgl.a.q);
        try {
            FMLLog.log(mc.getModId(), Level.FINEST, "Requesting renderers from basemod %s", mc.getModId());
            mod.addRenderer(renderers);
            FMLLog.log(mc.getModId(), Level.FINEST, "Received %d renderers from basemod %s", renderers.size(), mc.getModId());
        }
        catch (Exception e2) {
            FMLLog.log(mc.getModId(), Level.SEVERE, e2, "A severe problem was detected with the mod %s during the addRenderer call. Continuing, but expect odd results", mc.getModId());
        }
        MapDifference<Class<? extends nn>, Object> difference = Maps.difference(bgl.a.q, renderers, Equivalence.identity());
        for (Map.Entry<Class<? extends nn>, Object> entry : difference.entriesOnlyOnLeft().entrySet()) {
            FMLLog.log(mc.getModId(), Level.WARNING, "The mod %s attempted to remove an entity renderer %s from the entity map. This will be ignored.", mc.getModId(), entry.getKey().getName());
        }
        for (Map.Entry<Class<? extends nn>, Object> entry : difference.entriesOnlyOnRight().entrySet()) {
            FMLLog.log(mc.getModId(), Level.FINEST, "Registering ModLoader entity renderer %s as instance of %s", entry.getKey().getName(), ((bgm)entry.getValue()).getClass().getName());
            RenderingRegistry.registerEntityRenderingHandler(entry.getKey(), (bgm)entry.getValue());
        }
        for (Map.Entry<Class<? extends nn>, Object> entry : difference.entriesDiffering().entrySet()) {
            FMLLog.log(mc.getModId(), Level.FINEST, "Registering ModLoader entity rendering override for %s as instance of %s", entry.getKey().getName(), ((bgm)((MapDifference.ValueDifference)entry.getValue()).rightValue()).getClass().getName());
            RenderingRegistry.registerEntityRenderingHandler(entry.getKey(), (bgm)((MapDifference.ValueDifference)entry.getValue()).rightValue());
        }
        try {
            mod.registerAnimation(game);
        }
        catch (Exception e4) {
            FMLLog.log(mc.getModId(), Level.SEVERE, e4, "A severe problem was detected with the mod %s during the registerAnimation call. Continuing, but expect odd results", mc.getModId());
        }
    }

    public ModLoaderClientHelper(atv client) {
        this.client = client;
        ModLoaderHelper.sidedHelper = this;
        keyBindingContainers = Multimaps.newMultimap(Maps.newHashMap(), new Supplier<Collection<ModLoaderKeyBindingHandler>>(){

            @Override
            public Collection<ModLoaderKeyBindingHandler> get() {
                return Collections.singleton(new ModLoaderKeyBindingHandler());
            }
        });
    }

    @Override
    public void finishModLoading(ModLoaderModContainer mc) {
        ModLoaderClientHelper.handleFinishLoadingFor(mc, this.client);
    }

    public static void registerKeyBinding(BaseModProxy mod, ats keyHandler, boolean allowRepeat) {
        ModLoaderModContainer mlmc = (ModLoaderModContainer)Loader.instance().activeModContainer();
        ModLoaderKeyBindingHandler handler = Iterables.getOnlyElement(keyBindingContainers.get(mlmc));
        handler.setModContainer(mlmc);
        handler.addKeyBinding(keyHandler, allowRepeat);
        KeyBindingRegistry.registerKeyBinding(handler);
    }

    @Override
    public Object getClientGui(BaseModProxy mod, uf player, int ID, int x, int y2, int z2) {
        return ((BaseMod)mod).getContainerGUI((bdi)player, ID, x, y2, z2);
    }

    @Override
    public nn spawnEntity(BaseModProxy mod, EntitySpawnPacket input, EntityRegistry.EntityRegistration er2) {
        return ((BaseMod)mod).spawnEntity(er2.getModEntityId(), (abw)this.client.f, input.scaledX, input.scaledY, input.scaledZ);
    }

    @Override
    public void sendClientPacket(BaseModProxy mod, ea packet) {
        ((BaseMod)mod).clientCustomPayload(this.client.h.a, packet);
    }

    @Override
    public void clientConnectionOpened(ez netClientHandler, cm manager, BaseModProxy mod) {
        this.managerLookups.put(manager, netClientHandler);
        ((BaseMod)mod).clientConnect((bcw)netClientHandler);
    }

    @Override
    public boolean clientConnectionClosed(cm manager, BaseModProxy mod) {
        if (this.managerLookups.containsKey(manager)) {
            ((BaseMod)mod).clientDisconnect((bcw)this.managerLookups.get(manager));
            return true;
        }
        return false;
    }
}

