/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLHandledException;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLEvent;
import cpw.mods.fml.common.event.FMLLoadEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import cpw.mods.fml.common.functions.ArtifactVersionNameFunction;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoadController {
    private Loader loader;
    private EventBus masterChannel;
    private ImmutableMap<String, EventBus> eventChannels;
    private LoaderState state;
    private Multimap<String, LoaderState.ModState> modStates = ArrayListMultimap.create();
    private Multimap<String, Throwable> errors = ArrayListMultimap.create();
    private Map<String, ModContainer> modList;
    private List<ModContainer> activeModList = Lists.newArrayList();
    private ModContainer activeContainer;
    private BiMap<ModContainer, Object> modObjectList;

    public LoadController(Loader loader) {
        this.loader = loader;
        this.masterChannel = new EventBus("FMLMainChannel");
        this.masterChannel.register(this);
        this.state = LoaderState.NOINIT;
    }

    @Subscribe
    public void buildModList(FMLLoadEvent event) {
        this.modList = this.loader.getIndexedModList();
        ImmutableMap.Builder<String, EventBus> eventBus = ImmutableMap.builder();
        for (ModContainer mod : this.loader.getModList()) {
            FMLRelaunchLog.makeLog(mod.getModId());
            Logger modLogger = Logger.getLogger(mod.getModId());
            Logger eventLog = Logger.getLogger(EventBus.class.getName() + "." + mod.getModId());
            eventLog.setParent(modLogger);
            EventBus bus = new EventBus(mod.getModId());
            boolean isActive = mod.registerBus(bus, this);
            if (isActive) {
                Level level = Logger.getLogger(mod.getModId()).getLevel();
                FMLLog.log(mod.getModId(), Level.FINE, "Mod Logging channel %s configured at %s level.", mod.getModId(), level == null ? "default" : level);
                FMLLog.log(mod.getModId(), Level.INFO, "Activating mod %s", mod.getModId());
                this.activeModList.add(mod);
                this.modStates.put(mod.getModId(), LoaderState.ModState.UNLOADED);
                eventBus.put(mod.getModId(), bus);
                FMLCommonHandler.instance().addModToResourcePack(mod);
                continue;
            }
            FMLLog.log(mod.getModId(), Level.WARNING, "Mod %s has been disabled through configuration", mod.getModId());
            this.modStates.put(mod.getModId(), LoaderState.ModState.UNLOADED);
            this.modStates.put(mod.getModId(), LoaderState.ModState.DISABLED);
        }
        this.eventChannels = eventBus.build();
        FMLCommonHandler.instance().updateResourcePackList();
    }

    public void distributeStateMessage(LoaderState state, Object ... eventData) {
        if (state.hasEvent()) {
            this.masterChannel.post(state.getEvent(eventData));
        }
    }

    public void transition(LoaderState desiredState, boolean forceState) {
        LoaderState oldState = this.state;
        this.state = this.state.transition(!this.errors.isEmpty());
        if (this.state != desiredState && !forceState) {
            Throwable toThrow = null;
            FMLLog.severe("Fatal errors were detected during the transition from %s to %s. Loading cannot continue", new Object[]{oldState, desiredState});
            StringBuilder sb2 = new StringBuilder();
            this.printModStates(sb2);
            FMLLog.getLogger().severe(sb2.toString());
            if (this.errors.size() > 0) {
                FMLLog.severe("The following problems were captured during this phase", new Object[0]);
                for (Map.Entry<String, Throwable> error : this.errors.entries()) {
                    FMLLog.log(Level.SEVERE, error.getValue(), "Caught exception from %s", error.getKey());
                    if (error.getValue() instanceof IFMLHandledException) {
                        toThrow = error.getValue();
                        continue;
                    }
                    if (toThrow != null) continue;
                    toThrow = error.getValue();
                }
            } else {
                FMLLog.severe("The ForgeModLoader state engine has become corrupted. Probably, a state was missed by and invalid modification to a base classForgeModLoader depends on. This is a critical error and not recoverable. Investigate any modifications to base classes outside ofForgeModLoader, especially Optifine, to see if there are fixes available.", new Object[0]);
                throw new RuntimeException("The ForgeModLoader state engine is invalid");
            }
            if (toThrow != null && toThrow instanceof RuntimeException) {
                throw (RuntimeException)toThrow;
            }
            throw new LoaderException(toThrow);
        }
        if (this.state != desiredState && forceState) {
            FMLLog.info("The state engine was in incorrect state %s and forced into state %s. Errors may have been discarded.", new Object[]{this.state, desiredState});
            this.forceState(desiredState);
        }
    }

    public ModContainer activeContainer() {
        return this.activeContainer;
    }

    @Subscribe
    public void propogateStateMessage(FMLEvent stateEvent) {
        if (stateEvent instanceof FMLPreInitializationEvent) {
            this.modObjectList = this.buildModObjectList();
        }
        for (ModContainer mc : this.activeModList) {
            this.sendEventToModContainer(stateEvent, mc);
        }
    }

    private void sendEventToModContainer(FMLEvent stateEvent, ModContainer mc) {
        String modId = mc.getModId();
        Collection<String> requirements = Collections2.transform(mc.getRequirements(), new ArtifactVersionNameFunction());
        for (ArtifactVersion av2 : mc.getDependencies()) {
            if (av2.getLabel() == null || !requirements.contains(av2.getLabel()) || !this.modStates.containsEntry(av2.getLabel(), (Object)LoaderState.ModState.ERRORED)) continue;
            FMLLog.log(modId, Level.SEVERE, "Skipping event %s and marking errored mod %s since required dependency %s has errored", stateEvent.getEventType(), modId, av2.getLabel());
            this.modStates.put(modId, LoaderState.ModState.ERRORED);
            return;
        }
        this.activeContainer = mc;
        stateEvent.applyModContainer(this.activeContainer());
        FMLLog.log(modId, Level.FINEST, "Sending event %s to mod %s", stateEvent.getEventType(), modId);
        this.eventChannels.get(modId).post(stateEvent);
        FMLLog.log(modId, Level.FINEST, "Sent event %s to mod %s", stateEvent.getEventType(), modId);
        this.activeContainer = null;
        if (stateEvent instanceof FMLStateEvent) {
            if (!this.errors.containsKey(modId)) {
                this.modStates.put(modId, ((FMLStateEvent)stateEvent).getModState());
            } else {
                this.modStates.put(modId, LoaderState.ModState.ERRORED);
            }
        }
    }

    public ImmutableBiMap<ModContainer, Object> buildModObjectList() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (ModContainer mc : this.activeModList) {
            if (!mc.isImmutable() && mc.getMod() != null) {
                builder.put(mc, mc.getMod());
            }
            if (mc.getMod() != null || mc.isImmutable() || this.state == LoaderState.CONSTRUCTING) continue;
            FMLLog.severe("There is a severe problem with %s - it appears not to have constructed correctly", mc.getModId());
            if (this.state == LoaderState.CONSTRUCTING) continue;
            this.errorOccurred(mc, new RuntimeException());
        }
        return builder.build();
    }

    public void errorOccurred(ModContainer modContainer, Throwable exception) {
        if (exception instanceof InvocationTargetException) {
            this.errors.put(modContainer.getModId(), ((InvocationTargetException)exception).getCause());
        } else {
            this.errors.put(modContainer.getModId(), exception);
        }
    }

    public void printModStates(StringBuilder ret) {
        for (ModContainer mc : this.loader.getModList()) {
            ret.append("\n\t").append(mc.getModId()).append("{").append(mc.getVersion()).append("} [").append(mc.getName()).append("] (").append(mc.getSource().getName()).append(") ");
            Joiner.on("->").appendTo(ret, (Iterable<?>)this.modStates.get(mc.getModId()));
        }
    }

    public List<ModContainer> getActiveModList() {
        return this.activeModList;
    }

    public LoaderState.ModState getModState(ModContainer selectedMod) {
        return Iterables.getLast(this.modStates.get(selectedMod.getModId()), LoaderState.ModState.AVAILABLE);
    }

    public void distributeStateMessage(Class<?> customEvent) {
        try {
            this.masterChannel.post(customEvent.newInstance());
        }
        catch (Exception e2) {
            FMLLog.log(Level.SEVERE, e2, "An unexpected exception", new Object[0]);
            throw new LoaderException(e2);
        }
    }

    public BiMap<ModContainer, Object> getModObjectList() {
        if (this.modObjectList == null) {
            FMLLog.severe("Detected an attempt by a mod %s to perform game activity during mod construction. This is a serious programming error.", this.activeContainer);
            return this.buildModObjectList();
        }
        return ImmutableBiMap.copyOf(this.modObjectList);
    }

    public boolean isInState(LoaderState state) {
        return this.state == state;
    }

    boolean hasReachedState(LoaderState state) {
        return this.state.ordinal() >= state.ordinal() && this.state != LoaderState.ERRORED;
    }

    void forceState(LoaderState newState) {
        this.state = newState;
    }
}

