/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import argo.jdom.JdomParser;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import argo.saj.InvalidSyntaxException;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModMetadata;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.logging.Level;

public class MetadataCollection {
    private static JdomParser parser = new JdomParser();
    private Map<String, ModMetadata> metadatas = Maps.newHashMap();
    private int metadataVersion = 1;

    public static MetadataCollection from(InputStream inputStream, String sourceName) {
        if (inputStream == null) {
            return new MetadataCollection();
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        try {
            JsonRootNode root = parser.parse(reader);
            if (root.hasElements()) {
                return MetadataCollection.parse10ModInfo(root);
            }
            return MetadataCollection.parseModInfo(root);
        }
        catch (InvalidSyntaxException e2) {
            FMLLog.log(Level.SEVERE, e2, "The mcmod.info file in %s cannot be parsed as valid JSON. It will be ignored", sourceName);
            return new MetadataCollection();
        }
        catch (Exception e3) {
            throw Throwables.propagate(e3);
        }
    }

    private static MetadataCollection parseModInfo(JsonRootNode root) {
        MetadataCollection mc = new MetadataCollection();
        mc.metadataVersion = Integer.parseInt(root.getNumberValue("modinfoversion"));
        mc.parseModMetadataList(root.getNode("modlist"));
        return mc;
    }

    private static MetadataCollection parse10ModInfo(JsonRootNode root) {
        MetadataCollection mc = new MetadataCollection();
        mc.parseModMetadataList(root);
        return mc;
    }

    private void parseModMetadataList(JsonNode metadataList) {
        for (JsonNode node : metadataList.getElements()) {
            ModMetadata mmd = new ModMetadata(node);
            this.metadatas.put(mmd.modId, mmd);
        }
    }

    public ModMetadata getMetadataForId(String modId, Map<String, Object> extraData) {
        if (!this.metadatas.containsKey(modId)) {
            ModMetadata dummy = new ModMetadata();
            dummy.modId = modId;
            dummy.name = (String)extraData.get("name");
            dummy.version = (String)extraData.get("version");
            dummy.autogenerated = true;
            this.metadatas.put(modId, dummy);
        }
        return this.metadatas.get(modId);
    }
}

