/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm.transformers;

import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class SideTransformer
implements IClassTransformer {
    private static String SIDE = FMLLaunchHandler.side().name();
    private static final boolean DEBUG = false;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        if (this.remove(classNode.visibleAnnotations, SIDE)) {
            throw new RuntimeException(String.format("Attempted to load class %s for invalid side %s", classNode.name, SIDE));
        }
        Iterator fields = classNode.fields.iterator();
        while (fields.hasNext()) {
            FieldNode field = (FieldNode)fields.next();
            if (!this.remove(field.visibleAnnotations, SIDE)) continue;
            fields.remove();
        }
        Iterator methods = classNode.methods.iterator();
        while (methods.hasNext()) {
            MethodNode method = (MethodNode)methods.next();
            if (!this.remove(method.visibleAnnotations, SIDE)) continue;
            methods.remove();
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private boolean remove(List<AnnotationNode> anns, String side) {
        if (anns == null) {
            return false;
        }
        for (AnnotationNode ann2 : anns) {
            if (!ann2.desc.equals(Type.getDescriptor(SideOnly.class)) || ann2.values == null) continue;
            for (int x = 0; x < ann2.values.size() - 1; x += 2) {
                Object key = ann2.values.get(x);
                Object value = ann2.values.get(x + 1);
                if (!(key instanceof String) || !key.equals("value") || !(value instanceof String[]) || ((String[])value)[1].equals(side)) continue;
                return true;
            }
        }
        return false;
    }
}

