/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public abstract class BlockFluidBase
extends aqz
implements IFluidBlock {
    protected static final Map<Integer, Boolean> defaultDisplacementIds = new HashMap<Integer, Boolean>();
    protected Map<Integer, Boolean> displacementIds = new HashMap<Integer, Boolean>();
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected int renderPass = 1;
    protected int maxScaledLight = 0;
    protected final String fluidName;

    public BlockFluidBase(int id2, Fluid fluid, akc material) {
        super(id2, material);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.b(true);
        this.C();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlockID(id2);
        this.displacementIds.putAll(defaultDisplacementIds);
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderPass(int renderPass) {
        this.renderPass = renderPass;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(acf world, int x2, int y2, int z2) {
        if (world.c(x2, y2, z2)) {
            return true;
        }
        int bId = world.a(x2, y2, z2);
        if (bId == this.cF) {
            return false;
        }
        if (this.displacementIds.containsKey(bId)) {
            return this.displacementIds.get(bId);
        }
        akc material = aqz.s[bId].cU;
        if (material.c() || material == akc.D) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, x2, y2, z2);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(abw world, int x2, int y2, int z2) {
        if (world.c(x2, y2, z2)) {
            return true;
        }
        int bId = world.a(x2, y2, z2);
        if (bId == this.cF) {
            return false;
        }
        if (this.displacementIds.containsKey(bId)) {
            if (this.displacementIds.get(bId).booleanValue()) {
                aqz.s[bId].c(world, x2, y2, z2, world.h(x2, y2, z2), 0);
                return true;
            }
            return false;
        }
        akc material = aqz.s[bId].cU;
        if (material.c() || material == akc.D) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, x2, y2, z2);
        if (density == Integer.MAX_VALUE) {
            aqz.s[bId].c(world, x2, y2, z2, world.h(x2, y2, z2), 0);
            return true;
        }
        return this.density > density;
    }

    public abstract int getQuantaValue(acf var1, int var2, int var3, int var4);

    @Override
    public abstract boolean a(int var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    @Override
    public void a(abw world, int x2, int y2, int z2) {
        world.a(x2, y2, z2, this.cF, this.tickRate);
    }

    @Override
    public void a(abw world, int x2, int y2, int z2, int blockId) {
        world.a(x2, y2, z2, this.cF, this.tickRate);
    }

    @Override
    public boolean l() {
        return false;
    }

    @Override
    public boolean b(acf world, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public asx b(abw world, int x2, int y2, int z2) {
        return null;
    }

    @Override
    public int a(int par1, Random par2Random, int par3) {
        return 0;
    }

    @Override
    public int a(Random par1Random) {
        return 0;
    }

    @Override
    public int a(abw world) {
        return this.tickRate;
    }

    @Override
    public void a(abw world, int x2, int y2, int z2, nn entity, atc vec) {
        if (this.densityDir > 0) {
            return;
        }
        atc vec_flow = this.getFlowVector(world, x2, y2, z2);
        vec.c += vec_flow.c * (double)(this.quantaPerBlock * 4);
        vec.d += vec_flow.d * (double)(this.quantaPerBlock * 4);
        vec.e += vec_flow.e * (double)(this.quantaPerBlock * 4);
    }

    public int getLightValue(acf world, int x2, int y2, int z2) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, x2, y2, z2);
        }
        int data = world.h(x2, y2, z2);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    @Override
    public int d() {
        return FluidRegistry.renderIdFluid;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    public float f(acf world, int x2, int y2, int z2) {
        float lightUp;
        float lightThis = world.q(x2, y2, z2);
        return lightThis > (lightUp = world.q(x2, y2 + 1, z2)) ? lightThis : lightUp;
    }

    public int e(acf world, int x2, int y2, int z2) {
        int lightThis = world.h(x2, y2, z2, 0);
        int lightUp = world.h(x2, y2 + 1, z2, 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    public int n() {
        return this.renderPass;
    }

    public boolean a(acf world, int x2, int y2, int z2, int side) {
        if (world.a(x2, y2, z2) != this.cF) {
            return !world.t(x2, y2, z2);
        }
        akc mat = world.g(x2, y2, z2);
        return mat == this.cU ? false : super.a(world, x2, y2, z2, side);
    }

    public static final int getDensity(acf world, int x2, int y2, int z2) {
        aqz block = aqz.s[world.a(x2, y2, z2)];
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).density;
    }

    public static final int getTemperature(acf world, int x2, int y2, int z2) {
        aqz block = aqz.s[world.a(x2, y2, z2)];
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).temperature;
    }

    public static double getFlowDirection(acf world, int x2, int y2, int z2) {
        aqz block = aqz.s[world.a(x2, y2, z2)];
        if (!world.g(x2, y2, z2).d()) {
            return -1000.0;
        }
        atc vec = ((BlockFluidBase)block).getFlowVector(world, x2, y2, z2);
        return vec.c == 0.0 && vec.e == 0.0 ? -1000.0 : Math.atan2(vec.e, vec.c) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(acf world, int x2, int y2, int z2, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, x2, y2, z2);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(acf world, int x2, int y2, int z2, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, x2, y2, z2);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(acf world, int x2, int y2, int z2) {
        int quantaRemaining = this.getQuantaValue(world, x2, y2, z2);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public atc getFlowVector(acf world, int x2, int y2, int z2) {
        atc vec = world.V().a(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, x2, y2, z2);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x22 = x2;
            int z22 = z2;
            switch (side) {
                case 0: {
                    --x22;
                    break;
                }
                case 1: {
                    --z22;
                    break;
                }
                case 2: {
                    ++x22;
                    break;
                }
                case 3: {
                    ++z22;
                }
            }
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x22, y2, z22);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.g(x22, y2, z22).c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x22, y2 - 1, z22)) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.c((x22 - x2) * power, (y2 - y2) * power, (z22 - z2) * power);
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.c((x22 - x2) * power, (y2 - y2) * power, (z22 - z2) * power);
        }
        if (world.a(x2, y2 + 1, z2) == this.cF) {
            boolean flag;
            boolean bl2 = flag = this.a_(world, x2, y2, z2 - 1, 2) || this.a_(world, x2, y2, z2 + 1, 3) || this.a_(world, x2 - 1, y2, z2, 4) || this.a_(world, x2 + 1, y2, z2, 5) || this.a_(world, x2, y2 + 1, z2 - 1, 2) || this.a_(world, x2, y2 + 1, z2 + 1, 3) || this.a_(world, x2 - 1, y2 + 1, z2, 4) || this.a_(world, x2 + 1, y2 + 1, z2, 5);
            if (flag) {
                vec = vec.a().c(0.0, -6.0, 0.0);
            }
        }
        vec = vec.a();
        return vec;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(abw world, int x2, int y2, int z2) {
        int quantaRemaining = this.getQuantaValue(world, x2, y2, z2) + 1;
        float remaining = (float)quantaRemaining / this.quantaPerBlockFloat;
        if (remaining > 1.0f) {
            remaining = 1.0f;
        }
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    static {
        defaultDisplacementIds.put(aqz.aJ.cF, false);
        defaultDisplacementIds.put(aqz.aQ.cF, false);
        defaultDisplacementIds.put(aqz.aI.cF, false);
        defaultDisplacementIds.put(aqz.aN.cF, false);
        defaultDisplacementIds.put(aqz.bc.cF, false);
    }
}

