/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Random;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidFinite
extends BlockFluidBase {
    public BlockFluidFinite(int id2, Fluid fluid, akc material) {
        super(id2, fluid, material);
    }

    @Override
    public int getQuantaValue(acf world, int x2, int y2, int z2) {
        if (world.c(x2, y2, z2)) {
            return 0;
        }
        if (world.a(x2, y2, z2) != this.cF) {
            return -1;
        }
        int quantaRemaining = world.h(x2, y2, z2) + 1;
        return quantaRemaining;
    }

    @Override
    public boolean a(int meta, boolean fullHit) {
        return fullHit && meta == this.quantaPerBlock - 1;
    }

    @Override
    public int getMaxRenderHeightMeta() {
        return this.quantaPerBlock - 1;
    }

    @Override
    public void a(abw world, int x2, int y2, int z2, Random rand) {
        int quantaRemaining;
        boolean changed = false;
        int prevRemaining = quantaRemaining = world.h(x2, y2, z2) + 1;
        if ((quantaRemaining = this.tryToFlowVerticallyInto(world, x2, y2, z2, quantaRemaining)) < 1) {
            return;
        }
        if (quantaRemaining != prevRemaining) {
            changed = true;
            if (quantaRemaining == 1) {
                world.b(x2, y2, z2, quantaRemaining - 1, 2);
                return;
            }
        } else if (quantaRemaining == 1) {
            return;
        }
        int lowerthan = quantaRemaining - 1;
        if (this.displaceIfPossible(world, x2, y2, z2 - 1)) {
            world.c(x2, y2, z2 - 1, 0);
        }
        if (this.displaceIfPossible(world, x2, y2, z2 + 1)) {
            world.c(x2, y2, z2 + 1, 0);
        }
        if (this.displaceIfPossible(world, x2 - 1, y2, z2)) {
            world.c(x2 - 1, y2, z2, 0);
        }
        if (this.displaceIfPossible(world, x2 + 1, y2, z2)) {
            world.c(x2 + 1, y2, z2, 0);
        }
        int north = this.getQuantaValueBelow(world, x2, y2, z2 - 1, lowerthan);
        int south = this.getQuantaValueBelow(world, x2, y2, z2 + 1, lowerthan);
        int west = this.getQuantaValueBelow(world, x2 - 1, y2, z2, lowerthan);
        int east = this.getQuantaValueBelow(world, x2 + 1, y2, z2, lowerthan);
        int total = quantaRemaining;
        int count = 1;
        if (north >= 0) {
            ++count;
            total += north;
        }
        if (south >= 0) {
            ++count;
            total += south;
        }
        if (west >= 0) {
            ++count;
            total += west;
        }
        if (east >= 0) {
            ++count;
            total += east;
        }
        if (count == 1) {
            if (changed) {
                world.b(x2, y2, z2, quantaRemaining - 1, 2);
            }
            return;
        }
        int each = total / count;
        int rem = total % count;
        if (north >= 0) {
            int newnorth = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++newnorth;
                --rem;
            }
            if (newnorth != north) {
                if (newnorth == 0) {
                    world.c(x2, y2, z2 - 1, 0);
                } else {
                    world.f(x2, y2, z2 - 1, this.cF, newnorth - 1, 2);
                }
                world.a(x2, y2, z2 - 1, this.cF, this.tickRate);
            }
            --count;
        }
        if (south >= 0) {
            int newsouth = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++newsouth;
                --rem;
            }
            if (newsouth != south) {
                if (newsouth == 0) {
                    world.c(x2, y2, z2 + 1, 0);
                } else {
                    world.f(x2, y2, z2 + 1, this.cF, newsouth - 1, 2);
                }
                world.a(x2, y2, z2 + 1, this.cF, this.tickRate);
            }
            --count;
        }
        if (west >= 0) {
            int newwest = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++newwest;
                --rem;
            }
            if (newwest != west) {
                if (newwest == 0) {
                    world.c(x2 - 1, y2, z2, 0);
                } else {
                    world.f(x2 - 1, y2, z2, this.cF, newwest - 1, 2);
                }
                world.a(x2 - 1, y2, z2, this.cF, this.tickRate);
            }
            --count;
        }
        if (east >= 0) {
            int neweast = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++neweast;
                --rem;
            }
            if (neweast != east) {
                if (neweast == 0) {
                    world.c(x2 + 1, y2, z2, 0);
                } else {
                    world.f(x2 + 1, y2, z2, this.cF, neweast - 1, 2);
                }
                world.a(x2 + 1, y2, z2, this.cF, this.tickRate);
            }
            --count;
        }
        if (rem > 0) {
            ++each;
        }
        world.b(x2, y2, z2, each - 1, 2);
    }

    public int tryToFlowVerticallyInto(abw world, int x2, int y2, int z2, int amtToInput) {
        int otherY = y2 + this.densityDir;
        if (otherY < 0 || otherY >= world.R()) {
            world.i(x2, y2, z2);
            return 0;
        }
        int amt2 = this.getQuantaValueBelow(world, x2, otherY, z2, this.quantaPerBlock);
        if (amt2 >= 0) {
            if ((amt2 += amtToInput) > this.quantaPerBlock) {
                world.f(x2, otherY, z2, this.cF, this.quantaPerBlock - 1, 3);
                world.a(x2, otherY, z2, this.cF, this.tickRate);
                return amt2 - this.quantaPerBlock;
            }
            if (amt2 > 0) {
                world.f(x2, otherY, z2, this.cF, amt2 - 1, 3);
                world.a(x2, otherY, z2, this.cF, this.tickRate);
                world.i(x2, y2, z2);
                return 0;
            }
            return amtToInput;
        }
        int density_other = BlockFluidFinite.getDensity(world, x2, otherY, z2);
        if (density_other == Integer.MAX_VALUE) {
            if (this.displaceIfPossible(world, x2, otherY, z2)) {
                world.f(x2, otherY, z2, this.cF, amtToInput - 1, 3);
                world.a(x2, otherY, z2, this.cF, this.tickRate);
                world.i(x2, y2, z2);
                return 0;
            }
            return amtToInput;
        }
        if (this.densityDir < 0) {
            if (density_other < this.density) {
                int bId = world.a(x2, otherY, z2);
                BlockFluidBase block = (BlockFluidBase)aqz.s[bId];
                int otherData = world.h(x2, otherY, z2);
                world.f(x2, otherY, z2, this.cF, amtToInput - 1, 3);
                world.f(x2, y2, z2, bId, otherData, 3);
                world.a(x2, otherY, z2, this.cF, this.tickRate);
                world.a(x2, y2, z2, bId, block.a(world));
                return 0;
            }
        } else if (density_other > this.density) {
            int bId = world.a(x2, otherY, z2);
            BlockFluidBase block = (BlockFluidBase)aqz.s[bId];
            int otherData = world.h(x2, otherY, z2);
            world.f(x2, otherY, z2, this.cF, amtToInput - 1, 3);
            world.f(x2, y2, z2, bId, otherData, 3);
            world.a(x2, otherY, z2, this.cF, this.tickRate);
            world.a(x2, y2, z2, bId, block.a(world));
            return 0;
        }
        return amtToInput;
    }

    @Override
    public FluidStack drain(abw world, int x2, int y2, int z2, boolean doDrain) {
        return null;
    }

    @Override
    public boolean canDrain(abw world, int x2, int y2, int z2) {
        return false;
    }
}

